/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class DockingLayoutManager
implements EBComponent {
    private static final String NO_SETTINGS_MESSAGE = "no-settings.message";
    private static final String SAVE_LAYOUT_FAILED = "save-layout-failed.message";
    private static final String LOAD_LAYOUT_TITLE = "load-layout.title";
    private static final String LOAD_LAYOUT_MESSAGE = "load-layout.message";
    private static final String SAVE_LAYOUT_TITLE = "save-layout.title";
    private static final String SAVE_LAYOUT_MESSAGE = "save-layout.message";
    private static ActionSet actions;
    private static DockingLayoutManager instance;
    private Map<View, String> currentMode = new HashMap<View, String>();
    private static final String GLOBAL_MODE = "DEFAULT";

    private DockingLayoutManager() {
    }

    private static boolean save(View view, String string) {
        DockableWindowManager.DockingLayout dockingLayout = view.getViewConfig().docking;
        if (dockingLayout != null) {
            boolean bl = dockingLayout.saveLayout(string, -1);
            if (!bl) {
                return false;
            }
            DockingLayoutManager.addAction(string);
        }
        return true;
    }

    public static void saveAs(View view) {
        if (jEdit.getSettingsDirectory() == null) {
            JOptionPane.showMessageDialog(view, jEdit.getProperty(NO_SETTINGS_MESSAGE));
            return;
        }
        String string = JOptionPane.showInputDialog(view, jEdit.getProperty(SAVE_LAYOUT_MESSAGE), jEdit.getProperty(SAVE_LAYOUT_TITLE), 3);
        if (string == null) {
            return;
        }
        if (!DockingLayoutManager.save(view, string)) {
            JOptionPane.showMessageDialog(view, jEdit.getProperty(SAVE_LAYOUT_FAILED));
        }
    }

    private static void load(View view, String string) {
        DockableWindowManager.DockingLayout dockingLayout = View.getDockingFrameworkProvider().createDockingLayout();
        if (dockingLayout.loadLayout(string, -1)) {
            view.getDockableWindowManager().setDockingLayout(dockingLayout);
        }
    }

    public static void load(View view) {
        if (jEdit.getSettingsDirectory() == null) {
            JOptionPane.showMessageDialog(view, jEdit.getProperty(NO_SETTINGS_MESSAGE));
            return;
        }
        String string = (String)JOptionPane.showInputDialog(view, jEdit.getProperty(LOAD_LAYOUT_MESSAGE), jEdit.getProperty(LOAD_LAYOUT_TITLE), 3, null, DockingLayoutManager.getSavedLayouts(), null);
        if (string == null) {
            return;
        }
        DockingLayoutManager.load(view, string);
    }

    private static String[] getSavedLayouts() {
        DockableWindowManager.DockingLayout dockingLayout = View.getDockingFrameworkProvider().createDockingLayout();
        String[] stringArray = null;
        if (dockingLayout != null) {
            stringArray = dockingLayout.getSavedLayouts();
        }
        if (stringArray == null) {
            return new String[0];
        }
        return stringArray;
    }

    private static void addAction(String string) {
        if (actions != null && !actions.contains(string)) {
            actions.addAction(new LoadPerspectiveAction(string));
        }
    }

    public static void init() {
        DockingLayoutManager.createActions();
        instance = new DockingLayoutManager();
        EditBus.addToBus(instance);
    }

    private static void createActions() {
        String[] stringArray;
        actions = new ActionSet("Docking Layouts");
        for (String string : stringArray = DockingLayoutManager.getSavedLayouts()) {
            DockingLayoutManager.addAction(string);
        }
        jEdit.addActionSet(actions);
        actions.initKeyBindings();
    }

    public static void removeActions() {
        jEdit.removeActionSet(actions);
    }

    private boolean canChangeEditMode(EBMessage eBMessage) {
        EditPaneUpdate editPaneUpdate;
        Object object;
        BufferUpdate bufferUpdate;
        Object object2;
        return eBMessage instanceof BufferUpdate ? (object2 = (bufferUpdate = (BufferUpdate)eBMessage).getWhat()) == BufferUpdate.CLOSED || object2 == BufferUpdate.CREATED || object2 == BufferUpdate.PROPERTIES_CHANGED : eBMessage instanceof EditPaneUpdate && ((object = (editPaneUpdate = (EditPaneUpdate)eBMessage).getWhat()) == EditPaneUpdate.BUFFER_CHANGED || object == EditPaneUpdate.CREATED);
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        boolean bl;
        Object object;
        boolean bl2 = jEdit.getBooleanProperty("options.docking.autoLoadModeLayout", false);
        if (!bl2) {
            return;
        }
        if (eBMessage instanceof ViewUpdate && ((ViewUpdate)(object = (ViewUpdate)eBMessage)).getWhat() == ViewUpdate.CLOSED) {
            View view = jEdit.getActiveView();
            String string = this.currentMode.get(view);
            this.saveModeLayout(view, string);
            return;
        }
        object = jEdit.getActiveView();
        if (object == null) {
            return;
        }
        if (!this.canChangeEditMode(eBMessage)) {
            return;
        }
        String string = this.getCurrentEditMode((View)object);
        String string2 = this.currentMode.get(object);
        boolean bl3 = bl = string2 == null && string == null || string2 != null && string2.equals(string);
        if (!bl) {
            boolean bl4 = jEdit.getBooleanProperty("options.docking.autoSaveModeLayout", false);
            if (bl4) {
                this.saveModeLayout((View)object, string2);
            }
            this.currentMode.put((View)object, string);
            this.loadModeLayout((View)object, string);
        }
    }

    private String getCurrentEditMode(View view) {
        Buffer buffer = view.getBuffer();
        if (buffer == null) {
            return null;
        }
        Mode mode = buffer.getMode();
        if (mode == null) {
            return null;
        }
        return mode.getName();
    }

    private void saveModeLayout(View view, String string) {
        String string2 = this.getModePerspective(string);
        if (string2 == null) {
            return;
        }
        DockingLayoutManager.save(view, string2);
    }

    private void loadModeLayout(View view, String string) {
        String string2 = this.getModePerspective(string);
        if (string2 == null) {
            return;
        }
        DockingLayoutManager.load(view, string2);
    }

    public static void loadCurrentModeLayout(View view) {
        if (view == null) {
            return;
        }
        String string = instance.getCurrentEditMode(view);
        instance.loadModeLayout(view, string);
    }

    public static void saveCurrentModeLayout(View view) {
        if (view == null) {
            return;
        }
        String string = instance.getCurrentEditMode(view);
        instance.saveModeLayout(view, string);
    }

    private String getModePerspective(String string) {
        if (string == null) {
            string = GLOBAL_MODE;
        }
        return "mode-" + string;
    }

    private static class LoadPerspectiveAction
    extends EditAction {
        private static final String LOAD_PREFIX = "load-";

        public LoadPerspectiveAction(String string) {
            super(LOAD_PREFIX + string, new String[]{string});
            jEdit.setTemporaryProperty(LOAD_PREFIX + string + ".label", LOAD_PREFIX + string);
        }

        @Override
        public void invoke(View view) {
            DockingLayoutManager.load(view, (String)this.args[0]);
        }
    }
}

