/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class FilteredTableModel<E extends TableModel>
extends AbstractTableModel
implements TableModelListener {
    protected E delegated;
    private Vector<Integer> filteredIndices;
    private Map<Integer, Integer> invertedIndices;
    private String filter;
    private JTable table;

    protected FilteredTableModel(E e) {
        this.delegated = e;
        e.addTableModelListener(this);
        this.resetFilter();
    }

    public void setTable(JTable jTable) {
        if (jTable.getModel() != this) {
            throw new IllegalArgumentException("The given table " + jTable + " doesn't use this model " + this);
        }
        this.table = jTable;
    }

    public E getDelegated() {
        return this.delegated;
    }

    public void setDelegated(E e) {
        this.delegated.removeTableModelListener(this);
        e.addTableModelListener(this);
        this.delegated = e;
    }

    private void resetFilter() {
        this.filteredIndices = null;
    }

    public void setFilter(String string) {
        Set<Integer> set = this.saveSelection();
        this.filter = string;
        if (string != null && string.length() > 0) {
            int n = this.delegated.getRowCount();
            string = this.prepareFilter(string);
            Vector<Integer> vector = new Vector<Integer>(n);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < n; ++i) {
                if (!this.passFilter(i, string)) continue;
                Integer n2 = i;
                vector.add(n2);
                hashMap.put(n2, vector.size() - 1);
            }
            this.invertedIndices = hashMap;
            this.filteredIndices = vector;
        } else {
            this.resetFilter();
        }
        this.fireTableDataChanged();
        this.restoreSelection(set);
    }

    public String prepareFilter(String string) {
        return string;
    }

    public abstract boolean passFilter(int var1, String var2);

    private Set<Integer> saveSelection() {
        if (this.table == null) {
            return null;
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
        for (int n : nArray) {
            hashSet.add(this.getTrueRow(n));
        }
        return hashSet;
    }

    private void restoreSelection(Set<Integer> set) {
        if (set == null || this.getRowCount() == 0) {
            return;
        }
        for (Integer n : set) {
            int n2 = this.getInternal2ExternalRow(n);
            if (n2 == -1) continue;
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    @Override
    public int getRowCount() {
        if (this.filteredIndices == null) {
            return this.delegated.getRowCount();
        }
        return this.filteredIndices.size();
    }

    @Override
    public int getColumnCount() {
        return this.delegated.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.delegated.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.delegated.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        int n3 = this.getTrueRow(n);
        return this.delegated.isCellEditable(n3, n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getTrueRow(n);
        return this.delegated.getValueAt(n3, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.getTrueRow(n);
        this.delegated.setValueAt(object, n3, n2);
    }

    public int getTrueRow(int n) {
        if (this.filteredIndices == null) {
            return n;
        }
        return this.filteredIndices.get(n);
    }

    public int getInternal2ExternalRow(int n) {
        if (this.invertedIndices == null) {
            return n;
        }
        Integer n2 = this.invertedIndices.get(n);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setFilter(this.filter);
    }
}

