/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.ThreadUtilities;
import org.gjt.sp.util.WorkThread;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class IOProgressMonitor
extends JPanel {
    private final JLabel caption = new JLabel();
    private final ThreadProgress[] threads;
    private final WorkThreadHandler workThreadHandler;

    public IOProgressMonitor() {
        super(new BorderLayout());
        this.updateCaption();
        this.add("North", this.caption);
        this.threads = new ThreadProgress[VFSManager.getIOThreadPool().getThreadCount()];
        Box box = new Box(1);
        for (int i = 0; i < this.threads.length; ++i) {
            if (i != 0) {
                box.add(Box.createVerticalStrut(6));
            }
            this.threads[i] = new ThreadProgress(i);
            box.add(this.threads[i]);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.add("North", box);
        this.add("Center", new JScrollPane(jPanel));
        this.workThreadHandler = new WorkThreadHandler();
    }

    @Override
    public void addNotify() {
        VFSManager.getIOThreadPool().addProgressListener(this.workThreadHandler);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        VFSManager.getIOThreadPool().removeProgressListener(this.workThreadHandler);
        super.removeNotify();
    }

    private void updateCaption() {
        Object[] objectArray = new String[]{String.valueOf(VFSManager.getIOThreadPool().getRequestCount())};
        this.caption.setText(jEdit.getProperty("io-progress-monitor.caption", objectArray));
    }

    class ThreadProgress
    extends JPanel {
        private final int index;
        private final JProgressBar progress;
        private final JButton abort;

        ThreadProgress(int n) {
            super(new BorderLayout(12, 12));
            this.index = n;
            Box box = new Box(1);
            box.add(Box.createGlue());
            this.progress = new JProgressBar();
            box.add(this.progress);
            this.progress.setStringPainted(true);
            box.add(Box.createGlue());
            this.add("Center", box);
            this.abort = new JButton(jEdit.getProperty("io-progress-monitor.abort"));
            this.abort.addActionListener(new ActionHandler());
            this.add("East", this.abort);
            this.update();
        }

        public void update() {
            WorkThread workThread = VFSManager.getIOThreadPool().getThread(this.index);
            if (workThread.isRequestRunning()) {
                if (this.progress.isIndeterminate()) {
                    if (workThread.getProgressMaximum() != 0) {
                        this.progress.setIndeterminate(false);
                    }
                } else if (workThread.getProgressMaximum() == 0) {
                    this.progress.setIndeterminate(true);
                }
                this.abort.setEnabled(true);
                String string = workThread.getStatus();
                if (string == null) {
                    string = "";
                }
                this.progress.setString(string);
                this.progress.setMaximum(workThread.getProgressMaximum());
                this.progress.setValue(workThread.getProgressValue());
            } else {
                this.abort.setEnabled(false);
                this.progress.setString(jEdit.getProperty("io-progress-monitor.idle"));
                this.progress.setIndeterminate(false);
                this.progress.setValue(0);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (actionEvent.getSource() == ThreadProgress.this.abort && (n = GUIUtilities.confirm(IOProgressMonitor.this, "abort", null, 0, 3)) == 0) {
                    VFSManager.getIOThreadPool().getThread(ThreadProgress.this.index).abortCurrentRequest();
                }
            }
        }
    }

    class WorkThreadHandler
    implements WorkThreadProgressListener {
        WorkThreadHandler() {
        }

        @Override
        public void statusUpdate(WorkThreadPool workThreadPool, final int n) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    IOProgressMonitor.this.updateCaption();
                    IOProgressMonitor.this.threads[n].update();
                }
            });
        }

        @Override
        public void progressUpdate(WorkThreadPool workThreadPool, final int n) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    IOProgressMonitor.this.updateCaption();
                    IOProgressMonitor.this.threads[n].update();
                }
            });
        }
    }
}

