/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class KeyEventTranslator {
    protected static KeyEvent lastKeyPressEvent;
    protected static boolean lastKeyPressAccepted;
    private static final int[] MODS;
    static int c;
    static int a;
    static int m;
    static int s;
    private static final Map<Key, Key> transMap;

    public static void addTranslation(Key key, Key key2) {
        transMap.put(key, key2);
    }

    public static Key translateKeyEvent(KeyEvent keyEvent) {
        Key key;
        int n = keyEvent.getModifiers();
        switch (keyEvent.getID()) {
            case 401: {
                int n2 = keyEvent.getKeyCode();
                if (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        return null;
                    }
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, Character.toLowerCase((char)n2));
                    break;
                }
                if (n2 == 9) {
                    keyEvent.consume();
                    key = new Key(KeyEventTranslator.modifiersToString(n), n2, '\u0000');
                    break;
                }
                if (n2 == 32) {
                    if ((n & 0xFFFFFFFE) == 0) {
                        key = null;
                        break;
                    }
                    if (Debug.ALTERNATIVE_DISPATCHER && (n & 0xFFFFFFFB) == 0) {
                        key = null;
                        break;
                    }
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, ' ');
                    break;
                }
                key = new Key(KeyEventTranslator.modifiersToString(n), n2, '\u0000');
                break;
            }
            case 400: {
                char c = keyEvent.getKeyChar();
                if (KeyEventWorkaround.isMacControl(keyEvent)) {
                    c = (char)(c | 0x60);
                }
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': {
                        return null;
                    }
                    case ' ': {
                        if (Debug.ALTERNATIVE_DISPATCHER && (n & 0xFFFFFFFB) == 0) {
                            key = new Key(KeyEventTranslator.modifiersToString(n), 0, ' ');
                            break;
                        }
                        if ((n & 0xFFFFFFFE) == 0) break;
                        return null;
                    }
                }
                int n3 = Debug.ALT_KEY_PRESSED_DISABLED ? 41 : 33;
                if ((n & 0x20) == 0 && (n & ~n3) != 0) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        key = new Key(KeyEventTranslator.modifiersToString(n), 0, c);
                        break;
                    }
                    return null;
                }
                if (c == ' ') {
                    key = new Key(KeyEventTranslator.modifiersToString(n), 0, c);
                    break;
                }
                key = new Key(null, 0, c);
                break;
            }
            default: {
                return null;
            }
        }
        Key key2 = transMap.get(key);
        if (key2 == null) {
            return key;
        }
        return key2;
    }

    public static Key parseKey(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.indexOf(43);
        if (n3 <= 0) {
            string2 = string;
        } else {
            block8: for (n = 0; n < n3; ++n) {
                switch (Character.toUpperCase(string.charAt(n))) {
                    case 'A': {
                        n2 |= a;
                        continue block8;
                    }
                    case 'C': {
                        n2 |= c;
                        continue block8;
                    }
                    case 'M': {
                        n2 |= m;
                        continue block8;
                    }
                    case 'S': {
                        n2 |= s;
                    }
                }
            }
            string2 = string.substring(n3 + 1);
        }
        if (string2.length() == 1) {
            return new Key(KeyEventTranslator.modifiersToString(n2), 0, string2.charAt(0));
        }
        if (string2.length() == 0) {
            Log.log(9, KeyEventTranslator.class, "Invalid key stroke: " + string);
            return null;
        }
        if (string2.equals("SPACE")) {
            return new Key(KeyEventTranslator.modifiersToString(n2), 0, ' ');
        }
        try {
            n = KeyEvent.class.getField("VK_".concat(string2)).getInt(null);
        }
        catch (Exception exception) {
            Log.log(9, KeyEventTranslator.class, "Invalid key stroke: " + string);
            return null;
        }
        return new Key(KeyEventTranslator.modifiersToString(n2), n, '\u0000');
    }

    public static void setModifierMapping(int n, int n2, int n3, int n4) {
        int n5 = n & n2 | n & n3 | n & n4 | n2 & n3 | n2 & n4 | n3 & n4;
        if ((n5 & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((n5 & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((n5 & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((n5 & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        c = n;
        a = n2;
        m = n3;
        s = n4;
    }

    public static char getSymbolicModifierName(int n) {
        if ((n & c) != 0) {
            return 'C';
        }
        if ((n & a) != 0) {
            return 'A';
        }
        if ((n & m) != 0) {
            return 'M';
        }
        if ((n & s) != 0) {
            return 'S';
        }
        return '\u0000';
    }

    public static String modifiersToString(int n) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < MODS.length; ++i) {
            if ((n & MODS[i]) == 0) continue;
            stringBuilder = KeyEventTranslator.lazyAppend(stringBuilder, KeyEventTranslator.getSymbolicModifierName(MODS[i]));
        }
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static String getModifierString(InputEvent inputEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (inputEvent.isControlDown()) {
            stringBuilder.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (inputEvent.isAltDown()) {
            stringBuilder.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (inputEvent.isMetaDown()) {
            stringBuilder.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (inputEvent.isShiftDown()) {
            stringBuilder.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private static StringBuilder lazyAppend(StringBuilder stringBuilder, char c) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.indexOf(String.valueOf(c)) == -1) {
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    static {
        MODS = new int[]{2, 8, 4, 1};
        transMap = new HashMap<Key, Key>();
        if (OperatingSystem.isMacOS()) {
            KeyEventTranslator.setModifierMapping(4, 2, 8, 1);
        } else {
            KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
        }
    }

    public static class Key {
        public final String modifiers;
        public final int key;
        public final char input;
        private final int hashCode;
        protected boolean isFromGlobalContext;

        public Key(String string, int n, char c) {
            this.modifiers = string;
            this.key = n;
            this.input = c;
            this.hashCode = n + c;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                if (StandardUtilities.objectsEqual(this.modifiers, key.modifiers) && this.key == key.key && this.input == key.input) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return (this.modifiers == null ? "" : this.modifiers) + '<' + Integer.toString(this.key, 16) + ',' + Integer.toString(this.input, 16) + '>';
        }

        public void setIsFromGlobalContext(boolean bl) {
            this.isFromGlobalContext = bl;
        }

        public boolean isFromGlobalContext() {
            return this.isFromGlobalContext;
        }
    }
}

