/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.input;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;
import org.gjt.sp.util.Log;

public abstract class AbstractInputHandler<E extends JEditAbstractEditAction> {
    protected int lastActionCount;
    protected KeyListener keyEventInterceptor;
    protected String readNextChar;
    protected int repeatCount = 1;
    protected E lastAction;
    protected static final int REPEAT_COUNT_THRESHOLD = 20;
    public static Object PREFIX_STR = "PREFIX_STR";
    protected boolean shortcutOn = false;
    protected Hashtable bindings;
    protected Hashtable currentBindings;

    public void addKeyBinding(String string, String string2) {
        this.addKeyBinding(string, (Object)string2);
    }

    public void addKeyBinding(String string, E e) {
        this.addKeyBinding(string, (Object)e);
    }

    public void addKeyBinding(String string, Object object) {
        Hashtable hashtable = this.bindings;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 == null ? string3 : string2 + " " + string3;
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(string3);
            if (key == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object object2 = hashtable.get(key);
                if (object2 instanceof Hashtable) {
                    hashtable = (Hashtable)object2;
                    continue;
                }
                Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
                hashtable2.put(PREFIX_STR, string2);
                object2 = hashtable2;
                hashtable.put(key, object2);
                hashtable = (Hashtable)object2;
                continue;
            }
            hashtable.put(key, object);
        }
    }

    public void removeKeyBinding(String string) {
        Hashtable hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(string2);
            if (key == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object v = hashtable.get(key);
                if (v instanceof Hashtable) {
                    hashtable = (Hashtable)v;
                    continue;
                }
                if (v != null) {
                    hashtable.remove(key);
                    return;
                }
                return;
            }
            hashtable.remove(key);
        }
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    public Object getKeyBinding(String string) {
        Hashtable hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(stringTokenizer.nextToken());
            if (key == null) {
                return null;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object v = hashtable.get(key);
                if (v instanceof Hashtable) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return v;
                    }
                    hashtable = (Hashtable)v;
                    continue;
                }
                return v;
            }
            return hashtable.get(key);
        }
        return null;
    }

    public int getLastActionCount() {
        return this.lastActionCount;
    }

    public void resetLastActionCount() {
        this.lastActionCount = 0;
    }

    public KeyListener getKeyEventInterceptor() {
        return this.keyEventInterceptor;
    }

    public void setKeyEventInterceptor(KeyListener keyListener) {
        this.keyEventInterceptor = keyListener;
    }

    public boolean isPrefixActive() {
        return this.readNextChar != null;
    }

    public void setBindings(Hashtable hashtable) {
        this.bindings = this.currentBindings = hashtable;
    }

    public void setCurrentBindings(Hashtable hashtable) {
        this.currentBindings = hashtable;
    }

    public abstract boolean handleKey(KeyEventTranslator.Key var1, boolean var2);

    public abstract void processKeyEvent(KeyEvent var1, int var2, boolean var3);

    protected void sendShortcutPrefixOff() {
        if (this.shortcutOn) {
            ShortcutPrefixActiveEvent.firePrefixStateChange(null, false);
            this.shortcutOn = false;
        }
    }

    public abstract void invokeAction(String var1);

    public abstract void invokeAction(E var1);

    public static String toString(KeyEvent keyEvent) {
        String string;
        switch (keyEvent.getID()) {
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 400: {
                string = "KEY_TYPED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(string);
        stringBuilder.append(",keyCode=0x").append(Integer.toString(keyEvent.getKeyCode(), 16));
        stringBuilder.append(",keyChar=0x").append(Integer.toString(keyEvent.getKeyChar(), 16));
        stringBuilder.append(",modifiers=0x").append(Integer.toString(keyEvent.getModifiers(), 16));
        stringBuilder.append(",consumed=");
        stringBuilder.append(keyEvent.isConsumed() ? (char)'1' : '0');
        return stringBuilder.toString();
    }

    protected void processKeyEventKeyStrokeHandling(KeyEvent keyEvent, int n, String string, boolean bl) {
        KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent(keyEvent);
        if (key != null) {
            key.setIsFromGlobalContext(bl);
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, this, "Translated (key " + string + "): " + key + " from " + n);
            }
            boolean bl2 = false;
            if (this.handleKey(key, false)) {
                keyEvent.consume();
                bl2 = true;
            }
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, this, "Translated (key " + string + "): " + key + " from " + n + ": consumed=" + bl2 + '.');
            }
        }
    }
}

