/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class FileVFS
extends VFS {
    public static final String PERMISSIONS_PROPERTY = "FileVFS__perms";
    private static final FileSystemView fsView = FileSystemView.getFileSystemView();

    public FileVFS() {
        super("file", 0x7F | (OperatingSystem.isCaseInsensitiveFS() ? 128 : 0), new String[]{"type", "size", "status", "modified"});
    }

    @Override
    public String getParentOfPath(String string) {
        if (OperatingSystem.isDOSDerived()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return "roots:";
            }
            if (string.length() == 3 && string.endsWith(":\\")) {
                return "roots:";
            }
            if (string.startsWith("\\\\") && string.indexOf(92, 2) == -1) {
                return string;
            }
        }
        return super.getParentOfPath(string);
    }

    @Override
    public String constructPath(String string, String string2) {
        if (string.endsWith(File.separator) || string.endsWith("/")) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Override
    public String getTwoStageSaveName(String string) {
        File file = new File(this.getParentOfPath(string));
        return file.canWrite() || OperatingSystem.isWindows() ? super.getTwoStageSaveName(string) : null;
    }

    @Override
    public boolean save(View view, Buffer buffer, String string) {
        if (OperatingSystem.isUnix()) {
            int n = FileVFS.getPermissions(buffer.getPath());
            Log.log(1, this, buffer.getPath() + " has permissions 0" + Integer.toString(n, 8));
            buffer.setIntegerProperty(PERMISSIONS_PROPERTY, n);
        }
        return super.save(view, buffer, string);
    }

    @Override
    public boolean insert(View view, Buffer buffer, String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            VFSManager.error(view, file.getPath(), "ioerror.open-directory", null);
            return false;
        }
        if (!file.canRead()) {
            VFSManager.error(view, file.getPath(), "ioerror.no-read", null);
            return false;
        }
        return super.insert(view, buffer, string);
    }

    public static boolean recursiveDelete(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    FileVFS.recursiveDelete(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    @Override
    public String _canonPath(Object object, String string, Component component) throws IOException {
        return MiscUtilities.canonPath(string);
    }

    @Override
    public VFSFile[] _listFiles(Object object, String string, Component component) {
        if (OperatingSystem.isWindows() && string.length() == 2 && string.charAt(1) == ':') {
            string = string.concat(File.separator);
        }
        File file = new File(string);
        File[] fileArray = null;
        if (file.exists()) {
            fileArray = fsView.getFiles(file, false);
        }
        if (fileArray == null) {
            VFSManager.error(component, string, "ioerror.directory-error-nomsg", null);
            return null;
        }
        VFSFile[] vFSFileArray = new VFSFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            vFSFileArray[i] = new LocalFile(fileArray[i]);
        }
        return vFSFileArray;
    }

    @Override
    public VFSFile _getFile(Object object, String string, Component component) {
        if (string.equals("/") && OperatingSystem.isUnix()) {
            return new VFSFile(string, string, string, 1, 0L, false);
        }
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return new LocalFile(file);
    }

    @Override
    public boolean _delete(Object object, String string, Component component) {
        String string2;
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        boolean bl = !file.isDirectory() ? file.delete() : FileVFS.recursiveDelete(file);
        if (bl) {
            VFSManager.sendVFSUpdate(this, string2, true);
        }
        return bl;
    }

    @Override
    public boolean _rename(Object object, String string, String string2, Component component) {
        String string3;
        String string4;
        File file = new File(string2);
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string4 = string2;
        }
        File file2 = new File(file.getParent());
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                return false;
            }
        } else {
            file2.mkdirs();
            if (!file2.exists()) {
                return false;
            }
        }
        File file3 = new File(string);
        try {
            string3 = file3.getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = string;
        }
        if (!string3.equalsIgnoreCase(string4)) {
            file.delete();
        }
        boolean bl = file3.renameTo(file);
        VFSManager.sendVFSUpdate(this, string3, true);
        VFSManager.sendVFSUpdate(this, string4, true);
        return bl;
    }

    @Override
    public boolean _mkdir(Object object, String string, Component component) {
        String string2;
        String string3 = this.getParentOfPath(string);
        if (!new File(string3).exists() && !this._mkdir(object, string3, component)) {
            return false;
        }
        File file = new File(string);
        boolean bl = file.mkdir();
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        VFSManager.sendVFSUpdate(this, string2, true);
        return bl;
    }

    @Override
    public void _backup(Object object, String string, Component component) throws IOException {
        String string2 = jEdit.getProperty("backup.prefix");
        String string3 = jEdit.getProperty("backup.suffix");
        String string4 = jEdit.getProperty("backup.directory");
        int n = jEdit.getIntegerProperty("backup.minTime", 0);
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (string4 == null || string4.length() == 0) {
            string4 = file.getParent();
        } else {
            string4 = MiscUtilities.constructPath(System.getProperty("user.home"), string4);
            File file2 = new File(string4 = MiscUtilities.concatPath(string4, file.getParent()));
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        MiscUtilities.saveBackup(file, jEdit.getIntegerProperty("backups", 1), string2, string3, string4, n);
    }

    @Override
    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        try {
            return new FileInputStream(string);
        }
        catch (IOException iOException) {
            if (bl) {
                return null;
            }
            throw iOException;
        }
    }

    @Override
    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        return new FileOutputStream(string);
    }

    @Override
    public void _saveComplete(Object object, Buffer buffer, String string, Component component) {
        int n = buffer.getIntegerProperty(PERMISSIONS_PROPERTY, 0);
        FileVFS.setPermissions(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getPermissions(String string) {
        int n = 0;
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return n;
        }
        if (OperatingSystem.isUnix()) {
            BufferedReader bufferedReader;
            block6: {
                String[] stringArray = new String[]{"ls", "-lLd", string};
                InputStreamReader inputStreamReader = null;
                bufferedReader = null;
                try {
                    Process process = Runtime.getRuntime().exec(stringArray);
                    inputStreamReader = new InputStreamReader(process.getInputStream());
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) break block6;
                    String string3 = string2.substring(1, 10);
                    n = MiscUtilities.parsePermissions(string3);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(bufferedReader);
                    catch (Throwable throwable2) {
                        IOUtilities.closeQuietly(bufferedReader);
                        throw throwable2;
                    }
                }
            }
            IOUtilities.closeQuietly(bufferedReader);
        }
        return n;
    }

    public static void setPermissions(String string, int n) {
        if (jEdit.getBooleanProperty("chmodDisabled")) {
            return;
        }
        if (n != 0 && OperatingSystem.isUnix()) {
            String[] stringArray = new String[]{"chmod", Integer.toString(n, 8), string};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class LocalFile
    extends VFSFile {
        private File file;
        public static DateFormat DATE_FORMAT = DateFormat.getInstance();
        private long modified;
        private transient FileSystemView fsView;
        private transient Icon icon;

        public LocalFile(File file) {
            this.file = file;
            this.setName(file.getName());
            String string = file.getPath();
            this.setPath(string);
            this.setDeletePath(string);
            this.setHidden(file.isHidden());
            this.setType(file.isDirectory() ? 1 : 0);
        }

        @Override
        public String getExtendedAttribute(String string) {
            this.fetchAttrs();
            if (string.equals("modified")) {
                return DATE_FORMAT.format(new Date(this.modified));
            }
            return super.getExtendedAttribute(string);
        }

        @Override
        protected void fetchAttrs() {
            if (this.fetchedAttrs()) {
                return;
            }
            super.fetchAttrs();
            this.setSymlinkPath(MiscUtilities.resolveSymlinks(this.file.getPath()));
            this.setReadable(this.file.canRead());
            this.setWriteable(this.file.canWrite());
            this.setLength(this.file.length());
            this.setModified(this.file.lastModified());
        }

        @Override
        public Icon getIcon(boolean bl, boolean bl2) {
            if (this.icon == null) {
                if (this.fsView == null) {
                    this.fsView = FileSystemView.getFileSystemView();
                }
                this.icon = this.fsView.getSystemIcon(this.file);
            }
            return this.icon;
        }

        @Override
        public String getSymlinkPath() {
            this.fetchAttrs();
            return super.getSymlinkPath();
        }

        @Override
        public long getLength() {
            this.fetchAttrs();
            return super.getLength();
        }

        @Override
        public boolean isReadable() {
            this.fetchAttrs();
            return super.isReadable();
        }

        @Override
        public boolean isWriteable() {
            this.fetchAttrs();
            return super.isWriteable();
        }

        public long getModified() {
            this.fetchAttrs();
            return this.modified;
        }

        public void setModified(long l) {
            this.modified = l;
        }
    }
}

