/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.jEdit;

public class EnhancedMenuItem
extends JMenuItem {
    static Font acceleratorFont;
    static Color acceleratorForeground;
    static Color acceleratorSelectionForeground;
    private String shortcut;
    private String action;

    public EnhancedMenuItem(String string, String string2, ActionContext actionContext) {
        this.action = string2;
        this.shortcut = GUIUtilities.getShortcutLabel(string2);
        String string3 = jEdit.getProperty(string2 + ".tooltip");
        if (string3 != null) {
            this.setToolTipText(string3);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            this.setText(string + " ( " + this.shortcut + " )");
            this.shortcut = null;
        } else {
            this.setText(string);
        }
        if (string2 != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(actionContext, string2));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.shortcut != null) {
            dimension.width += this.getFontMetrics(acceleratorFont).stringWidth(this.shortcut) + 15;
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.shortcut != null) {
            graphics.setFont(acceleratorFont);
            graphics.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets();
            graphics.drawString(this.shortcut, this.getWidth() - (fontMetrics.stringWidth(this.shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (OperatingSystem.isMacOSLF() ? 0 : 1)));
        }
    }

    static {
        String string = OperatingSystem.isMacOSLF() ? "Lucida Grande" : "Monospaced";
        acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (acceleratorFont == null) {
            acceleratorFont = new Font(string, 0, 12);
        }
        if ((acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground")) == null) {
            acceleratorForeground = Color.black;
        }
        if ((acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground")) == null) {
            acceleratorSelectionForeground = Color.black;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;
        private String msg;

        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.cleanupStatusBar(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.msg = jEdit.getProperty(EnhancedMenuItem.this.action + ".mouse-over");
            if (this.msg != null) {
                GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus().setMessage(this.msg);
                this.msgSet = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.cleanupStatusBar(mouseEvent);
        }

        private void cleanupStatusBar(MouseEvent mouseEvent) {
            if (this.msgSet) {
                StatusBar statusBar = GUIUtilities.getView((Component)mouseEvent.getSource()).getStatus();
                if (this.msg == statusBar.getMessage()) {
                    statusBar.setMessage(null);
                }
                this.msgSet = false;
                this.msg = null;
            }
        }
    }
}

