/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class ReloadWithEncodingProvider
implements ActionListener,
DynamicMenuProvider {
    private View view;

    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu jMenu) {
        this.view = GUIUtilities.getView(jMenu);
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        jMenuItem.setActionCommand("auto-detect");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        Object[] objectArray = MiscUtilities.getEncodings(true);
        String string = System.getProperty("file.encoding");
        if (Arrays.binarySearch(objectArray, string) < 0) {
            String[] stringArray = new String[objectArray.length + 1];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            stringArray[objectArray.length] = string;
            objectArray = stringArray;
        }
        Arrays.sort(objectArray);
        int n = jEdit.getIntegerProperty("menu.spillover", 20);
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem2 = new JMenuItem((String)objectArray[i]);
            jMenuItem2.setActionCommand("encoding@" + (String)objectArray[i]);
            jMenuItem2.addActionListener(this);
            if (jMenu.getMenuComponentCount() >= n && i < objectArray.length) {
                JMenu jMenu2 = new JMenu(jEdit.getProperty("common.more"));
                jMenu.add(jMenu2);
                jMenu = jMenu2;
            }
            jMenu.add(jMenuItem2);
        }
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("vfs.browser.other-encoding.label"));
        jMenuItem3.setActionCommand("other-encoding");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        String string2 = null;
        Hashtable<String, Object> hashtable = null;
        if (string.startsWith("encoding@")) {
            string2 = string.substring(9);
        } else if (string.equals("other-encoding")) {
            string2 = JOptionPane.showInputDialog(this.view, jEdit.getProperty("encoding-prompt.message"), jEdit.getProperty("encoding-prompt.title"), 3);
            if (string2 == null) {
                return;
            }
            if (!EncodingServer.hasEncoding(string2)) {
                String string3 = jEdit.getProperty("reload-encoding.error", new Object[]{string2});
                JOptionPane.showMessageDialog(this.view, string3, jEdit.getProperty("common.error"), 0);
                return;
            }
        }
        if (string2 != null) {
            hashtable = new Hashtable<String, Object>();
            hashtable.put("encoding", string2);
            hashtable.put("encodingAutodetect", false);
            this.view.getBuffer().setStringProperty("encoding", string2);
        }
        String string4 = this.view.getBuffer().getPath();
        jEdit.closeBuffer(this.view, this.view.getBuffer());
        jEdit.openFile(this.view, null, string4, false, hashtable);
    }
}

