/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.html.HTMLEditorKit;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.KeyboardCommand;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class InstallPanel
extends JPanel
implements EBComponent {
    private final JTable table;
    private final JScrollPane scrollpane;
    private final PluginTableModel pluginModel;
    private final PluginManager window;
    private final PluginInfoBox infoBox;
    private final ChoosePluginSet chooseButton;
    private final boolean updates;
    private final Collection<String> pluginSet = new HashSet<String>();
    static final Icon ASC_ICON = GUIUtilities.loadIcon("arrow-asc.png");
    static final Icon DESC_ICON = GUIUtilities.loadIcon("arrow-desc.png");

    InstallPanel(PluginManager pluginManager, boolean bl) {
        super(new BorderLayout(12, 12));
        this.window = pluginManager;
        this.updates = bl;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane jSplitPane = new JSplitPane(0, jEdit.getBooleanProperty("appearance.continuousLayout"));
        jSplitPane.setResizeWeight(0.75);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        this.table.addFocusListener(new TableFocusHandler());
        InputMap inputMap = this.table.getInputMap(0);
        ActionMap actionMap = this.table.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "tabOutForward");
        actionMap.put("tabOutForward", new KeyboardAction(KeyboardCommand.TAB_OUT_FORWARD));
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "tabOutBack");
        actionMap.put("tabOutBack", new KeyboardAction(KeyboardCommand.TAB_OUT_BACK));
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "editPlugin");
        actionMap.put("editPlugin", new KeyboardAction(KeyboardCommand.EDIT_PLUGIN));
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "closePluginManager");
        actionMap.put("closePluginManager", new KeyboardAction(KeyboardCommand.CLOSE_PLUGIN_MANAGER));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        TableColumn tableColumn5 = this.table.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        tableColumn2.setPreferredWidth(180);
        tableColumn3.setPreferredWidth(130);
        tableColumn4.setPreferredWidth(70);
        tableColumn5.setPreferredWidth(70);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new HeaderMouseHandler());
        jTableHeader.setDefaultRenderer(new HeaderRenderer((DefaultTableCellRenderer)jTableHeader.getDefaultRenderer()));
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        jSplitPane.setTopComponent(this.scrollpane);
        this.infoBox = new PluginInfoBox();
        JScrollPane jScrollPane = new JScrollPane(this.infoBox);
        jScrollPane.setPreferredSize(new Dimension(500, 100));
        jSplitPane.setBottomComponent(jScrollPane);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jSplitPane.setDividerLocation(0.75);
            }
        });
        final JTextField jTextField = new JTextField();
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) {
                    InstallPanel.this.table.dispatchEvent(keyEvent);
                    InstallPanel.this.table.requestFocus();
                }
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            void update() {
                InstallPanel.this.pluginModel.setFilterString(jTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = InstallPanel.this.table.getSelectedRow();
                int n2 = InstallPanel.this.table.getModel().getRowCount();
                if (keyEvent.getKeyCode() == 40 && n == n2 - 1 || keyEvent.getKeyCode() == 38 && n == 0) {
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Filter : "));
        box.add(jTextField);
        this.add("North", box);
        this.add("Center", jSplitPane);
        Box box2 = new Box(0);
        box2.add(new InstallButton());
        box2.add(Box.createHorizontalStrut(12));
        box2.add(new SelectallButton());
        this.chooseButton = new ChoosePluginSet();
        box2.add(this.chooseButton);
        box2.add(new ClearPluginSet());
        box2.add(Box.createGlue());
        box2.add(new SizeLabel());
        this.add("South", box2);
        String string = jEdit.getProperty("plugin-manager.pluginset.path", "");
        if (!string.isEmpty()) {
            this.loadPluginSet(string);
        }
    }

    boolean loadPluginSet(String string) {
        this.pluginSet.clear();
        this.pluginModel.restoreSelection(new HashSet<String>(), new HashSet<String>());
        VFS vFS = VFSManager.getVFSForPath(string);
        Object object = vFS.createVFSSession(string, this);
        try {
            InputStream inputStream = vFS._createInputStream(object, string, false, this);
            XMLUtilities.parseXML(inputStream, new StringMapHandler());
        }
        catch (Exception exception) {
            Log.log(7, this, "Loading Pluginset failed:" + exception.getMessage());
            return false;
        }
        this.pluginModel.update();
        return true;
    }

    public void updateModel() {
        final HashSet<String> hashSet = new HashSet<String>();
        final HashSet<String> hashSet2 = new HashSet<String>();
        this.pluginModel.saveSelection(hashSet, hashSet2);
        this.pluginModel.clear();
        this.infoBox.setText(jEdit.getProperty("plugin-manager.list-download"));
        ThreadUtilities.runInDispatchThread(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.infoBox.setText(null);
                InstallPanel.this.pluginModel.update();
                InstallPanel.this.pluginModel.restoreSelection(hashSet, hashSet2);
            }
        });
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage.getSource() == PluginManager.getInstance()) {
            this.chooseButton.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.chooseButton.path.length() > 0) {
                this.loadPluginSet(this.chooseButton.path);
                this.pluginModel.restoreSelection(new HashSet<String>(), new HashSet<String>());
                this.chooseButton.updateUI();
            }
        }
    }

    private static String formatSize(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(0);
        String string = n < 0x100000 ? (n >> 10) + "KB" : numberFormat.format((double)n / 1048576.0) + "MB";
        return string;
    }

    private static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        HeaderRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)this.tcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            PluginTableModel pluginTableModel = (PluginTableModel)jTable.getModel();
            Icon icon = n2 == pluginTableModel.sortType ? (pluginTableModel.sortDirection == 1 ? ASC_ICON : DESC_ICON) : null;
            jLabel.setIcon(icon);
            return jLabel;
        }
    }

    private class TableFocusHandler
    extends FocusAdapter {
        private TableFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (-1 == InstallPanel.this.table.getSelectedRow() && InstallPanel.this.table.getRowCount() > 0) {
                InstallPanel.this.table.setRowSelectionInterval(0, 0);
                JScrollBar jScrollBar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMinimum());
            }
            if (-1 == InstallPanel.this.table.getSelectedColumn()) {
                InstallPanel.this.table.setColumnSelectionInterval(0, 0);
            }
        }
    }

    private class KeyboardAction
    extends AbstractAction {
        private KeyboardCommand command = KeyboardCommand.NONE;

        KeyboardAction(KeyboardCommand keyboardCommand) {
            this.command = keyboardCommand;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.command) {
                case TAB_OUT_FORWARD: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    break;
                }
                case TAB_OUT_BACK: {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    break;
                }
                case EDIT_PLUGIN: {
                    int n;
                    int[] nArray = InstallPanel.this.table.getSelectedRows();
                    Object[] objectArray = new Object[nArray.length];
                    for (n = 0; n < nArray.length; ++n) {
                        objectArray[n] = InstallPanel.this.pluginModel.getValueAt(nArray[n], 0);
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        InstallPanel.this.pluginModel.setValueAt(objectArray[n].equals(Boolean.FALSE), nArray[n], 0);
                    }
                    break;
                }
                case CLOSE_PLUGIN_MANAGER: {
                    InstallPanel.this.window.ok();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private static class TextRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        TextRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 5) {
                this.tcr.setHorizontalAlignment(11);
            } else {
                this.tcr.setHorizontalAlignment(10);
            }
            return this.tcr.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = InstallPanel.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
            ((InstallPanel)InstallPanel.this).pluginModel.sortDirection *= -1;
            InstallPanel.this.pluginModel.sort(n);
        }
    }

    private static class EntryCompare
    implements Comparator<Entry> {
        private static final int COLUMN_INSTALL = 0;
        private static final int COLUMN_NAME = 1;
        private static final int COLUMN_CATEGORY = 2;
        private static final int COLUMN_VERSION = 3;
        private static final int COLUMN_SIZE = 4;
        private static final int COLUMN_RELEASE = 5;
        private final int type;
        private final int sortDirection;

        EntryCompare(int n, int n2) {
            this.type = n;
            this.sortDirection = n2;
        }

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n;
            switch (this.type) {
                case 0: {
                    n = entry.install == entry2.install ? 0 : (entry.install ? 1 : -1);
                    break;
                }
                case 1: {
                    n = entry.name.compareToIgnoreCase(entry2.name);
                    break;
                }
                case 2: {
                    n = entry.set.compareToIgnoreCase(entry2.set);
                    if (n != 0) break;
                    n = entry.name.compareToIgnoreCase(entry2.name);
                    break;
                }
                case 3: {
                    if (entry.version == entry2.version) {
                        n = 0;
                        break;
                    }
                    if (entry.version == null) {
                        n = -1;
                        break;
                    }
                    if (entry2.version == null) {
                        n = 1;
                        break;
                    }
                    n = StandardUtilities.compareStrings(entry.version, entry2.version, true);
                    break;
                }
                case 4: {
                    n = entry.size < entry2.size ? -1 : (entry.size == entry2.size ? 0 : 1);
                    break;
                }
                case 5: {
                    n = entry.timestamp < entry2.timestamp ? -1 : (entry.timestamp == entry2.timestamp ? 0 : 1);
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n * this.sortDirection;
        }
    }

    private class InstallButton
    extends JButton
    implements ActionListener,
    TableModelListener {
        InstallButton() {
            super(jEdit.getProperty("install-plugins.install"));
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            boolean bl = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            boolean bl2 = jEdit.getBooleanProperty("plugin-manager.installUser");
            Roster roster = new Roster();
            String string = bl2 ? MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars") : MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            int n2 = InstallPanel.this.pluginModel.entries.size();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(n);
                if (!entry.install) continue;
                entry.plugin.install(roster, string, bl);
                if (InstallPanel.this.updates) {
                    entry.plugin.getCompatibleBranch().satisfyDependencies(roster, string, bl);
                }
                ++n3;
            }
            if (roster.isEmpty()) {
                return;
            }
            n = 0;
            if (InstallPanel.this.updates && roster.getOperationCount() > n3 && GUIUtilities.confirm(InstallPanel.this.window, "install-plugins.depend", null, 2, 2) == 2) {
                n = 1;
            }
            if (n == 0) {
                new PluginManagerProgress(InstallPanel.this.window, roster);
                roster.performOperationsInAWTThread(InstallPanel.this.window);
                InstallPanel.this.pluginModel.update();
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            if (tableModelEvent.getType() == 0) {
                int n = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(false);
            }
        }
    }

    private class ClearPluginSet
    extends RolloverButton
    implements ActionListener {
        ClearPluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.clear-plugin-set.icon")));
            this.setToolTipText("clear plugin set");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstallPanel.this.pluginSet.clear();
            InstallPanel.this.pluginModel.restoreSelection(new HashSet<String>(), new HashSet<String>());
            jEdit.unsetProperty("plugin-manager.pluginset.path");
            InstallPanel.this.chooseButton.updateUI();
        }
    }

    private class ChoosePluginSet
    extends RolloverButton
    implements ActionListener {
        private String path;

        ChoosePluginSet() {
            this.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("install-plugins.choose-plugin-set.icon")));
            this.addActionListener(this);
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", "");
            if (this.path.length() < 1) {
                this.setToolTipText("Click here to choose a predefined plugin set");
            } else {
                this.setToolTipText("Choose pluginset (" + this.path + ')');
            }
            super.updateUI();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.path = jEdit.getProperty("plugin-manager.pluginset.path", jEdit.getSettingsDirectory() + File.separator);
            String[] stringArray = GUIUtilities.showVFSFileDialog(InstallPanel.this.window, jEdit.getActiveView(), this.path, 0, false);
            if (stringArray == null || stringArray.length != 1) {
                return;
            }
            this.path = stringArray[0];
            boolean bl = InstallPanel.this.loadPluginSet(this.path);
            if (bl) {
                jEdit.setProperty("plugin-manager.pluginset.path", this.path);
            }
            this.updateUI();
        }
    }

    private class StringMapHandler
    extends DefaultHandler {
        StringMapHandler() {
            InstallPanel.this.pluginSet.clear();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("plugin".equals(string2)) {
                InstallPanel.this.pluginSet.add(attributes.getValue("jar"));
            }
        }
    }

    private class SelectallButton
    extends JCheckBox
    implements ActionListener,
    TableModelListener {
        SelectallButton() {
            super(jEdit.getProperty("install-plugins.select-all"));
            this.addActionListener(this);
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstallPanel.this.pluginModel.setSelectAll(this.isSelected());
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            this.setEnabled(InstallPanel.this.pluginModel.getRowCount() != 0);
            if (tableModelEvent.getType() == 0) {
                int n = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setSelected(false);
                    return;
                }
                if (n > 0) {
                    this.setSelected(true);
                }
            }
        }
    }

    private class SizeLabel
    extends JLabel
    implements TableModelListener {
        private int size;
        private int nbPlugins;

        SizeLabel() {
            this.update();
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                if (InstallPanel.this.pluginModel.isDownloadingList()) {
                    return;
                }
                this.size = 0;
                this.nbPlugins = 0;
                int n = InstallPanel.this.pluginModel.entries.size();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                    if (!entry.install) continue;
                    ++this.nbPlugins;
                    this.size += entry.size;
                }
                this.update();
            }
        }

        private void update() {
            Object[] objectArray = new Object[]{this.nbPlugins, InstallPanel.formatSize(this.size)};
            this.setText(jEdit.getProperty("install-plugins.totalSize", objectArray));
        }
    }

    private class PluginInfoBox
    extends JTextPane
    implements ListSelectionListener {
        private final String[] params;

        PluginInfoBox() {
            this.setBackground(jEdit.getColorProperty("view.bgColor"));
            this.setForeground(jEdit.getColorProperty("view.fgColor"));
            this.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.setEditable(false);
            this.setEditorKit(new HTMLEditorKit());
            this.params = new String[3];
            InstallPanel.this.table.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = "";
            if (InstallPanel.this.table.getSelectedRowCount() == 1) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.filteredEntries.get(InstallPanel.this.table.getSelectedRow());
                this.params[0] = entry.author;
                this.params[1] = entry.date;
                this.params[2] = entry.description;
                string = jEdit.getProperty("install-plugins.info", this.params);
                string = string.replace("\n", "<br>");
                string = "<html>" + string + "</html>";
            }
            this.setText(string);
            this.setCaretPosition(0);
        }
    }

    private static class Entry {
        String name;
        String installedVersion;
        String version;
        String author;
        String date;
        String description;
        String set;
        long timestamp;
        int size;
        boolean install;
        PluginList.Plugin plugin;
        List<Entry> parents = new LinkedList<Entry>();

        Entry(PluginList.Plugin plugin, String string) {
            PluginList.Branch branch = plugin.getCompatibleBranch();
            boolean bl = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            int n = bl ? branch.downloadSourceSize : branch.downloadSize;
            this.name = plugin.name;
            this.author = plugin.author;
            this.installedVersion = plugin.getInstalledVersion();
            this.version = branch.version;
            this.size = n;
            this.date = branch.date;
            this.description = plugin.description;
            this.set = string;
            this.install = false;
            this.plugin = plugin;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
            try {
                this.timestamp = simpleDateFormat.parse(this.date).getTime();
            }
            catch (ParseException parseException) {
                Log.log(9, this, parseException);
            }
        }

        private void getParents(List<Entry> list) {
            for (Entry entry : this.parents) {
                if (!entry.install || list.contains(entry)) continue;
                list.add(entry);
                entry.getParents(list);
            }
        }

        Entry[] getParents() {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            this.getParents(arrayList);
            Entry[] entryArray = arrayList.toArray(new Entry[arrayList.size()]);
            Arrays.sort(entryArray, new StandardUtilities.StringCompare(true));
            return entryArray;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PluginTableModel
    extends AbstractTableModel {
        private final List entries = new ArrayList();
        private final List filteredEntries = new ArrayList();
        private int sortType = 1;
        private String filterString;
        int sortDirection = 1;

        private PluginTableModel() {
        }

        public void setFilterString(String string) {
            this.filterString = string;
            this.updateFilteredEntries();
        }

        void updateFilteredEntries() {
            this.filteredEntries.clear();
            if (this.filterString == null) {
                this.filteredEntries.addAll(this.entries);
            } else {
                String[] stringArray = this.filterString.toLowerCase().split("\\s+");
                for (Object e : this.entries) {
                    if (!(e instanceof Entry)) continue;
                    Entry entry = (Entry)e;
                    if (entry.install) {
                        this.filteredEntries.add(entry);
                        continue;
                    }
                    String string = (entry.name + ' ' + entry.set + ' ' + entry.description).toLowerCase();
                    boolean bl = true;
                    boolean bl2 = false;
                    for (String string2 : stringArray) {
                        if (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                            bl2 = true;
                        }
                        if (string2.length() == 0) continue;
                        if (bl2 == string.contains(string2)) {
                            bl = false;
                            break;
                        }
                        bl2 = false;
                    }
                    if (!bl) continue;
                    this.filteredEntries.add(entry);
                }
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return Object.class;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return ' ' + jEdit.getProperty("install-plugins.info.name");
                }
                case 2: {
                    return ' ' + jEdit.getProperty("install-plugins.info.category");
                }
                case 3: {
                    return ' ' + jEdit.getProperty("install-plugins.info.version");
                }
                case 4: {
                    return ' ' + jEdit.getProperty("install-plugins.info.size");
                }
                case 5: {
                    return ' ' + jEdit.getProperty("install-plugins.info.releaseDate");
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public int getRowCount() {
            return this.filteredEntries.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object e = this.filteredEntries.get(n);
            if (e instanceof String) {
                if (n2 == 1) {
                    return e;
                }
                return null;
            }
            Entry entry = (Entry)e;
            switch (n2) {
                case 0: {
                    return entry.install;
                }
                case 1: {
                    return entry.name;
                }
                case 2: {
                    return entry.set;
                }
                case 3: {
                    if (InstallPanel.this.updates) {
                        return entry.installedVersion + "->" + entry.version;
                    }
                    return entry.version;
                }
                case 4: {
                    return InstallPanel.formatSize(entry.size);
                }
                case 5: {
                    return entry.date;
                }
            }
            throw new Error("Column out of range");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setSelectAll(boolean bl) {
            if (this.isDownloadingList()) {
                return;
            }
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    this.setValueAt(Boolean.TRUE, i, 0);
                    continue;
                }
                Entry entry = (Entry)this.filteredEntries.get(i);
                entry.parents = new LinkedList<Entry>();
                entry.install = false;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void setSortType(int n) {
            this.sortType = n;
            this.sort(n);
        }

        private void deselectParents(Entry entry) {
            Object[] objectArray = entry.getParents();
            if (objectArray.length == 0) {
                return;
            }
            String[] stringArray = new String[]{entry.name};
            int n = GUIUtilities.listConfirm(InstallPanel.this.window, "plugin-manager.dependency", stringArray, objectArray);
            if (n != 0) {
                entry.install = true;
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                ((Entry)objectArray[i]).install = false;
            }
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 0) {
                return;
            }
            Object e = this.filteredEntries.get(n);
            if (e instanceof String) {
                return;
            }
            Entry entry = (Entry)e;
            boolean bl = entry.install;
            entry.install = Boolean.TRUE.equals(object);
            if (bl == entry.install) {
                return;
            }
            if (!entry.install) {
                this.deselectParents(entry);
            }
            List<PluginList.Dependency> list = entry.plugin.getCompatibleBranch().deps;
            block0: for (int i = 0; i < list.size(); ++i) {
                Entry entry2;
                int n3;
                PluginList.Dependency dependency = list.get(i);
                if (!"plugin".equals(dependency.what)) continue;
                boolean bl2 = false;
                for (n3 = 0; n3 < this.filteredEntries.size(); ++n3) {
                    entry2 = (Entry)this.filteredEntries.get(n3);
                    if (entry2.plugin != dependency.plugin) continue;
                    bl2 = true;
                    if (entry.install) {
                        entry2.parents.add(entry);
                        this.setValueAt(Boolean.TRUE, n3, 0);
                        break;
                    }
                    entry2.parents.remove(entry);
                    break;
                }
                if (bl2) continue;
                for (n3 = 0; n3 < this.entries.size(); ++n3) {
                    entry2 = (Entry)this.entries.get(n3);
                    if (entry2.plugin != dependency.plugin) continue;
                    if (entry.install) {
                        entry2.parents.add(entry);
                        entry2.install = true;
                        continue block0;
                    }
                    entry2.parents.remove(entry);
                    continue block0;
                }
            }
            this.updateFilteredEntries();
        }

        public void sort(int n) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.saveSelection(hashSet, hashSet2);
            if (this.sortType != n) {
                this.sortDirection = 1;
            }
            this.sortType = n;
            if (this.isDownloadingList()) {
                return;
            }
            Collections.sort(this.entries, new EntryCompare(n, this.sortDirection));
            this.updateFilteredEntries();
            this.restoreSelection(hashSet, hashSet2);
            InstallPanel.this.table.getTableHeader().repaint();
        }

        private boolean isDownloadingList() {
            return this.entries.size() == 1 && this.entries.get(0) instanceof String;
        }

        public void clear() {
            this.entries.clear();
            this.updateFilteredEntries();
        }

        public void update() {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.saveSelection(hashSet, hashSet2);
            PluginList pluginList = InstallPanel.this.window.getPluginList();
            if (pluginList == null) {
                return;
            }
            this.entries.clear();
            for (int i = 0; i < pluginList.pluginSets.size(); ++i) {
                PluginList.PluginSet pluginSet = pluginList.pluginSets.get(i);
                for (int j = 0; j < pluginSet.plugins.size(); ++j) {
                    PluginList.Plugin plugin = pluginList.pluginHash.get(pluginSet.plugins.get(j));
                    PluginList.Branch branch = plugin.getCompatibleBranch();
                    String string = plugin.getInstalledVersion();
                    if (InstallPanel.this.updates) {
                        if (branch == null || !branch.canSatisfyDependencies() || string == null || StandardUtilities.compareStrings(branch.version, string, false) <= 0) continue;
                        this.entries.add(new Entry(plugin, pluginSet.name));
                        continue;
                    }
                    if (string != null || !plugin.canBeInstalled()) continue;
                    this.entries.add(new Entry(plugin, pluginSet.name));
                }
            }
            this.sort(this.sortType);
            this.updateFilteredEntries();
            this.restoreSelection(hashSet, hashSet2);
        }

        public void saveSelection(Set<String> set, Set<String> set2) {
            if (this.entries.isEmpty()) {
                return;
            }
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                set.add(this.filteredEntries.get(i).toString());
            }
            int[] nArray = InstallPanel.this.table.getSelectedRows();
            for (n = 0; n < nArray.length; ++n) {
                set2.add(this.filteredEntries.get(nArray[n]).toString());
            }
        }

        public void restoreSelection(Set<String> set, Set<String> set2) {
            String string;
            Object object;
            int n;
            int n2 = this.getRowCount();
            for (n = 0; n < n2; ++n) {
                object = this.filteredEntries.get(n);
                string = object.toString();
                if (object instanceof Entry) {
                    string = ((Entry)object).plugin.jar;
                }
                if (InstallPanel.this.pluginSet.contains(string)) {
                    this.setValueAt(true, n, 0);
                    continue;
                }
                this.setValueAt(set.contains(string), n, 0);
            }
            if (InstallPanel.this.table == null) {
                return;
            }
            InstallPanel.this.table.setColumnSelectionInterval(0, 0);
            if (!set2.isEmpty()) {
                n2 = this.getRowCount();
                for (n = 0; n < n2; ++n) {
                    object = this.filteredEntries.get(n).toString();
                    if (!set2.contains(object)) continue;
                    InstallPanel.this.table.setRowSelectionInterval(n, n);
                    break;
                }
                object = InstallPanel.this.table.getSelectionModel();
                while (n < n2) {
                    string = this.filteredEntries.get(n).toString();
                    if (set2.contains(string)) {
                        object.addSelectionInterval(n, n);
                    }
                    ++n;
                }
            } else {
                if (InstallPanel.this.table.getRowCount() != 0) {
                    InstallPanel.this.table.setRowSelectionInterval(0, 0);
                }
                JScrollBar jScrollBar = InstallPanel.this.scrollpane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMinimum());
            }
        }
    }
}

