/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.InstallPanel;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManager
extends JFrame {
    private static PluginManager instance;
    private JTabbedPane tabPane;
    private JButton done;
    private JButton mgrOptions;
    private JButton pluginOptions;
    private InstallPanel installer;
    private InstallPanel updater;
    private ManagePanel manager;
    private PluginList pluginList;
    private boolean queuedUpdate;
    private boolean downloadingPluginList;
    private final Frame parent;
    public static final String PROPERTY_PLUGINSET = "plugin-manager.pluginset.path";

    public static PluginManager getInstance() {
        return instance;
    }

    @Override
    public void dispose() {
        instance = null;
        EditBus.removeFromBus(this);
        EditBus.removeFromBus(this.installer);
        super.dispose();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        if (this.shouldUpdatePluginList()) {
            this.pluginList = null;
            this.updatePluginList();
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        if (!this.queuedUpdate) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.queuedUpdate = false;
                    PluginManager.this.manager.update();
                }
            });
            this.queuedUpdate = true;
        }
    }

    public static void showPluginManager(Frame frame) {
        if (instance == null) {
            instance = new PluginManager(frame);
        } else {
            instance.toFront();
        }
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    PluginList getPluginList() {
        return this.pluginList;
    }

    void pluginRemoved() {
        this.updater.updateModel();
        this.installer.updateModel();
    }

    private PluginManager(Frame frame) {
        super(jEdit.getProperty("plugin-manager.title"));
        this.parent = frame;
        this.init();
    }

    private void init() {
        EditBus.addToBus(this);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.tabPane = new JTabbedPane();
        this.manager = new ManagePanel(this);
        this.tabPane.addTab(jEdit.getProperty("manage-plugins.title"), this.manager);
        this.updater = new InstallPanel(this, true);
        this.tabPane.addTab(jEdit.getProperty("update-plugins.title"), this.updater);
        this.installer = new InstallPanel(this, false);
        this.tabPane.addTab(jEdit.getProperty("install-plugins.title"), this.installer);
        EditBus.addToBus(this.installer);
        jPanel.add("Center", this.tabPane);
        this.tabPane.addChangeListener(new ListUpdater());
        Box box = new Box(0);
        ActionHandler actionHandler = new ActionHandler();
        this.mgrOptions = new JButton(jEdit.getProperty("plugin-manager.mgr-options"));
        this.mgrOptions.addActionListener(actionHandler);
        this.pluginOptions = new JButton(jEdit.getProperty("plugin-manager.plugin-options"));
        this.pluginOptions.addActionListener(actionHandler);
        this.done = new JButton(jEdit.getProperty("plugin-manager.done"));
        this.done.addActionListener(actionHandler);
        box.add(Box.createGlue());
        box.add(this.mgrOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.pluginOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.done);
        box.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.done);
        jPanel.add("South", box);
        this.setDefaultCloseOperation(2);
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.pack();
        GUIUtilities.loadGeometry(this, this.parent, "plugin-manager");
        GUIUtilities.addSizeSaver(this, this.parent, "plugin-manager");
        this.setVisible(true);
    }

    private boolean shouldUpdatePluginList() {
        return (this.pluginList == null || !this.pluginList.getMirrorId().equals(jEdit.getProperty("plugin-manager.mirror.id"))) && !this.downloadingPluginList;
    }

    private void updatePluginList() {
        if (jEdit.getSettingsDirectory() == null && jEdit.getJEditHome() == null) {
            GUIUtilities.error(this, "no-settings", null);
            return;
        }
        if (!this.shouldUpdatePluginList()) {
            return;
        }
        ThreadUtilities.runInBackground(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void _run() {
                try {
                    PluginManager.this.downloadingPluginList = true;
                    this.setStatus(jEdit.getProperty("plugin-manager.list-download-connect"));
                    PluginManager.this.pluginList = new PluginList(this);
                }
                finally {
                    PluginManager.this.downloadingPluginList = false;
                }
                ThreadUtilities.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        PluginManager.this.pluginListUpdated();
                    }
                });
            }
        });
    }

    private void pluginListUpdated() {
        Component component = this.tabPane.getSelectedComponent();
        if (component == this.installer || component == this.updater) {
            this.installer.updateModel();
            this.updater.updateModel();
        }
    }

    public void processKeyEvents(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this.cancel();
            keyEvent.consume();
        }
    }

    class ListUpdater
    implements ChangeListener {
        ListUpdater() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Component component = PluginManager.this.tabPane.getSelectedComponent();
            if (component == PluginManager.this.installer || component == PluginManager.this.updater) {
                PluginManager.this.updatePluginList();
            } else if (component == PluginManager.this.manager) {
                PluginManager.this.manager.update();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PluginManager.this.done) {
                PluginManager.this.ok();
            } else if (object == PluginManager.this.mgrOptions) {
                new GlobalOptions((Frame)PluginManager.this, "plugin-manager");
            } else if (object == PluginManager.this.pluginOptions) {
                new PluginOptions(PluginManager.this);
            }
        }
    }
}

