/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class SearchBar
extends JToolBar {
    private View view;
    private HistoryTextField find;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox hyperSearch;
    private JCheckBox wholeWord;
    private Timer timer;
    private boolean wasError;
    private Color defaultBackground;
    private Color defaultForeground;
    private Color errorForeground;
    private Color errorBackground;
    private RolloverButton close;
    private int searchStart;
    private boolean searchReverse;
    private boolean isRemovable;

    public SearchBar(final View view, boolean bl) {
        this.view = view;
        this.setLayout(new BoxLayout(this, 0));
        this.setFloatable(false);
        this.add(Box.createHorizontalStrut(2));
        JLabel jLabel = new JLabel(jEdit.getProperty("view.search.find"));
        this.add(jLabel);
        this.add(Box.createHorizontalStrut(12));
        this.find = new HistoryTextField("find");
        this.add(this.find);
        this.find.setSelectAllOnFocus(true);
        SyntaxStyle syntaxStyle = GUIUtilities.parseStyle(jEdit.getProperty("view.style.invalid"), "Dialog", 12);
        this.errorBackground = syntaxStyle.getBackgroundColor();
        this.errorForeground = syntaxStyle.getForegroundColor();
        this.defaultBackground = this.find.getBackground();
        this.defaultForeground = this.find.getForeground();
        Dimension dimension = this.find.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.find.setMaximumSize(dimension);
        ActionHandler actionHandler = new ActionHandler();
        this.find.addKeyListener(new KeyHandler());
        this.find.addActionListener(actionHandler);
        this.find.getDocument().addDocumentListener(new DocumentHandler());
        Insets insets = new Insets(1, 1, 1, 1);
        this.addSeparator(new Dimension(12, 12));
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.case"));
        this.add(this.ignoreCase);
        this.ignoreCase.addActionListener(actionHandler);
        this.ignoreCase.setMargin(insets);
        this.ignoreCase.setOpaque(false);
        this.ignoreCase.setRequestFocusEnabled(false);
        this.add(Box.createHorizontalStrut(2));
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"));
        this.add(this.regexp);
        this.regexp.addActionListener(actionHandler);
        this.regexp.setMargin(insets);
        this.regexp.setOpaque(false);
        this.regexp.setRequestFocusEnabled(false);
        this.add(Box.createHorizontalStrut(2));
        this.hyperSearch = new JCheckBox(jEdit.getProperty("search.hypersearch"));
        this.add(this.hyperSearch);
        this.hyperSearch.addActionListener(actionHandler);
        this.hyperSearch.setMargin(insets);
        this.hyperSearch.setOpaque(false);
        this.hyperSearch.setRequestFocusEnabled(false);
        this.wholeWord = new JCheckBox(jEdit.getProperty("search.word"));
        this.add(this.wholeWord);
        this.wholeWord.addActionListener(actionHandler);
        this.wholeWord.setMargin(insets);
        this.wholeWord.setOpaque(false);
        this.wholeWord.setRequestFocusEnabled(false);
        this.update();
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SearchBar.this.incrementalSearch(SearchBar.this.searchStart, SearchBar.this.searchReverse) && !SearchBar.this.incrementalSearch(SearchBar.this.searchReverse ? view.getBuffer().getLength() : 0, SearchBar.this.searchReverse)) {
                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                }
            }
        });
        this.isRemovable = bl;
        this.setCloseButtonVisibility();
    }

    public HistoryTextField getField() {
        return this.find;
    }

    public void setHyperSearch(boolean bl) {
        jEdit.setBooleanProperty("view.search.hypersearch.toggle", bl);
        this.hyperSearch.setSelected(bl);
    }

    public void update() {
        this.ignoreCase.setSelected(SearchAndReplace.getIgnoreCase());
        this.regexp.setSelected(SearchAndReplace.getRegexp());
        this.wholeWord.setSelected(SearchAndReplace.getWholeWord());
        this.hyperSearch.setSelected(jEdit.getBooleanProperty("view.search.hypersearch.toggle"));
    }

    public void propertiesChanged() {
        this.isRemovable = !jEdit.getBooleanProperty("view.showSearchbar");
        Log.log(1, this, "in SearchBar.propertiesChanged(), isRemovable = " + this.isRemovable);
        this.setCloseButtonVisibility();
    }

    private void find(boolean bl) {
        this.timer.stop();
        String string = this.find.getText();
        if (string.length() == 0) {
            jEdit.setBooleanProperty("search.hypersearch.toggle", this.hyperSearch.isSelected());
            SearchDialog.showSearchDialog(this.view, null, 0);
        } else if (this.hyperSearch.isSelected()) {
            if (this.isRemovable) {
                this.view.removeToolBar(this);
            } else {
                this.find.setText(null);
            }
            SearchAndReplace.setSearchString(string);
            SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
            SearchAndReplace.hyperSearch(this.view);
        } else {
            JEditTextArea jEditTextArea = this.view.getTextArea();
            Selection selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
            int n = selection == null ? jEditTextArea.getCaretPosition() : (bl ? selection.getStart() : selection.getEnd());
            if (!this.incrementalSearch(n, bl)) {
                if (!this.incrementalSearch(bl ? this.view.getBuffer().getLength() : 0, bl)) {
                    this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                } else {
                    this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                    if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                        this.getToolkit().beep();
                    }
                }
            }
        }
    }

    private boolean incrementalSearch(int n, boolean bl) {
        SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
        SearchAndReplace.setSearchString(this.find.getText());
        SearchAndReplace.setReverseSearch(bl);
        boolean bl2 = false;
        try {
            if (SearchAndReplace.find(this.view, this.view.getBuffer(), n, false, bl)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            Log.log(1, this, exception);
            bl2 = true;
        }
        if (bl2) {
            if (this.wasError) {
                this.find.setForeground(this.defaultForeground);
                this.find.setBackground(this.defaultBackground);
                this.wasError = false;
            }
        } else if (!this.wasError) {
            this.find.setForeground(this.errorForeground);
            this.find.setBackground(this.errorBackground);
            this.wasError = true;
        }
        return bl2;
    }

    private void timerIncrementalSearch(int n, boolean bl) {
        this.searchStart = n;
        this.searchReverse = bl;
        this.timer.stop();
        this.timer.setRepeats(false);
        this.timer.setInitialDelay(150);
        this.timer.start();
    }

    private void setCloseButtonVisibility() {
        if (this.isRemovable) {
            if (this.close == null) {
                this.close = new RolloverButton(GUIUtilities.loadIcon("closebox.gif"));
                this.close.addActionListener(new ActionHandler());
                this.close.setToolTipText(jEdit.getProperty("view.search.close-tooltip"));
            }
            this.add(this.close);
        } else if (this.close != null) {
            this.remove(this.close);
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SearchBar.this.getField().addCurrentToHistory();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    if (SearchBar.this.isRemovable) {
                        SearchBar.this.view.removeToolBar(SearchBar.this);
                    }
                    keyEvent.consume();
                    SearchBar.this.view.getEditPane().focusOnTextArea();
                    break;
                }
                case 10: {
                    if (!keyEvent.isShiftDown()) break;
                    keyEvent.consume();
                    SearchBar.this.find(true);
                }
            }
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!SearchBar.this.hyperSearch.isSelected()) {
                JEditTextArea jEditTextArea = SearchBar.this.view.getTextArea();
                Selection selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
                int n = selection == null ? jEditTextArea.getCaretPosition() : selection.getStart();
                SearchBar.this.timerIncrementalSearch(n, false);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            String string;
            if (!SearchBar.this.hyperSearch.isSelected() && (string = SearchBar.this.find.getText()).length() != 0) {
                if (SearchBar.this.regexp.isSelected()) {
                    SearchBar.this.timerIncrementalSearch(0, false);
                } else {
                    JEditTextArea jEditTextArea = SearchBar.this.view.getTextArea();
                    Selection selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
                    int n = selection == null ? jEditTextArea.getCaretPosition() : selection.getStart();
                    SearchBar.this.timerIncrementalSearch(n, true);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchBar.this.find) {
                SearchBar.this.find(false);
            } else if (object == SearchBar.this.hyperSearch) {
                jEdit.setBooleanProperty("view.search.hypersearch.toggle", SearchBar.this.hyperSearch.isSelected());
                SearchBar.this.update();
            } else if (object == SearchBar.this.ignoreCase) {
                SearchAndReplace.setIgnoreCase(SearchBar.this.ignoreCase.isSelected());
            } else if (object == SearchBar.this.regexp) {
                SearchAndReplace.setRegexp(SearchBar.this.regexp.isSelected());
            } else if (object == SearchBar.this.wholeWord) {
                SearchAndReplace.setWholeWord(SearchBar.this.wholeWord.isSelected());
            } else if (object == SearchBar.this.close) {
                SearchBar.this.view.removeToolBar(SearchBar.this);
                SearchBar.this.view.getEditPane().focusOnTextArea();
            }
        }
    }
}

