/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class DisplayTokenHandler
extends DefaultTokenHandler {
    public static final int MAX_CHUNK_LEN = 100;
    private SyntaxStyle[] styles;
    private FontRenderContext fontRenderContext;
    private TabExpander expander;
    private float x;
    private int physicalLineOffset;
    private List<Chunk> out;
    private float wrapMargin;
    private float endX;
    private Token end;
    private boolean seenNonWhitespace;
    private float endOfWhitespace;

    public void init(SyntaxStyle[] syntaxStyleArray, FontRenderContext fontRenderContext, TabExpander tabExpander, List<Chunk> list, float f, int n) {
        super.init();
        this.x = 0.0f;
        this.styles = syntaxStyleArray;
        this.fontRenderContext = fontRenderContext;
        this.expander = tabExpander;
        this.physicalLineOffset = n;
        this.wrapMargin = f != 0.0f ? f + 2.0f : 0.0f;
        this.out = list;
        this.seenNonWhitespace = false;
        this.endOfWhitespace = 0.0f;
        this.endX = 0.0f;
        this.end = null;
    }

    public List<Chunk> getChunkList() {
        return this.out;
    }

    @Override
    public void handleToken(Segment segment, byte by, int n, int n2, TokenMarker.LineContext lineContext) {
        if (by == 127) {
            if (this.firstToken != null) {
                this.out.add(this.merge((Chunk)this.firstToken, segment));
            }
            return;
        }
        for (int i = 0; i < n2; i += 100) {
            int n3 = Math.min(n2 - i, 100);
            Chunk chunk = this.createChunk(by, n + i, n3, lineContext);
            this.addToken(chunk, lineContext);
            if (this.wrapMargin == 0.0f) continue;
            this.initChunk(chunk, segment, this.physicalLineOffset);
            this.x += chunk.width;
            if (Character.isWhitespace(segment.array[segment.offset + chunk.offset])) {
                if (this.seenNonWhitespace) {
                    this.end = this.lastToken;
                    this.endX = this.x;
                    continue;
                }
                this.endOfWhitespace = this.x;
                continue;
            }
            if (this.x > this.wrapMargin && this.end != null && this.seenNonWhitespace) {
                Chunk chunk2 = new Chunk(this.endOfWhitespace, this.end.offset + this.end.length, this.getParserRuleSet(lineContext));
                this.initChunk(chunk2, segment, this.physicalLineOffset);
                chunk2.next = this.end.next;
                this.end.next = null;
                if (this.firstToken != null) {
                    this.out.add(this.merge((Chunk)this.firstToken, segment));
                }
                this.firstToken = chunk2;
                this.x = this.x - this.endX + this.endOfWhitespace;
                this.end = null;
                this.endX = this.x;
            }
            this.seenNonWhitespace = true;
        }
    }

    private Chunk createChunk(byte by, int n, int n2, TokenMarker.LineContext lineContext) {
        return new Chunk(by, n, n2, this.getParserRuleSet(lineContext), this.styles, lineContext.rules.getDefault());
    }

    protected void initChunk(Chunk chunk, Segment segment, int n) {
        chunk.init(segment, this.expander, this.x, this.fontRenderContext, n);
    }

    private Chunk merge(Chunk chunk, Segment segment) {
        if (chunk == null) {
            return null;
        }
        Chunk chunk2 = chunk;
        while (chunk2.next != null) {
            Chunk chunk3 = (Chunk)chunk2.next;
            if (DisplayTokenHandler.canMerge(chunk2, chunk3, segment)) {
                chunk2.initialized = false;
                chunk2.length += chunk3.length;
                chunk2.width += chunk3.width;
                chunk2.next = chunk3.next;
                continue;
            }
            if (!chunk2.initialized) {
                this.initChunk(chunk2, segment, this.physicalLineOffset);
                if (this.wrapMargin == 0.0f) {
                    this.x += chunk2.width;
                }
            }
            chunk2 = chunk3;
        }
        if (!chunk2.initialized) {
            this.initChunk(chunk2, segment, this.physicalLineOffset);
        }
        return chunk;
    }

    private static boolean canMerge(Chunk chunk, Chunk chunk2, Segment segment) {
        if (!chunk.accessable || !chunk2.accessable) {
            return false;
        }
        char c = segment.array[segment.offset + chunk.offset];
        char c2 = segment.array[segment.offset + chunk2.offset];
        return chunk.style == chunk2.style && c != '\t' && c2 != '\t' && chunk.length + chunk2.length <= 100;
    }
}

