/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private LinkedHashMap<String, Mode> modes = new LinkedHashMap(180);
    private LinkedHashMap<String, Mode> overrideModes = new LinkedHashMap(20);

    public void removeAll() {
        this.modes.clear();
        this.overrideModes.clear();
    }

    public Mode getMode(String string) {
        Mode mode = this.overrideModes.get(string);
        if (mode == null) {
            mode = this.modes.get(string);
        }
        return mode;
    }

    public Mode getModeForFile(String string, String string2) {
        return this.getModeForFile(null, string, string2);
    }

    public Mode getModeForFile(String string, String string2, String string3) {
        if (string != null && string.endsWith(".gz")) {
            string = string.substring(0, string.length() - 3);
        }
        if (string2 != null && string2.endsWith(".gz")) {
            string2 = string2.substring(0, string2.length() - 3);
        }
        ArrayList<Mode> arrayList = new ArrayList<Mode>();
        for (Mode mode : this.overrideModes.values()) {
            if (!mode.accept(string, string2, string3)) continue;
            arrayList.add(mode);
        }
        if (arrayList.size() == 0) {
            for (Mode mode : this.modes.values()) {
                if (!mode.accept(string, string2, string3)) continue;
                arrayList.add(mode);
            }
        }
        if (arrayList.size() == 1) {
            return (Mode)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            Collections.reverse(arrayList);
            for (Mode mode : arrayList) {
                if (!mode.acceptIdentical(string, string2)) continue;
                return mode;
            }
            for (Mode mode : arrayList) {
                if (!mode.acceptFile(string, string2) || !mode.acceptFirstLine(string3)) continue;
                return mode;
            }
            for (Mode mode : arrayList) {
                if (!mode.acceptFile(string, string2)) continue;
                return mode;
            }
            return (Mode)arrayList.get(0);
        }
        return null;
    }

    public Mode[] getModes() {
        Mode[] modeArray = new Mode[this.modes.size() + this.overrideModes.size()];
        Mode[] modeArray2 = this.modes.values().toArray(new Mode[0]);
        Mode[] modeArray3 = this.overrideModes.values().toArray(new Mode[0]);
        System.arraycopy(modeArray2, 0, modeArray, 0, modeArray2.length);
        System.arraycopy(modeArray3, 0, modeArray, modeArray2.length, modeArray3.length);
        return modeArray;
    }

    public void addMode(Mode mode) {
        if (this.modes.get(mode.getName()) != null) {
            this.overrideModes.put(mode.getName(), mode);
            this.modes.remove(mode.getName());
        } else {
            this.modes.put(mode.getName(), mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMode(Mode mode, XModeHandler xModeHandler) {
        BufferedInputStream bufferedInputStream;
        XMLReader xMLReader;
        String string = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + string);
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            Log.log(9, this, sAXException);
            return;
        }
        mode.setTokenMarker(xModeHandler.getTokenMarker());
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream inputStream = ModeProvider.class.getResourceAsStream(string);
            if (inputStream == null) {
                this.error(string, fileNotFoundException);
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
        }
        try {
            InputSource inputSource = new InputSource(bufferedInputStream);
            inputSource.setSystemId("jedit.jar");
            xMLReader.setContentHandler(xModeHandler);
            xMLReader.setDTDHandler(xModeHandler);
            xMLReader.setEntityResolver(xModeHandler);
            xMLReader.setErrorHandler(xModeHandler);
            xMLReader.parse(inputSource);
            mode.setProperties(xModeHandler.getModeProperties());
        }
        catch (Throwable throwable) {
            this.error(string, throwable);
        }
        finally {
            IOUtilities.closeQuietly(bufferedInputStream);
        }
    }

    public void loadMode(Mode mode) {
        XModeHandler xModeHandler = new XModeHandler(mode.getName()){

            @Override
            public void error(String string, Object object) {
                Log.log(9, this, object);
            }

            @Override
            public TokenMarker getTokenMarker(String string) {
                Mode mode = ModeProvider.this.getMode(string);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xModeHandler);
    }

    protected void error(String string, Throwable throwable) {
        Log.log(9, this, throwable);
    }
}

