/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

abstract class Anchor {
    protected final DisplayManager displayManager;
    protected final TextArea textArea;
    int physicalLine;
    int scrollLine;
    boolean callChanged;
    boolean callReset;

    protected Anchor(DisplayManager displayManager, TextArea textArea) {
        this.displayManager = displayManager;
        this.textArea = textArea;
    }

    abstract void reset();

    abstract void changed();

    public String toString() {
        return this.getClass().getName() + '[' + this.physicalLine + ',' + this.scrollLine + ']';
    }

    void contentInserted(int n, int n2) {
        if (this.physicalLine >= n) {
            if (this.physicalLine != n) {
                this.physicalLine += n2;
            }
            this.callChanged = true;
        }
    }

    void preContentRemoved(int n, int n2, int n3) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "preContentRemoved() before:" + this);
        }
        if (this.physicalLine >= n) {
            if (this.physicalLine == n) {
                this.callChanged = true;
            } else {
                int n4 = Math.min(n + n3, this.physicalLine);
                for (int i = n + 1; i <= n4; ++i) {
                    if (!this.displayManager.isLineVisible(i)) continue;
                    this.scrollLine -= this.displayManager.screenLineMgr.getScreenLineCount(i);
                }
                this.physicalLine -= n4 - n;
                this.callChanged = true;
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "preContentRemoved() after:" + this);
        }
    }
}

