/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class FirstLine
extends Anchor {
    int skew;

    FirstLine(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    @Override
    public void changed() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() before: " + this.physicalLine + ':' + this.scrollLine + ':' + this.skew);
        }
        this.ensurePhysicalLineIsVisible();
        int n = this.displayManager.getScreenLineCount(this.physicalLine);
        if (this.skew >= n) {
            this.skew = n - 1;
        }
        if (Debug.SCROLL_VERIFY) {
            System.err.println("SCROLL_VERIFY");
            int n2 = 0;
            for (int i = 0; i < this.displayManager.getBuffer().getLineCount(); ++i) {
                if (!this.displayManager.isLineVisible(i)) continue;
                if (i >= this.physicalLine) break;
                n2 += this.displayManager.getScreenLineCount(i);
            }
            if (n2 != this.scrollLine) {
                Exception exception = new Exception(this.scrollLine + ":" + n2);
                Log.log(9, this, exception);
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() after: " + this.physicalLine + ':' + this.scrollLine + ':' + this.skew);
        }
    }

    @Override
    public void reset() {
        int n;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int n2 = this.physicalLine;
        this.physicalLine = 0;
        this.scrollLine = 0;
        int n3 = this.displayManager.getFirstVisibleLine();
        while (n3 < n2) {
            this.scrollLine += this.displayManager.getScreenLineCount(n3);
            n = this.displayManager.getNextVisibleLine(n3);
            if (n == -1) break;
            n3 = n;
        }
        this.physicalLine = n3;
        n = this.displayManager.getScreenLineCount(this.physicalLine);
        if (this.skew >= n) {
            this.skew = n - 1;
        }
        this.textArea.updateScrollBar();
    }

    void physDown(int n, int n2) {
        int n3;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() start: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.skew = 0;
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            n3 = this.displayManager.getLastVisibleLine();
            if (this.physicalLine > n3) {
                this.physicalLine = n3;
            } else {
                int n4 = this.displayManager.getNextVisibleLine(this.physicalLine);
                n -= n4 - this.physicalLine;
                this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
                this.physicalLine = n4;
            }
        }
        while ((n3 = this.displayManager.getNextVisibleLine(this.physicalLine)) != -1 && n3 <= this.physicalLine + n) {
            this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
            n -= n3 - this.physicalLine;
            this.physicalLine = n3;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() end: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.callChanged = true;
        if (n2 < 0) {
            this.scrollUp(-n2);
        } else if (n2 > 0) {
            this.scrollDown(n2);
        }
    }

    void physUp(int n, int n2) {
        int n3;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() start: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.skew = 0;
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            n3 = this.displayManager.getFirstVisibleLine();
            if (this.physicalLine < n3) {
                this.physicalLine = n3;
            } else {
                int n4 = this.displayManager.getPrevVisibleLine(this.physicalLine);
                n -= this.physicalLine - n4;
            }
        }
        while ((n3 = this.displayManager.getPrevVisibleLine(this.physicalLine)) != -1 && n3 >= this.physicalLine - n) {
            n -= this.physicalLine - n3;
            this.physicalLine = n3;
            this.scrollLine -= this.displayManager.getScreenLineCount(n3);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() end: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.callChanged = true;
        if (n2 < 0) {
            this.scrollUp(-n2);
        } else if (n2 > 0) {
            this.scrollDown(n2);
        }
    }

    void scrollDown(int n) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollDown()");
        }
        this.ensurePhysicalLineIsVisible();
        n += this.skew;
        this.skew = 0;
        while (n > 0) {
            int n2 = this.displayManager.getScreenLineCount(this.physicalLine);
            if (n < n2) {
                this.skew = n;
                break;
            }
            int n3 = this.displayManager.getNextVisibleLine(this.physicalLine);
            if (n3 == -1) break;
            boolean bl = this.displayManager.isLineVisible(this.physicalLine);
            this.physicalLine = n3;
            if (!bl) continue;
            n -= n2;
            this.scrollLine += n2;
        }
        this.callChanged = true;
    }

    void scrollUp(int n) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() before:" + this);
        }
        this.ensurePhysicalLineIsVisible();
        if (n <= this.skew) {
            this.skew -= n;
        } else {
            int n2;
            n -= this.skew;
            this.skew = 0;
            while (n > 0 && (n2 = this.displayManager.getPrevVisibleLine(this.physicalLine)) != -1) {
                this.physicalLine = n2;
                int n3 = this.displayManager.getScreenLineCount(this.physicalLine);
                this.scrollLine -= n3;
                if (n < n3) {
                    this.skew = n3 - n;
                    break;
                }
                n -= n3;
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() after:" + this);
        }
        this.callChanged = true;
    }

    void ensurePhysicalLineIsVisible() {
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            if (this.physicalLine > this.displayManager.getLastVisibleLine()) {
                this.physicalLine = this.displayManager.getLastVisibleLine();
                this.scrollLine = this.displayManager.getScrollLineCount() - 1;
            } else if (this.physicalLine < this.displayManager.getFirstVisibleLine()) {
                this.physicalLine = this.displayManager.getFirstVisibleLine();
                this.scrollLine = 0;
            } else {
                this.physicalLine = this.displayManager.getNextVisibleLine(this.physicalLine);
                this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
            }
        }
    }

    @Override
    public String toString() {
        return "FirstLine[" + this.physicalLine + ',' + this.scrollLine + ',' + this.skew + ']';
    }
}

