/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private static final int SCREEN_LINES_SHIFT = 1;
    private static final int SCREEN_LINES_VALID_MASK = 1;
    private final JEditBuffer buffer;
    private short[] screenLines;

    ScreenLineManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
        if (!jEditBuffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int n) {
        return (this.screenLines[n] & 1) != 0;
    }

    int getScreenLineCount(int n) {
        return this.screenLines[n] >> 1;
    }

    void setScreenLineCount(int n, int n2) {
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, new Exception("setScreenLineCount(" + n + ',' + n2 + ')'));
        }
        this.screenLines[n] = (short)(n2 << 1 | 1);
    }

    void invalidateScreenLineCounts() {
        int n = this.buffer.getLineCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.screenLines[n3] = (short)(this.screenLines[n3] & 0xFFFFFFFE);
        }
    }

    void reset() {
        this.screenLines = new short[this.buffer.getLineCount()];
    }

    public void contentInserted(int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        this.screenLines[n4] = (short)(this.screenLines[n4] & 0xFFFFFFFE);
        int n5 = this.buffer.getLineCount();
        if (n2 > 0) {
            if (this.screenLines.length <= n5) {
                short[] sArray = new short[n5 + 1 << 1];
                System.arraycopy(this.screenLines, 0, sArray, 0, this.screenLines.length);
                this.screenLines = sArray;
            }
            System.arraycopy(this.screenLines, n, this.screenLines, n3, n5 - n3);
            for (int i = 0; i < n2; ++i) {
                this.screenLines[n + i] = 0;
            }
        }
    }

    public void contentRemoved(int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        this.screenLines[n4] = (short)(this.screenLines[n4] & 0xFFFFFFFE);
        if (n2 > 0 && n3 != this.screenLines.length) {
            System.arraycopy(this.screenLines, n3 + 1, this.screenLines, n + 1, this.screenLines.length - n3 - 1);
        }
    }
}

