/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import javax.swing.event.EventListenerList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.gjt.sp.util.WorkThread;
import org.gjt.sp.util.WorkThreadProgressListener;

@Deprecated
public class WorkThreadPool {
    final Object lock = new Object();
    final Object waitForAllLock = new Object();
    private boolean started;
    private ThreadGroup threadGroup;
    private WorkThread[] threads;
    private Request firstRequest;
    private Request lastRequest;
    private int requestCount;
    private boolean awtRunnerQueued;
    private Request firstAWTRequest;
    private Request lastAWTRequest;
    private int awtRequestCount;
    private final EventListenerList listenerList = new EventListenerList();
    static int ID;

    public WorkThreadPool(String string, int n) {
        if (n != 0) {
            this.threadGroup = new ThreadGroup(string);
            this.threads = new WorkThread[n];
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i] = new WorkThread(this, this.threadGroup, string + " #" + (i + 1));
            }
        } else {
            Log.log(7, this, "Async I/O disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
            if (this.awtRequestCount != 0 && this.requestCount == 0) {
                this.queueAWTRunner();
            }
        }
        if (this.threads != null) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkRequest(Runnable runnable, boolean bl) {
        if (this.threads == null) {
            runnable.run();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started && bl && this.requestCount == 0 && this.awtRequestCount == 0) {
                ThreadUtilities.runInDispatchThread(runnable);
                return;
            }
            Request request = new Request(runnable);
            if (bl) {
                if (this.firstAWTRequest == null && this.lastAWTRequest == null) {
                    this.firstAWTRequest = this.lastAWTRequest = request;
                } else {
                    this.lastAWTRequest.next = request;
                    this.lastAWTRequest = request;
                }
                ++this.awtRequestCount;
                if (this.started && this.requestCount == 0) {
                    this.queueAWTRunner();
                }
            } else {
                if (this.firstRequest == null && this.lastRequest == null) {
                    this.firstRequest = this.lastRequest = request;
                } else {
                    this.lastRequest.next = request;
                    this.lastRequest = request;
                }
                ++this.requestCount;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRequests() {
        if (this.threads == null) {
            return;
        }
        Object object = this.waitForAllLock;
        synchronized (object) {
            while (this.requestCount != 0) {
                try {
                    this.waitForAllLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.log(9, this, interruptedException);
                }
            }
        }
        if (EventQueue.isDispatchThread()) {
            this.doAWTRequests();
        } else {
            try {
                EventQueue.invokeAndWait(new RunRequestsInAWTThread());
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getThreadCount() {
        if (this.threads == null) {
            return 0;
        }
        return this.threads.length;
    }

    public WorkThread getThread(int n) {
        return this.threads[n];
    }

    public void addProgressListener(WorkThreadProgressListener workThreadProgressListener) {
        this.listenerList.add(WorkThreadProgressListener.class, workThreadProgressListener);
    }

    public void removeProgressListener(WorkThreadProgressListener workThreadProgressListener) {
        this.listenerList.remove(WorkThreadProgressListener.class, workThreadProgressListener);
    }

    void fireStatusChanged(WorkThread workThread) {
        Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length != 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.threads.length; ++n) {
                if (this.threads[n] != workThread) continue;
                n2 = n;
                break;
            }
            for (n = objectArray.length - 2; n >= 0; --n) {
                if (objectArray[n] != WorkThreadProgressListener.class) continue;
                ((WorkThreadProgressListener)objectArray[n + 1]).statusUpdate(this, n2);
            }
        }
    }

    void fireProgressChanged(WorkThread workThread) {
        Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length != 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.threads.length; ++n) {
                if (this.threads[n] != workThread) continue;
                n2 = n;
                break;
            }
            for (n = objectArray.length - 2; n >= 0; --n) {
                if (objectArray[n] != WorkThreadProgressListener.class) continue;
                ((WorkThreadProgressListener)objectArray[n + 1]).progressUpdate(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestDone() {
        Object object = this.lock;
        synchronized (object) {
            --this.requestCount;
            if (this.requestCount == 0 && this.firstAWTRequest != null) {
                this.queueAWTRunner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request getNextRequest() {
        Object object = this.lock;
        synchronized (object) {
            Request request = this.firstRequest;
            if (request == null) {
                return null;
            }
            this.firstRequest = this.firstRequest.next;
            if (this.firstRequest == null) {
                this.lastRequest = null;
            }
            if (request.alreadyRun) {
                throw new InternalError("AIEE!!! Request run twice!!! " + request.run);
            }
            request.alreadyRun = true;
            return request;
        }
    }

    private void doAWTRequests() {
        while (this.requestCount == 0 && this.firstAWTRequest != null) {
            this.doAWTRequest(this.getNextAWTRequest());
        }
    }

    private void doAWTRequest(Request request) {
        try {
            request.run.run();
        }
        catch (Throwable throwable) {
            Log.log(9, WorkThread.class, "Exception in AWT thread:");
            Log.log(9, WorkThread.class, throwable);
        }
        --this.awtRequestCount;
    }

    private void queueAWTRunner() {
        if (!this.awtRunnerQueued) {
            this.awtRunnerQueued = true;
            EventQueue.invokeLater(new RunRequestsInAWTThread());
        }
    }

    private Request getNextAWTRequest() {
        Request request = this.firstAWTRequest;
        this.firstAWTRequest = this.firstAWTRequest.next;
        if (this.firstAWTRequest == null) {
            this.lastAWTRequest = null;
        }
        if (request.alreadyRun) {
            throw new InternalError("AIEE!!! Request run twice!!! " + request.run);
        }
        request.alreadyRun = true;
        return request;
    }

    class RunRequestsInAWTThread
    implements Runnable {
        RunRequestsInAWTThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = WorkThreadPool.this.lock;
            synchronized (object) {
                WorkThreadPool.this.awtRunnerQueued = false;
                if (WorkThreadPool.this.requestCount == 0) {
                    WorkThreadPool.this.doAWTRequests();
                }
            }
        }
    }

    static class Request {
        int id = ++ID;
        Runnable run;
        boolean alreadyRun;
        Request next;

        Request(Runnable runnable) {
            this.run = runnable;
        }

        public String toString() {
            return "[id=" + this.id + ",run=" + this.run + ']';
        }
    }
}

