/*
 * Decompiled with CFR 0.152.
 */
package console.commando;

import console.Console;
import console.ConsolePlugin;
import console.commando.CommandoCommand;
import console.commando.CommandoHandler;
import console.commando.CommandoThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.This;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CommandoDialog
extends EnhancedDialog {
    private View view;
    private JComboBox commandCombo;
    private JTabbedPane tabs;
    private SettingsPane settings;
    private TextAreaPane commandLine;
    private JButton ok;
    private JButton cancel;
    private CommandoCommand command;
    private NameSpace nameSpace;
    private List<CommandoHandler.Script> scripts;
    private List<This> components;
    private boolean init;

    public CommandoDialog(View view, String command) {
        super((Frame)view, jEdit.getProperty((String)"commando.title"), false);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout(0, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel top = new JPanel(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty((String)"commando.caption"));
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        top.add("West", label);
        content.add("North", top);
        EditAction[] commands = ConsolePlugin.getCommandoCommands();
        ActionHandler actionListener = new ActionHandler();
        this.commandCombo = new JComboBox<EditAction>(commands);
        this.commandCombo.setRenderer(new Renderer());
        this.commandCombo.addActionListener(actionListener);
        top.add("Center", this.commandCombo);
        this.tabs = new JTabbedPane();
        this.settings = new SettingsPane();
        this.tabs.addTab(jEdit.getProperty((String)"commando.settings"), this.settings);
        this.commandLine = new TextAreaPane();
        this.tabs.addTab(jEdit.getProperty((String)"commando.commands"), this.commandLine);
        this.tabs.addChangeListener(new ChangeHandler());
        if (command == null) {
            command = jEdit.getProperty((String)"commando.last-command");
        }
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getName().equals(command)) continue;
            this.commandCombo.setSelectedIndex(i);
            break;
        }
        this.load((CommandoCommand)((Object)this.commandCombo.getSelectedItem()));
        content.add("Center", this.tabs);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.addActionListener(actionListener);
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.cancel.addActionListener(actionListener);
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        this.setVisible(true);
    }

    public void ok() {
        this.updateNameSpace();
        this.save();
        Vector<CommandoHandler.Command> commands = new Vector<CommandoHandler.Command>();
        for (int i = 0; i < this.scripts.size(); ++i) {
            CommandoHandler.Script script = this.scripts.get(i);
            CommandoHandler.Command cmd = script.getCommand();
            if (cmd == null) {
                return;
            }
            commands.addElement(cmd);
        }
        DockableWindowManager wm = this.view.getDockableWindowManager();
        wm.addDockableWindow("console");
        CommandoThread thread = new CommandoThread((Console)wm.getDockable("console"), commands);
        thread.start();
        this.dispose();
    }

    public void cancel() {
        jEdit.setProperty((String)"commando.last-command", (String)this.command.getName());
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(CommandoCommand command) {
        this.init = true;
        this.command = command;
        this.settings.removeAll();
        this.components = new ArrayList<This>();
        this.commandLine.setText(null);
        this.nameSpace = new NameSpace(BeanShell.getNameSpace(), "commando");
        this.scripts = new ArrayList<CommandoHandler.Script>();
        CommandoHandler handler = new CommandoHandler(this.view, command, this.settings, this.nameSpace, this.components, this.scripts);
        Reader in = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setErrorHandler(handler);
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            in = command.openStream();
            parser.parse(new InputSource(in));
        }
        catch (SAXParseException xe) {
            Log.log((int)9, (Object)((Object)this), (Object)xe);
            int line = xe.getLineNumber();
            String message = xe.getMessage();
            Object[] pp = new Object[]{command.getLabel() + ".xml", line, message};
            GUIUtilities.error(null, (String)"commando.xml-error", (Object[])pp);
        }
        catch (IOException io) {
            Log.log((int)9, (Object)((Object)this), (Object)io);
            Object[] pp = new Object[]{command.getLabel() + ".xml", io.toString()};
            GUIUtilities.error(null, (String)"read-error", (Object[])pp);
        }
        catch (Exception e) {
            Log.log((int)9, (Object)((Object)this), (Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException io) {
                Log.log((int)9, (Object)((Object)this), (Object)io);
            }
        }
        this.getRootPane().revalidate();
        this.pack();
        this.init = false;
        this.tabs.setSelectedIndex(0);
    }

    private void save() {
        jEdit.setProperty((String)"commando.last-command", (String)this.command.getName());
        try {
            String[] names = this.nameSpace.getVariableNames();
            for (int i = 0; i < names.length; ++i) {
                Object var = this.nameSpace.getVariable(names[i]);
                if (var == Primitive.VOID) continue;
                jEdit.setProperty((String)(this.command.getPropertyPrefix() + names[i]), (String)String.valueOf(var));
            }
        }
        catch (UtilEvalError e) {
            Log.log((int)9, (Object)((Object)this), (Object)((Object)e));
        }
    }

    private void updateNameSpace() {
        for (int i = 0; i < this.components.size(); ++i) {
            This t = this.components.get(i);
            try {
                t.invokeMethod("valueChanged", new Object[0]);
                continue;
            }
            catch (EvalError e) {
                Log.log((int)9, (Object)((Object)this), (Object)((Object)e));
            }
        }
    }

    private void updateTextArea() {
        if (this.init) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.scripts.size(); ++i) {
            CommandoHandler.Script script = this.scripts.get(i);
            CommandoHandler.Command command = script.getCommand();
            if (command == null) {
                return;
            }
            buf.append(command.shell);
            buf.append(": ");
            buf.append(command.command);
            buf.append('\n');
        }
        this.commandLine.setText(buf.toString());
    }

    static class TextAreaPane
    extends JPanel {
        private JButton copy;
        private JTextArea textArea;

        TextAreaPane() {
            super(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new EmptyBorder(6, 0, 6, 0));
            this.copy = new JButton(jEdit.getProperty((String)"commando.copy"));
            panel.add("West", this.copy);
            this.copy.addActionListener(new ActionHandler());
            this.add("North", panel);
            this.textArea = new JTextArea(4, 30);
            this.add("Center", new JScrollPane(this.textArea));
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
        }

        void setText(String text) {
            this.textArea.setText(text);
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAreaPane.this.textArea.copy();
            }
        }
    }

    public static class SettingsPane
    extends JPanel {
        private GridBagLayout gridBag = new GridBagLayout();
        private int y;

        SettingsPane() {
            this.setLayout(this.gridBag);
        }

        public void addComponent(String left, Component right) {
            JLabel label = new JLabel(left + ":");
            label.setBorder(new EmptyBorder(0, 0, 0, 12));
            this.addComponent(label, right);
        }

        public void addComponent(Component left, Component right) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridy = this.y++;
            cons.gridheight = 1;
            cons.gridwidth = 1;
            cons.weightx = 0.0;
            cons.fill = 1;
            this.gridBag.setConstraints(left, cons);
            this.add(left);
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.gridBag.setConstraints(right, cons);
            this.add(right);
        }

        public void addComponent(Component comp) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridy = this.y++;
            cons.gridheight = 1;
            cons.gridwidth = 0;
            cons.fill = 1;
            cons.anchor = 17;
            cons.weightx = 1.0;
            this.gridBag.setConstraints(comp, cons);
            this.add(comp);
        }
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (CommandoDialog.this.tabs.getSelectedIndex() == 1) {
                CommandoDialog.this.updateNameSpace();
                CommandoDialog.this.updateTextArea();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == CommandoDialog.this.commandCombo) {
                CommandoCommand command = (CommandoCommand)((Object)CommandoDialog.this.commandCombo.getSelectedItem());
                CommandoDialog.this.load(command);
            } else if (evt.getSource() == CommandoDialog.this.ok) {
                CommandoDialog.this.ok();
            } else if (evt.getSource() == CommandoDialog.this.cancel) {
                CommandoDialog.this.cancel();
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3950379651562103708L;

        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            EditAction action = (EditAction)value;
            this.setText(action.getLabel());
            return this;
        }
    }
}

