/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.Shell;
import console.gui.Label;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.StringList;

public class GeneralOptionPane
extends AbstractOptionPane
implements ActionListener {
    private FontSelector font;
    private JComboBox encoding;
    private JComboBox defaultShell;
    private JButton bgColor;
    private JButton usejEditBgColor;
    private JButton plainColor;
    private JButton caretColor;
    private JButton infoColor;
    private JButton warningColor;
    private JButton errorColor;
    private JCheckBox showWelcomeMessage;
    private JTextField limit;
    private JTextField limitHistory;

    public GeneralOptionPane() {
        super("console.general");
    }

    protected void _init() {
        StringList sl = new StringList((Object[])Shell.getShellNames());
        int idx = sl.indexOf((Object)"System");
        if (idx != 0) {
            String other = (String)sl.get(0);
            sl.set(idx, (Object)other);
            sl.set(0, (Object)"System");
        }
        sl.add((Object)jEdit.getProperty((String)"options.last-selected"));
        this.defaultShell = new JComboBox<String>(sl.toArray());
        String ds = jEdit.getProperty((String)"console.shell.default", (String)"System");
        this.defaultShell.setSelectedItem(ds);
        this.addComponent(jEdit.getProperty((String)"options.console.general.defaultshell", (String)"Default Shell:"), this.defaultShell);
        this.showWelcomeMessage = new JCheckBox();
        this.showWelcomeMessage.setText(jEdit.getProperty((String)"options.console.general.welcome"));
        this.showWelcomeMessage.setSelected(jEdit.getBooleanProperty((String)"console.shell.info.toggle"));
        this.addComponent(this.showWelcomeMessage);
        this.font = new FontSelector(jEdit.getFontProperty((String)"console.font"));
        this.addComponent(jEdit.getProperty((String)"options.console.general.font"), (Component)this.font);
        String[] encodings = MiscUtilities.getEncodings((boolean)true);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        this.encoding = new JComboBox<String>(encodings);
        this.encoding.setEditable(true);
        this.encoding.setSelectedItem(jEdit.getProperty((String)"console.encoding"));
        this.addComponent(jEdit.getProperty((String)"options.console.general.encoding"), this.encoding);
        Label limitLabel = new Label("options.console.general.charlimit");
        this.limit = new JTextField(jEdit.getProperty((String)"console.outputLimit"));
        this.addComponent(limitLabel, this.limit);
        Label limitHistoryLabel = new Label("options.console.general.historylimit");
        this.limitHistory = new JTextField(jEdit.getProperty((String)"console.historyLimit", (String)String.valueOf(HistoryModel.getDefaultMax())));
        this.addComponent(limitHistoryLabel, this.limitHistory);
        this.usejEditBgColor = new JButton("reset");
        this.usejEditBgColor.addActionListener(this);
        this.addComponent(jEdit.getProperty((String)"options.console.general.usejEditBgColor"), this.usejEditBgColor);
        this.bgColor = this.createColorButton("console.bgColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.bgColor"), this.bgColor);
        this.plainColor = this.createColorButton("console.plainColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.plainColor"), this.plainColor);
        this.caretColor = this.createColorButton("console.caretColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.caretColor"), this.caretColor);
        this.infoColor = this.createColorButton("console.infoColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.infoColor"), this.infoColor);
        this.warningColor = this.createColorButton("console.warningColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.warningColor"), this.warningColor);
        this.errorColor = this.createColorButton("console.errorColor");
        this.addComponent(jEdit.getProperty((String)"options.console.general.errorColor"), this.errorColor);
    }

    protected void _save() {
        jEdit.setBooleanProperty((String)"console.shell.info.toggle", (boolean)this.showWelcomeMessage.isSelected());
        jEdit.setFontProperty((String)"console.font", (Font)this.font.getFont());
        String limitstr = this.limit.getText();
        if (limitstr != null && limitstr.length() > 0) {
            jEdit.setProperty((String)"console.outputLimit", (String)limitstr);
        } else {
            jEdit.unsetProperty((String)"console.outputLimit");
        }
        String limithist = this.limitHistory.getText();
        if (limithist != null && limithist.length() > 0 && !String.valueOf(HistoryModel.getDefaultMax()).equals(limithist)) {
            jEdit.setProperty((String)"console.historyLimit", (String)limithist);
        } else {
            jEdit.unsetProperty((String)"console.historyLimit");
        }
        jEdit.setProperty((String)"console.encoding", (String)((String)this.encoding.getSelectedItem()));
        jEdit.setProperty((String)"console.shell.default", (String)((String)this.defaultShell.getSelectedItem()));
        jEdit.setColorProperty((String)"console.bgColor", (Color)this.bgColor.getBackground());
        jEdit.setColorProperty((String)"console.plainColor", (Color)this.plainColor.getBackground());
        jEdit.setColorProperty((String)"console.caretColor", (Color)this.caretColor.getBackground());
        jEdit.setColorProperty((String)"console.infoColor", (Color)this.infoColor.getBackground());
        jEdit.setColorProperty((String)"console.warningColor", (Color)this.warningColor.getBackground());
        jEdit.setColorProperty((String)"console.errorColor", (Color)this.errorColor.getBackground());
    }

    private JButton createColorButton(String property) {
        final JButton b = new JButton(" ");
        b.setBackground(jEdit.getColorProperty((String)property));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color c = JColorChooser.showDialog((Component)((Object)GeneralOptionPane.this), jEdit.getProperty((String)"colorChooser.title"), b.getBackground());
                if (c != null) {
                    b.setBackground(c);
                }
            }
        });
        b.setRequestFocusEnabled(false);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.usejEditBgColor) {
            return;
        }
        Color c = jEdit.getColorProperty((String)"view.bgColor");
        jEdit.setColorProperty((String)"console.bgColor", (Color)c);
        this.bgColor.setBackground(c);
    }
}

