/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorGutterIcon;
import errorlist.ErrorHighlight;
import errorlist.ErrorList;
import errorlist.ErrorOverview;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.StandardUtilities;

public class ErrorListPlugin
extends EditPlugin {
    static final String FILENAME_FILTER = "error-list.filenameFilter";
    static final String IS_INCLUSION_FILTER = "error-list.isInclusionFilter";
    static final String SHOW_UNDERLINES = "error-list.showUnderlines";
    static final String SHOW_ICONS_IN_GUTTER = "error-list.showIconsInGutter";
    private static boolean showOnError;
    private static boolean showErrorOverview;
    private static Color warningColor;
    private static Color errorColor;
    private static Pattern filter;
    private static boolean isInclusionFilter;

    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                this.initEditPane(editPaneArray[i]);
                this.addErrorOverviewIfErrors(editPaneArray[i]);
            }
        }
        this.propertiesChanged();
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                this.uninitEditPane(editPaneArray[i]);
                ErrorListPlugin.removeErrorOverview(editPaneArray[i]);
            }
            ErrorList errorList = (ErrorList)view.getDockableWindowManager().getDockable("error-list");
            if (errorList == null) continue;
            errorList.unload();
        }
    }

    @EditBus.EBHandler
    public void handleErrorSourceMessage(ErrorSourceUpdate errorSourceUpdate) {
        Object object = errorSourceUpdate.getWhat();
        if (object == ErrorSourceUpdate.ERROR_ADDED) {
            ErrorSource.Error error = errorSourceUpdate.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
            if (showOnError && jEdit.getActiveView() != null && !this.isErrorFiltered(error)) {
                this.showErrorList(jEdit.getActiveView());
            }
        } else if (object == ErrorSourceUpdate.ERROR_REMOVED) {
            ErrorSource.Error error = errorSourceUpdate.getError();
            Buffer buffer = error.getBuffer();
            if (buffer != null) {
                this.invalidateLineInAllViews(buffer, error.getLineNumber());
            }
        } else if (object == ErrorSourceUpdate.ERRORS_CLEARED || object == ErrorSourceUpdate.ERROR_SOURCE_ADDED || object == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
                EditPane[] editPaneArray = view.getEditPanes();
                for (int i = 0; i < editPaneArray.length; ++i) {
                    EditPane editPane = editPaneArray[i];
                    editPane.getTextArea().getPainter().repaint();
                    this.addErrorOverviewIfErrors(editPane);
                }
            }
            if (object == ErrorSourceUpdate.ERROR_SOURCE_ADDED && showOnError && jEdit.getActiveView() != null && this.doErrorsExist()) {
                this.showErrorList(jEdit.getActiveView());
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneMessage(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        Object object = editPaneUpdate.getWhat();
        if (object == EditPaneUpdate.CREATED) {
            this.initEditPane(editPane);
            this.addErrorOverviewIfErrors(editPane);
        } else if (object == EditPaneUpdate.DESTROYED) {
            this.uninitEditPane(editPane);
            ErrorListPlugin.removeErrorOverview(editPane);
        } else if (object == EditPaneUpdate.BUFFER_CHANGED) {
            this.addErrorOverviewIfErrors(editPane);
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(EBMessage eBMessage) {
        this.propertiesChanged();
    }

    public void showErrorOverviewIfNecessary() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                this.addErrorOverviewIfErrors(editPaneArray[i]);
            }
        }
    }

    public static void addErrorOverview(EditPane editPane) {
        ErrorOverview errorOverview = ErrorListPlugin.getErrorOverview(editPane);
        if (errorOverview != null) {
            errorOverview.repaint();
        } else {
            errorOverview = new ErrorOverview(editPane);
            JEditTextArea jEditTextArea = editPane.getTextArea();
            jEditTextArea.addLeftOfScrollBar((Component)errorOverview);
            jEditTextArea.putClientProperty(ErrorOverview.class, (Object)errorOverview);
            jEditTextArea.revalidate();
        }
    }

    public static void removeErrorOverview(EditPane editPane) {
        ErrorOverview errorOverview = ErrorListPlugin.getErrorOverview(editPane);
        if (errorOverview != null) {
            JEditTextArea jEditTextArea = editPane.getTextArea();
            jEditTextArea.removeLeftOfScrollBar((Component)errorOverview);
            jEditTextArea.revalidate();
            jEditTextArea.putClientProperty(ErrorOverview.class, null);
        }
    }

    public static ErrorOverview getErrorOverview(EditPane editPane) {
        return (ErrorOverview)editPane.getTextArea().getClientProperty(ErrorOverview.class);
    }

    static Color getErrorColor(int n) {
        return n == 1 ? warningColor : errorColor;
    }

    static Pattern getFilenameFilter() {
        return filter;
    }

    static boolean isInclusionFilter() {
        return isInclusionFilter;
    }

    static boolean showUnderlines() {
        return jEdit.getBooleanProperty((String)SHOW_UNDERLINES, (boolean)true);
    }

    static boolean showIconsInGutter() {
        return jEdit.getBooleanProperty((String)SHOW_ICONS_IN_GUTTER, (boolean)false);
    }

    private boolean isErrorFiltered(ErrorSource.Error error) {
        String string;
        boolean bl;
        if (jEdit.getBooleanProperty((String)("error-list-filtered-types." + error.getErrorType()), (boolean)false)) {
            return true;
        }
        Pattern pattern = ErrorListPlugin.getFilenameFilter();
        return pattern != null && (bl = pattern.matcher(string = error.getFilePath()).matches()) != ErrorListPlugin.isInclusionFilter();
    }

    private void propertiesChanged() {
        showOnError = jEdit.getBooleanProperty((String)"error-list.showOnError");
        showErrorOverview = jEdit.getBooleanProperty((String)"error-list.showErrorOverview");
        warningColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.warningColor"));
        errorColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"error-list.errorColor"));
        String string = jEdit.getProperty((String)FILENAME_FILTER);
        filter = string != null && string.length() > 0 ? Pattern.compile(StandardUtilities.globToRE((String)string)) : null;
        isInclusionFilter = jEdit.getBooleanProperty((String)IS_INCLUSION_FILTER, (boolean)false);
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                this.uninitEditPane(editPaneArray[i]);
                this.initEditPane(editPaneArray[i]);
                this.addErrorOverviewIfErrors(editPaneArray[i]);
            }
        }
    }

    private void initEditPane(EditPane editPane) {
        TextAreaExtension textAreaExtension;
        JEditTextArea jEditTextArea = editPane.getTextArea();
        if (ErrorListPlugin.showIconsInGutter()) {
            textAreaExtension = new ErrorGutterIcon(editPane);
            Gutter gutter = jEditTextArea.getGutter();
            gutter.addExtension(textAreaExtension);
            gutter.putClientProperty((Object)"ErrorHighlight", (Object)textAreaExtension);
        }
        if (ErrorListPlugin.showUnderlines()) {
            textAreaExtension = new ErrorHighlight(editPane);
            jEditTextArea.getPainter().addExtension(textAreaExtension);
            jEditTextArea.putClientProperty((Object)"ErrorHighlight", (Object)textAreaExtension);
        }
    }

    private void uninitEditPane(EditPane editPane) {
        Gutter gutter;
        JEditTextArea jEditTextArea = editPane.getTextArea();
        TextAreaExtension textAreaExtension = (TextAreaExtension)jEditTextArea.getClientProperty((Object)"ErrorHighlight");
        if (textAreaExtension != null) {
            jEditTextArea.getPainter().removeExtension(textAreaExtension);
            jEditTextArea.putClientProperty((Object)"ErrorHighlight", null);
        }
        if ((textAreaExtension = (TextAreaExtension)(gutter = jEditTextArea.getGutter()).getClientProperty((Object)"ErrorHighlight")) != null) {
            gutter.removeExtension(textAreaExtension);
            gutter.putClientProperty((Object)"ErrorHighlight", null);
        }
    }

    private void showErrorList(View view) {
        DockableWindowManager dockableWindowManager = view.getDockableWindowManager();
        dockableWindowManager.addDockableWindow("error-list");
    }

    private void invalidateLineInAllViews(Buffer buffer, int n) {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] editPaneArray = view.getEditPanes();
            for (int i = 0; i < editPaneArray.length; ++i) {
                EditPane editPane = editPaneArray[i];
                if (editPane.getBuffer() != buffer) continue;
                editPane.getTextArea().invalidateLine(n);
                this.addErrorOverviewIfErrors(editPane);
            }
        }
    }

    private void addErrorOverviewIfErrors(EditPane editPane) {
        Buffer buffer = editPane.getBuffer();
        if (showErrorOverview) {
            ErrorSource[] errorSourceArray = ErrorSource.getErrorSources();
            for (int i = 0; i < errorSourceArray.length; ++i) {
                ErrorSource errorSource = errorSourceArray[i];
                if (errorSource.getFileErrors(buffer.getSymlinkPath()) == null) continue;
                ErrorListPlugin.addErrorOverview(editPane);
                return;
            }
        }
        ErrorListPlugin.removeErrorOverview(editPane);
    }

    private boolean doErrorsExist() {
        for (ErrorSource errorSource : ErrorSource.getErrorSources()) {
            ErrorSource.Error[] errorArray = errorSource.getAllErrors();
            if (errorArray == null) continue;
            for (ErrorSource.Error error : errorArray) {
                if (this.isErrorFiltered(error)) continue;
                return true;
            }
        }
        return false;
    }
}

