/*
 * Decompiled with CFR 0.152.
 */
package CopyFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyFile {
    public static void copy(InputStream inStream, OutputStream outStream, int bufferSize) throws IOException {
        int nbRead;
        byte[] buffer = new byte[bufferSize];
        while ((nbRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, nbRead);
        }
    }

    public static void copyDirectory(File from, File to, boolean overwrite) throws IOException {
        if (!to.exists()) {
            to.mkdir();
        }
        File[] inDir = from.listFiles();
        int i = 0;
        while (i < inDir.length) {
            File file = inDir[i];
            CopyFile.copy(file, new File(to, file.getName()), overwrite);
            ++i;
        }
    }

    public static void copyFile(File from, File to, boolean overwrite) throws IOException {
        if (overwrite || !to.exists()) {
            FileInputStream inStream = new FileInputStream(from);
            FileOutputStream outStream = new FileOutputStream(to);
            if (from.length() > 0L) {
                CopyFile.copy(inStream, outStream, (int)Math.min(from.length(), 4096L));
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
        }
    }

    public static void copy(File from, File to, boolean overwrite) throws IOException {
        if (from.isFile()) {
            CopyFile.copyFile(from, to, overwrite);
        } else if (from.isDirectory()) {
            CopyFile.copyDirectory(from, to, overwrite);
        }
    }
}

