/*
 * Decompiled with CFR 0.152.
 */
package GLanguage;

import GFilters.GFilterElementWithSubElementWithValue;
import GFilters.GFilterTagName;
import GXMLLoader.GXMLLoader;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GLanguage {
    private String language = "";
    private int languagePosition = -1;
    private Vector<String> availableLanguages = new Vector();
    private Element completionDocumentRoot = null;
    private Element bdcDocumentRoot = null;
    private Element figaroDocumentRoot = null;

    public GLanguage() {
        GXMLLoader xl = new GXMLLoader(null);
        Element syntaxeElement = xl.loadXmlFileJDOM(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "syntaxemultilangage.xml").getRootElement();
        Iterator languageIterator = syntaxeElement.getDescendants((Filter)new GFilterTagName("language"));
        while (languageIterator.hasNext()) {
            this.availableLanguages.add(((Element)languageIterator.next()).getText());
        }
        if (this.availableLanguages.size() <= 0) {
            return;
        }
        this.language = this.availableLanguages.get(0);
        this.languagePosition = 0;
        this.completionDocumentRoot = xl.loadXmlFileJDOM(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "syntaxemultilangage.xml").getRootElement();
        this.bdcDocumentRoot = xl.loadXmlFileJDOM(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "keywordsTranslationBDCFile.xml").getRootElement();
        this.figaroDocumentRoot = xl.loadXmlFileJDOM(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "keywordsTranslationBDCFile.xml").getRootElement();
    }

    public boolean setLanguage(String newLanguage) {
        if (!this.availableLanguages.contains(newLanguage)) {
            return false;
        }
        this.language = newLanguage;
        this.languagePosition = this.availableLanguages.indexOf(this.language);
        System.err.println("LangagePosition : " + this.languagePosition);
        return true;
    }

    public String getLanguage() {
        return this.language;
    }

    public Vector<String> getAvailableLanguages() {
        Vector<String> result = new Vector<String>();
        Iterator languagesIterator = this.completionDocumentRoot.getDescendants((Filter)new GFilterTagName("language"));
        while (languagesIterator.hasNext()) {
            result.add(((Element)languagesIterator.next()).getText());
        }
        return result;
    }

    public Vector<JMenu> getCompletionMenu(String word) {
        Vector<JMenu> menuVector = new Vector<JMenu>();
        Iterator tagIterator = this.completionDocumentRoot.getDescendants((Filter)new GFilterElementWithSubElementWithValue("tag", "parent", word));
        if (!tagIterator.hasNext()) {
            return menuVector;
        }
        Vector sonsVector = new Vector(((Element)tagIterator.next()).getChildren("son"));
        for (Element son : sonsVector) {
            if (son.getChildren().size() < this.languagePosition) continue;
            menuVector.add(new JMenu(((Element)son.getChildren().get(this.languagePosition)).getChildText("menuName")));
            Vector codesVector = new Vector(((Element)son.getChildren().get(this.languagePosition)).getChildren("code"));
            for (Element code : codesVector) {
                JMenuItem codeItem = new JMenuItem(code.getText());
                codeItem.addActionListener(new copyListener(code.getText()));
                menuVector.lastElement().add(codeItem);
            }
        }
        return menuVector;
    }

    public String getBDCTranslation(String word) {
        Vector elements = new Vector(this.bdcDocumentRoot.getContent((Filter)new GFilterElementWithSubElementWithValue("word", "spell", word)));
        if (elements.size() <= 0) {
            return "";
        }
        return ((Element)((Element)elements.get(0)).getChildren().get(this.languagePosition)).getText();
    }

    public String getFigaroTranslation(String word) {
        Vector elements = new Vector(this.figaroDocumentRoot.getContent((Filter)new GFilterElementWithSubElementWithValue("word", "spell", word)));
        if (elements.size() <= 0) {
            return "";
        }
        return ((Element)((Element)elements.get(0)).getChildren().get(this.languagePosition)).getText();
    }

    public Vector<String> getAllBDCKeywords() {
        Vector<String> result = new Vector<String>();
        Vector elements = new Vector(this.bdcDocumentRoot.getContent((Filter)new GFilterTagName("word")));
        for (Element element : elements) {
            result.add(((Element)element.getChildren().get(this.languagePosition)).getText());
        }
        return result;
    }

    private class copyListener
    implements ActionListener {
        String valueToBeCopied;

        public copyListener(String value) {
            this.valueToBeCopied = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new StringSelection(String.valueOf(this.valueToBeCopied) + "\n"), null);
        }
    }
}

