/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import Factories.GWidgetFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import global.WidgetClasses;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;

public class GWidgetGridForm
extends GWidget {
    private static final long serialVersionUID = 1L;
    private int sizeX;
    private int sizeY;
    private Vector<GWidget> widgets;

    public GWidgetGridForm() {
        this.sizeY = 0;
        this.sizeX = 0;
        this.widgets = new Vector();
        this.setLayout(new GridLayout(0, 0, 5, 5));
    }

    public GWidgetGridForm(GObject p, GObjectInformation info, Vector<String> labelsName, int sx, int sy, Vector<WidgetClasses> wc, Vector<Vector<Object>> objectsArgs) {
        super(p, info);
        this.sizeX = sx;
        this.sizeY = sy;
        if (this.sizeX % 2 != 0) {
            ++this.sizeX;
        }
        this.widgets = new Vector();
        this.setLayout(new GridLayout(this.sizeY, this.sizeX, 5, 5));
        int numberOfElements = labelsName.size();
        if (labelsName.size() != wc.size()) {
            System.err.println("VisualFigaro : GWidgetGridForm : The sizes of the vectors are not all the same");
            if (labelsName.size() > wc.size()) {
                numberOfElements = wc.size();
            }
        }
        int i = 0;
        while (i < numberOfElements) {
            this.add(new JLabel(labelsName.get(i)));
            GObjectInformation widgetInformation = new GObjectInformation(this.information);
            widgetInformation.addStepToPath("" + i);
            if (objectsArgs == null) {
                this.widgets.add(GWidgetFactory.createWidget(wc.get(i), this, widgetInformation, null));
            } else {
                this.widgets.add(GWidgetFactory.createWidget(wc.get(i), this, widgetInformation, objectsArgs.get(i)));
            }
            this.add(this.widgets.get(i));
            ++i;
        }
        int remainingSpace = this.sizeX * this.sizeY - numberOfElements * 2;
        int i2 = 0;
        while (i2 < remainingSpace) {
            this.add(new JPanel());
            ++i2;
        }
        this.validate();
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case SENDTOWIDGET: {
                if (message.getArguments() == null) {
                    return;
                }
                if (message.getArguments().size() < 2) {
                    return;
                }
                if ((Integer)message.getArguments().get(0) < 0 || (Integer)message.getArguments().get(0) >= this.widgets.size()) {
                    return;
                }
                System.out.println("READY TO SEND TO WIDGET");
                this.widgets.get((Integer)message.getArguments().get(0)).translateMessage((GMessage)message.getArguments().get(1));
                System.out.println("SENT TO WIDGET");
                break;
            }
            case NOTIFYCHANGE: {
                this.parent.translateMessage(message);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWidgetGridForm : Message not handled");
            }
        }
    }

    @Override
    public boolean loadXML(Vector<Element> elements, boolean deeplyRooted) {
        if (elements.size() != this.widgets.size()) {
            return false;
        }
        int elementsSize = elements.size();
        Vector<Element> bufferVector = new Vector<Element>(1);
        int i = 0;
        while (i < elementsSize) {
            bufferVector.add(elements.get(i));
            this.widgets.get(i).loadXML(bufferVector, false);
            bufferVector.clear();
            ++i;
        }
        return true;
    }

    @Override
    public Vector<Element> saveXML() {
        int numberOfWidgets = this.widgets.size();
        Vector<Element> resultVector = new Vector<Element>(numberOfWidgets);
        int i = 0;
        while (i < numberOfWidgets) {
            if (this.widgets.get(i).saveXML() != null) {
                resultVector.add(this.widgets.get(i).saveXML().get(0));
            }
            ++i;
        }
        return resultVector;
    }
}

