/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jdom.Content;
import org.jdom.Element;

public class GWidgetManageIcon
extends GWidget {
    private static final long serialVersionUID = 1L;
    private Image image;
    private JTextField posXText;
    private JTextField posYText;
    private int posXIcon;
    private int posYIcon;

    public GWidgetManageIcon() {
        this.image = null;
        this.initialization();
    }

    public GWidgetManageIcon(GObject p, GObjectInformation info, Image img) {
        super(p, info);
        if (img != null) {
            this.image = img;
        }
        this.initialization();
    }

    private void initialization() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel gridPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.posXText = new JTextField();
        this.posXText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                this.updatePanel();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                this.updatePanel();
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                this.updatePanel();
            }

            private void updatePanel() {
                int value = 0;
                try {
                    value = Integer.parseInt(GWidgetManageIcon.this.posXText.getText());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (value > 100) {
                    value = 100;
                } else if (value < -100) {
                    value = -100;
                }
                GWidgetManageIcon.this.posXText.setText("" + value);
                GWidgetManageIcon.this.posXIcon = value;
                GWidgetManageIcon.this.repaint();
            }
        });
        gridPanel.add(this.posXText);
        this.posYText = new JTextField();
        this.posYText.setPreferredSize(new Dimension(50, 20));
        this.posYText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                this.updatePanel();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                this.updatePanel();
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                this.updatePanel();
            }

            private void updatePanel() {
                int value = 0;
                try {
                    value = Integer.parseInt(GWidgetManageIcon.this.posYText.getText());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (value > 100) {
                    value = 100;
                } else if (value < -100) {
                    value = -100;
                }
                GWidgetManageIcon.this.posYText.setText("" + value);
                GWidgetManageIcon.this.posYIcon = value;
                GWidgetManageIcon.this.repaint();
            }
        });
        gridPanel.add(this.posYText);
        rightPanel.add((Component)gridPanel, "East");
        constraints.gridx = 1;
        this.add((Component)rightPanel, constraints);
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        this.setBorder(BorderFactory.createTitledBorder(blackLine, "Position", 1, 0, null));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        Dimension imageDimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        Point origin = new Point(this.getWidth() / 4 - imageDimension.width / 2, (this.getHeight() - imageDimension.height) / 2 + imageDimension.height);
        if (g != null) {
            g.setColor(Color.BLACK);
            g.drawImage(this.image, origin.x, origin.y - imageDimension.height, imageDimension.width, imageDimension.height, this);
            g.drawRect(origin.x, origin.y - imageDimension.height, imageDimension.width, imageDimension.height);
            System.err.println("X : " + this.posXIcon);
            int realCursorPosX = (int)((double)(this.posXIcon + 100) / 200.0 * (double)imageDimension.width);
            int realCursorPosY = (int)((double)(this.posYIcon + 100) / 200.0 * (double)imageDimension.height);
            g.fillRect(origin.x + realCursorPosX - 2, origin.y - realCursorPosY - 2, 4, 4);
        } else {
            System.err.println("VisualFigaro : GWidgetLoadIcon : Graphics Error");
        }
    }

    @Override
    public void translateMessage(GMessage message) {
    }

    @Override
    public boolean loadXML(Vector<Element> e, boolean deeplyRooted) {
        if (e == null) {
            return false;
        }
        if (e.size() <= 0) {
            return false;
        }
        Element positionElement = e.get(0);
        if (positionElement != null) {
            this.posXText.setText(positionElement.getChildText(this.information.getLanguage().getBDCTranslation("X")));
            if (this.posXText.getText().equals("")) {
                this.posXText.setText("0");
            }
            this.posXIcon = Integer.parseInt(this.posXText.getText());
            this.posYText.setText(positionElement.getChildText(this.information.getLanguage().getBDCTranslation("Y")));
            if (this.posYText.getText().equals("")) {
                this.posYText.setText("0");
            }
            this.posYIcon = Integer.parseInt(this.posYText.getText());
        }
        this.repaint();
        return true;
    }

    @Override
    public Vector<Element> saveXML() {
        Vector<Element> resultVector = new Vector<Element>();
        Element result = new Element(this.information.getLanguage().getBDCTranslation("POSITION"));
        Element xElement = new Element(this.information.getLanguage().getBDCTranslation("X"));
        if (this.posXText.getText().equals("")) {
            xElement.setText("0");
        } else {
            xElement.setText(this.posXText.getText());
        }
        result.addContent((Content)xElement);
        Element yElement = new Element(this.information.getLanguage().getBDCTranslation("Y"));
        if (this.posYText.getText().equals("")) {
            yElement.setText("0");
        } else {
            yElement.setText(this.posYText.getText());
        }
        result.addContent((Content)yElement);
        resultVector.add(result);
        return resultVector;
    }
}

