/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GIcon.GIcon;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetExpression;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetLoadIcon;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import GWindow.GWindowNameAsker;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import global.Messages;
import global.WidgetClasses;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdom.Element;

public class GWindowDefaultVarNode
extends GWindow {
    private static final long serialVersionUID = 1L;
    private GWidgetOKCancel okCancelWidget;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private GWidgetLoadIcon loadIcon;
    private JPanel secondPanel;
    private GWidgetExpression expressionWidget;
    private GWidgetGridForm colorPositionGridForm;

    @Deprecated
    public GWindowDefaultVarNode(GObject p, GObjectInformation info) {
        super(p, info);
        this.initialization();
    }

    public GWindowDefaultVarNode(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.initialization();
    }

    private void initialization() {
        this.tabsInitialization();
        this.framePanel.add((Component)this.tabs, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Default Graphic Variant");
        this.setSize(550, 300);
    }

    private void tabsInitialization() {
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("Icon", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Text", this.secondPanel);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        Vector<String> labels = new Vector<String>();
        labels.add("Main Color :");
        labels.add("Thickness :");
        labels.add("Background :");
        labels.add("File :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COLORCHOOSER);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.COLORCHOOSER);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 2, widgetClasses, objectArgs);
        this.firstPanel.add((Component)this.generalCharacteristicsGridForm, "North");
        Image image = this.loadIcon("./VisualFigaro/test.ico");
        this.loadIcon = new GWidgetLoadIcon(this, this.information, image);
        this.firstPanel.add((Component)this.loadIcon, "South");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        Vector<String> labels = new Vector<String>();
        labels.add("FORMAT");
        labels.add("");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.CONTROLEDLISTADDDEL);
        this.expressionWidget = new GWidgetExpression(this, this.information);
        this.secondPanel.add((Component)this.expressionWidget, "Center");
        labels = new Vector();
        labels.add("Text Color : ");
        labels.add("Text Position : ");
        widgetClasses = new Vector();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        this.colorPositionGridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, null);
        this.secondPanel.add((Component)this.colorPositionGridForm, "South");
    }

    private Image loadIcon(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        ICOFile icon = null;
        try {
            icon = new ICOFile(file.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("VisualFigaro : GWindowDefaultVarNode : Error while reading the icon file : " + file + " ." + e);
        }
        BitmapDescriptor bmpdesc = icon.getDescriptor(0);
        Image image = bmpdesc.getImageRGB();
        return image;
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{-1, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case ICONCHOOSED: {
                GIcon messageIcons = null;
                try {
                    messageIcons = (GIcon)message.getArguments().get(0);
                }
                catch (Exception ex) {
                    System.err.println("Visual Figaro : GWindowDefaultVarNode : An exception occured during the processing of message : " + message + " : " + ex);
                    return;
                }
                if (messageIcons.isCompletePath()) {
                    GWindowNameAsker nameAskerWindow = new GWindowNameAsker(this, this.information, messageIcons.getPath());
                    nameAskerWindow.setModal(true);
                    nameAskerWindow.setAlwaysOnTop(true);
                    nameAskerWindow.setVisible(true);
                    File originIco = new File(messageIcons.getPath());
                    File originSym = new File(String.valueOf(messageIcons.getPath().substring(0, messageIcons.getPath().lastIndexOf("."))) + ".sym");
                    File destinationIco = new File(String.valueOf(this.information.getKnowledgeBasePath()) + "\\icons\\" + nameAskerWindow.getIconName() + ".ico");
                    File destinationSym = new File(String.valueOf(this.information.getKnowledgeBasePath()) + "\\icons\\" + nameAskerWindow.getIconName() + ".sym");
                    this.copyFile(originIco, destinationIco);
                    this.copyFile(originSym, destinationSym);
                    this.generalCharacteristicsGridForm.translateMessage(new GMessage(this.information, Messages.SENDTOWIDGET, new Object[]{3, new GMessage(this.information, Messages.REPLACEDEFAULTVALUES, new Object[]{nameAskerWindow.getIconName()})}));
                    break;
                }
                this.generalCharacteristicsGridForm.translateMessage(new GMessage(this.information, Messages.SENDTOWIDGET, new Object[]{3, new GMessage(this.information, Messages.REPLACEDEFAULTVALUES, new Object[]{messageIcons.getPath()})}));
                break;
            }
            default: {
                System.err.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    private boolean copyFile(File origin, File destination) {
        try {
            int readCharacter;
            FileReader reader = new FileReader(origin);
            FileWriter writer = new FileWriter(destination);
            do {
                if ((readCharacter = reader.read()) == -1) continue;
                writer.write(readCharacter);
            } while (readCharacter != -1);
            reader.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be copied : " + e);
        }
        catch (IOException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be copied : " + e);
        }
        return true;
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE_DEFAUT"));
        Element element = new Element(this.information.getLanguage().getBDCTranslation("ICONE"));
        GXMLElementFactory.saveElements(element, this.generalCharacteristicsGridForm.saveXML());
        GXMLElementFactory.saveElement(this.root, element);
        element = new Element(this.information.getLanguage().getBDCTranslation("TEXTE"));
        Element bufferElement = new Element(this.information.getLanguage().getBDCTranslation("EXPRESSION"));
        GXMLElementFactory.saveElements(bufferElement, this.expressionWidget.saveXML());
        GXMLElementFactory.saveElement(element, bufferElement);
        GXMLElementFactory.saveElements(element, this.colorPositionGridForm.saveXML());
        GXMLElementFactory.saveElement(this.root, element);
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        if (e == null) {
            return;
        }
        Vector<Element> iconFields = new Vector<Element>();
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_PPLAN")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("EPAISSEUR_TRAIT")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_FOND")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("FICHIER")).get(0));
        this.generalCharacteristicsGridForm.loadXML(iconFields, false);
        Vector<Element> expressionFields = new Vector<Element>();
        expressionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("FORMAT")).get(0));
        expressionFields.addAll(GXMLElementFactory.refactorElements(new Vector<Element>(e.getChildren()), this.information.getLanguage().getBDCTranslation("PARAMETRES")));
        this.expressionWidget.loadXML(expressionFields, false);
        Vector<Element> colorPositionFields = new Vector<Element>();
        colorPositionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_TEXTE")).get(0));
        colorPositionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("POSITION_TEXTE")).get(0));
        this.colorPositionGridForm.loadXML(colorPositionFields, false);
    }
}

