/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GKnowledgeBase.GKnowledgeBase;
import GMessage.GMessage;
import GModel.GModel;
import GModel.GModelDataOperation;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.NameRetrieverClasses;
import global.WindowClasses;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GWindowFaultTree
extends GWindow {
    private static final long serialVersionUID = 1L;
    private VisualFigaro vfParent;
    private GModel currentModel;
    private GKnowledgeBase knowledgeBase;
    private JPanel framePanel;
    private JPanel logoPanel;
    private JPanel fieldsPanel;
    private JTextField nameTextField;
    private JButton openExplorerButton;
    private GWidgetControledList groupsList;
    private JComboBox coherenBx;
    private JComboBox simplBx;
    private JComboBox unloopBx;
    private JTextField objectNameTxt;
    private JTextField variableNameTxt;
    private JTextField treeNameTxt;
    private JTextField maxSonsGateTxt;
    protected Element root2;
    private GWidgetOKCancel okCancelWidget;

    public GWindowFaultTree(VisualFigaro vf, GObject p, GObjectInformation info, GModel model) {
        super(p, info);
        this.vfParent = vf;
        this.currentModel = model;
        this.knowledgeBase = model.getKnowledgeBase();
        this.framePanel = new JPanel(new BorderLayout());
        this.initializeLogoPart();
        this.framePanel.add((Component)this.logoPanel, "North");
        this.initializeFieldPart();
        this.framePanel.add((Component)this.fieldsPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.setSize(600, 500);
        this.setResizable(false);
        this.setTitle("Generate Fault Tree");
    }

    private void initializeLogoPart() {
        this.logoPanel = new JPanel(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "logoEDF.gif");
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(imageIcon);
        this.logoPanel.add((Component)iconLabel, "West");
        JLabel titleLabel = new JLabel("Generate Fault Tree  ");
        this.logoPanel.add((Component)titleLabel, "East");
    }

    private void initializeFieldPart() {
        this.fieldsPanel = new JPanel(new BorderLayout());
        JPanel idPanel = new JPanel(new GridLayout(0, 2));
        String kBName = this.knowledgeBase.getKnowledgeBaseName();
        int pos = kBName.lastIndexOf(92);
        kBName = kBName.substring(pos + 1);
        String modelName = this.currentModel.getModelName();
        pos = modelName.lastIndexOf(92);
        modelName = modelName.substring(pos + 1);
        idPanel.add(new JLabel("Knowledge Base : "));
        idPanel.add(new JLabel(kBName));
        idPanel.add(new JLabel("Model : "));
        idPanel.add(new JLabel(modelName));
        idPanel.add(new JLabel("Fault Tree File : "));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(this.currentModel.getFaultTreeSettings().getFileName());
        idPanel.add(this.nameTextField);
        idPanel.add(new JLabel(""));
        this.openExplorerButton = new JButton("Explore");
        this.openExplorerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowFaultTree.this.showFileChooser();
            }
        });
        idPanel.add(this.openExplorerButton);
        this.fieldsPanel.add((Component)idPanel, "North");
        JPanel centerPanel = new JPanel(new GridLayout(1, 2));
        JPanel centerLeftPanel = new JPanel(new GridLayout(2, 1));
        JPanel topEvent = new JPanel(new GridLayout(2, 2));
        TitledBorder border = BorderFactory.createTitledBorder("Top Event");
        topEvent.setBorder(border);
        topEvent.add(new JLabel("Object : "));
        this.objectNameTxt = new JTextField();
        this.objectNameTxt.setText(this.currentModel.getFaultTreeSettings().getObject());
        topEvent.add(this.objectNameTxt);
        topEvent.add(new JLabel("Variable : "));
        this.variableNameTxt = new JTextField();
        this.variableNameTxt.setText(this.currentModel.getFaultTreeSettings().getVariable());
        topEvent.add(this.variableNameTxt);
        centerLeftPanel.add(topEvent);
        centerPanel.add(centerLeftPanel);
        this.groupsList = this.currentModel.getFaultTreeSettings().getGroupsList() == null ? new GWidgetControledList(this, this.information, "Groups list", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.GROUPEREGLESSANSNOM, null) : this.currentModel.getFaultTreeSettings().getGroupsList();
        centerPanel.add(this.groupsList);
        this.fieldsPanel.add((Component)centerPanel, "Center");
        JPanel southPanel = new JPanel(new GridLayout(0, 2));
        JPanel leftPanel = new JPanel(new GridLayout(0, 2));
        leftPanel.add(new JLabel("Simplification : "));
        this.simplBx = new JComboBox();
        this.simplBx.addItem("Complete");
        this.simplBx.addItem("Partial");
        this.simplBx.addItem("None");
        this.simplBx.setSelectedItem(this.currentModel.getFaultTreeSettings().getSimplification());
        leftPanel.add(this.simplBx);
        leftPanel.add(new JLabel("Unloop : "));
        this.unloopBx = new JComboBox();
        this.unloopBx.addItem("With");
        this.unloopBx.addItem("Without");
        this.unloopBx.setSelectedItem(this.currentModel.getFaultTreeSettings().getUnloop());
        leftPanel.add(this.unloopBx);
        leftPanel.add(new JLabel("Negation suppression : "));
        this.coherenBx = new JComboBox();
        this.coherenBx.addItem("Complete");
        this.coherenBx.addItem("Except leafs");
        this.coherenBx.addItem("None");
        this.coherenBx.setSelectedItem(this.currentModel.getFaultTreeSettings().getCoherency());
        leftPanel.add(this.coherenBx);
        southPanel.add(leftPanel);
        JPanel rightPanel = new JPanel(new GridLayout(0, 2));
        rightPanel.add(new JLabel("Tree Name : "));
        this.treeNameTxt = new JTextField();
        this.treeNameTxt.setText(this.currentModel.getFaultTreeSettings().getTreeName());
        rightPanel.add(this.treeNameTxt);
        rightPanel.add(new JLabel("Max Sons Gate : "));
        this.maxSonsGateTxt = new JTextField();
        this.maxSonsGateTxt.setText(this.currentModel.getFaultTreeSettings().getMaxSonsGate());
        rightPanel.add(this.maxSonsGateTxt);
        southPanel.add(rightPanel);
        this.fieldsPanel.add((Component)southPanel, "South");
    }

    private void showFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        class MyFilter
        extends FileFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String filename = file.getName();
                return filename.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "*.xml";
            }
        }
        fileChooser.addChoosableFileFilter(new MyFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        if (file.toString().endsWith(".xml")) {
            this.nameTextField.setText(file.toString());
        } else {
            this.nameTextField.setText(String.valueOf(file.toString()) + ".xml");
        }
        fileChooser.setVisible(false);
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                if (!this.maxSonsGateTxt.getText().isEmpty() && this.maxSonsGateTxt.getText().matches("^\\p{Digit}+$")) {
                    if (!this.objectNameTxt.getText().isEmpty()) {
                        if (!this.variableNameTxt.getText().isEmpty()) {
                            this.saveXmlToFile();
                            this.saveSettings();
                            this.dispose();
                            this.vfParent.generateFT(this.nameTextField.getText());
                            break;
                        }
                        JOptionPane.showMessageDialog(this, "Please specified a test variable name");
                        break;
                    }
                    JOptionPane.showMessageDialog(this, "Please specified an object name");
                    break;
                }
                JOptionPane.showMessageDialog(this, "Max Sons Gate value is not an integer");
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowFaultTree : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        String simplification = this.simplBx.getSelectedItem().toString().equals("Complete") ? "TOTALE" : (this.simplBx.getSelectedItem().toString().equals("Partial") ? "PARTIELLE" : "AUCUNE");
        String coherency = this.coherenBx.getSelectedItem().toString().equals("Complete") ? "TOTALE" : (this.coherenBx.getSelectedItem().toString().equals("Except leafs") ? "PARTIELLE" : "AUCUNE");
        String unloop = this.unloopBx.getSelectedItem().toString().equals("With") ? "VRAI" : "FAUX";
        if (this.nameTextField.getText().isEmpty()) {
            if (this.vfParent.isOSWindows()) {
                this.nameTextField.setText(String.valueOf(System.getenv("TMP")) + "\\faulttree_temp.xml");
            } else {
                this.nameTextField.setText(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/faulttree_temp.xml");
            }
        }
        this.root = new Element("REQUESTS");
        Element loadBDCFI = new Element("LOAD_BDC_FI");
        loadBDCFI.addContent((Content)new Element("FILE_FI").setText(this.knowledgeBase.getKnowledgeBaseName()));
        this.root.addContent((Content)loadBDCFI);
        Element loadBDFFI = new Element("LOAD_BDF_FI");
        loadBDFFI.addContent((Content)new Element("FILE").setText(this.currentModel.getModelName()));
        this.root.addContent((Content)loadBDFFI);
        Element treatment = new Element("RUN_TREATMENT");
        treatment.addContent((Content)new Element("TREATMENT").setText("GENERATE_TREE"));
        treatment.addContent((Content)new Element("FILE").setText(this.nameTextField.getText()));
        treatment.addContent((Content)new Element("FILE_MACRO").setText("fiab_ADD.h"));
        treatment.addContent((Content)new Element("RESOLVE_CONST").setText("TRUE"));
        treatment.addContent((Content)new Element("RESOLVE_ATTR").setText("TRUE"));
        treatment.addContent((Content)new Element("INST_RULE").setText("TRUE"));
        treatment.addContent((Content)new Element("FILE_TREE_OPTIONS").setText(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_params.xml"));
        this.root.addContent((Content)treatment);
        this.root2 = new Element("GEN_TREE_OPTIONS");
        this.root2.addContent((Content)new Element("FORMAT").setText("KB3"));
        this.root2.addContent((Content)new Element("SIMPLIFICATION").setText(simplification));
        this.root2.addContent((Content)new Element("COHERENCY").setText(coherency));
        this.root2.addContent((Content)new Element("UNLOOP").setText(unloop));
        this.root2.addContent((Content)new Element("TREE_NAME").setText(this.treeNameTxt.getText()));
        this.root2.addContent((Content)new Element("PREFIX").setText("__ARBRE__"));
        Element testVariable = new Element("TEST_VARIABLE");
        testVariable.addContent((Content)new Element("OBJECT").setText(this.objectNameTxt.getText()));
        testVariable.addContent((Content)new Element("VARIABLE").setText(this.variableNameTxt.getText()));
        this.root2.addContent((Content)testVariable);
        this.root2.addContent((Content)new Element("MAX_SONS_GATE").setText(this.maxSonsGateTxt.getText()));
        if (this.groupsList.GetNumberOfElement() > 0) {
            Element listgroups = new Element("LIST_GROUPS");
            int i = 0;
            while (i < this.groupsList.GetNumberOfElement()) {
                listgroups.addContent((Content)new Element("GROUP").setText(this.groupsList.getList().listGetString(i)));
                ++i;
            }
            this.root2.addContent((Content)listgroups);
        }
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
    }

    public void saveXmlToFile() {
        this.fillDocument();
        String fileName1 = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml";
        String fileName2 = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_params.xml";
        try {
            FileOutputStream fichier = new FileOutputStream(fileName1);
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            sortie.output(new Document(this.root), (OutputStream)fichier);
            fichier.close();
            FileOutputStream fichier2 = new FileOutputStream(fileName2);
            XMLOutputter sortie2 = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            sortie2.output(new Document(this.root2), (OutputStream)fichier2);
            fichier2.close();
        }
        catch (IOException ioe) {
            System.out.println("VisualFigaro : GWindowFaultTree : Cannot save xml to file : " + ioe);
            JOptionPane.showMessageDialog(this, "VisualFigaro : GWindowFaultTree : Cannot save xml to file : " + ioe);
        }
    }

    public void saveSettings() {
        String filename = this.nameTextField.getText().endsWith("faulttree_temp.xml") ? "" : this.nameTextField.getText();
        this.currentModel.setFaultTreeSettings(new GModelDataOperation(this.groupsList, filename, this.simplBx.getSelectedItem().toString(), this.unloopBx.getSelectedItem().toString(), this.coherenBx.getSelectedItem().toString(), this.treeNameTxt.getText(), this.maxSonsGateTxt.getText(), this.objectNameTxt.getText(), this.variableNameTxt.getText()));
    }
}

