/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GKnowledgeBase.GKnowledgeBase;
import GMessage.GMessage;
import GModel.GModel;
import GModel.GModelDataOperation;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.NameRetrieverClasses;
import global.WindowClasses;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GWindowGenerateFig0
extends GWindow {
    private static final long serialVersionUID = 1L;
    private VisualFigaro vfParent;
    private GModel currentModel;
    private GKnowledgeBase knowledgeBase;
    private JPanel framePanel;
    private JPanel logoPanel;
    private JPanel fieldsPanel;
    private JTextField nameTextField;
    private JCheckBox resolveConstChBx;
    private JCheckBox resolveAttrChBx;
    private JCheckBox instanciateRuleChBx;
    private JButton openExplorerButton;
    private GWidgetControledList groupsList;
    private int postTreatment;
    private GWidgetOKCancel okCancelWidget;

    public GWindowGenerateFig0(VisualFigaro vf, GObject p, GObjectInformation info, GModel model, int pTreatment) {
        super(p, info);
        this.vfParent = vf;
        this.currentModel = model;
        this.knowledgeBase = model.getKnowledgeBase();
        this.postTreatment = pTreatment;
        this.framePanel = new JPanel(new BorderLayout());
        this.initializeLogoPart();
        this.framePanel.add((Component)this.logoPanel, "North");
        this.initializeFieldPart();
        this.framePanel.add((Component)this.fieldsPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.setSize(400, 450);
        this.setResizable(false);
        this.setTitle("Generate Figaro 0");
    }

    private void initializeLogoPart() {
        this.logoPanel = new JPanel(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "logoEDF.gif");
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(imageIcon);
        this.logoPanel.add((Component)iconLabel, "West");
        JLabel titleLabel = new JLabel("Generate Figaro 0  ");
        this.logoPanel.add((Component)titleLabel, "East");
    }

    private void initializeFieldPart() {
        this.fieldsPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new GridLayout(0, 2));
        String kBName = this.knowledgeBase.getKnowledgeBaseName();
        int pos = kBName.lastIndexOf(92);
        kBName = kBName.substring(pos + 1);
        String modelName = this.currentModel.getModelName();
        pos = modelName.lastIndexOf(92);
        modelName = modelName.substring(pos + 1);
        northPanel.add(new JLabel("Knowledge Base : "));
        northPanel.add(new JLabel(kBName));
        northPanel.add(new JLabel("Model : "));
        northPanel.add(new JLabel(modelName));
        northPanel.add(new JLabel("Figaro 0 File : "));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(this.currentModel.getFigaro0Settings().getFileName());
        northPanel.add(this.nameTextField);
        this.fieldsPanel.add((Component)northPanel, "North");
        JPanel explorePanel = new JPanel(new BorderLayout());
        JPanel chBxPanel = new JPanel(new GridLayout(3, 0));
        this.resolveConstChBx = new JCheckBox("Resolve Constants", this.currentModel.getFigaro0Settings().getResolveConstants());
        chBxPanel.add(this.resolveConstChBx);
        this.resolveAttrChBx = new JCheckBox("Resolve Attributes", this.currentModel.getFigaro0Settings().getResolveAttributs());
        chBxPanel.add(this.resolveAttrChBx);
        this.instanciateRuleChBx = new JCheckBox("Instanciate Rules", this.currentModel.getFigaro0Settings().getInstanciateRules());
        chBxPanel.add(this.instanciateRuleChBx);
        explorePanel.add((Component)chBxPanel, "West");
        this.openExplorerButton = new JButton("Explore");
        this.openExplorerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowGenerateFig0.this.showFileChooser();
            }
        });
        explorePanel.add((Component)this.openExplorerButton, "East");
        this.fieldsPanel.add((Component)explorePanel, "Center");
        this.groupsList = this.currentModel.getFigaro0Settings().getGroupsList() == null ? new GWidgetControledList(this, this.information, "Groups list", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.GROUPEREGLESSANSNOM, null) : this.currentModel.getFigaro0Settings().getGroupsList();
        this.fieldsPanel.add((Component)this.groupsList, "South");
    }

    private void showFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        class MyFilter
        extends FileFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String filename = file.getName();
                return filename.endsWith(".fi");
            }

            @Override
            public String getDescription() {
                return "*.fi";
            }
        }
        fileChooser.addChoosableFileFilter(new MyFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        if (file.toString().endsWith(".fi")) {
            this.nameTextField.setText(file.toString());
        } else {
            this.nameTextField.setText(String.valueOf(file.toString()) + ".fi");
        }
        fileChooser.setVisible(false);
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.saveXmlToFile();
                this.saveSettings();
                this.dispose();
                this.vfParent.cmdFig0(this.nameTextField.getText(), this.postTreatment);
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowGenerateFig0 : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        String resolve_Const = this.resolveConstChBx.isSelected() ? "VRAI" : "FAUX";
        String resolve_Attr = this.resolveAttrChBx.isSelected() ? "VRAI" : "FAUX";
        String inst_Rule = this.instanciateRuleChBx.isSelected() ? "VRAI" : "FAUX";
        if (this.nameTextField.getText().isEmpty()) {
            if (this.vfParent.isOSWindows()) {
                this.nameTextField.setText(String.valueOf(System.getenv("TMP")) + "\\fig0_temp.fi");
            } else {
                this.nameTextField.setText(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/fig0_temp.fi");
            }
        }
        this.root = new Element("REQUESTS");
        Element loadBDCFI = new Element("LOAD_BDC_FI");
        loadBDCFI.addContent((Content)new Element("FILE_FI").setText(this.knowledgeBase.getKnowledgeBaseName()));
        this.root.addContent((Content)loadBDCFI);
        Element loadBDFFI = new Element("LOAD_BDF_FI");
        loadBDFFI.addContent((Content)new Element("FILE").setText(this.currentModel.getModelName()));
        this.root.addContent((Content)loadBDFFI);
        Element treatment = new Element("RUN_TREATMENT");
        treatment.addContent((Content)new Element("TREATMENT").setText("GENERER_FIG0"));
        treatment.addContent((Content)new Element("FILE").setText(this.nameTextField.getText()));
        treatment.addContent((Content)new Element("FILE_MACRO").setText("fiabsimu.h"));
        treatment.addContent((Content)new Element("RESOLVE_CONST").setText(resolve_Const));
        treatment.addContent((Content)new Element("RESOLVE_ATTR").setText(resolve_Attr));
        treatment.addContent((Content)new Element("INST_RULE").setText(inst_Rule));
        if (this.groupsList.GetNumberOfElement() > 0) {
            Element listgroups = new Element("LIST_GROUPS");
            int i = 0;
            while (i < this.groupsList.GetNumberOfElement()) {
                listgroups.addContent((Content)new Element("GROUP").setText(this.groupsList.getList().listGetString(i)));
                ++i;
            }
            treatment.addContent((Content)listgroups);
        }
        this.root.addContent((Content)treatment);
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
    }

    public void saveXmlToFile() {
        this.fillDocument();
        String fileName = String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/figp_commands.xml";
        try {
            FileOutputStream fichier = new FileOutputStream(fileName);
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            sortie.output(new Document(this.root), (OutputStream)fichier);
            fichier.close();
        }
        catch (IOException ioe) {
            System.out.println("VisualFigaro : GWindowGenerateFig0 : Cannot save xml to file : " + ioe);
            JOptionPane.showMessageDialog(this, "VisualFigaro : GWindowGenerateFig0 : Cannot save xml to file : " + ioe);
        }
    }

    public void saveSettings() {
        String filename = this.nameTextField.getText().endsWith("fig0_temp.fi") ? "" : this.nameTextField.getText();
        this.currentModel.setFigaro0Settings(new GModelDataOperation(this.resolveConstChBx.isSelected(), this.resolveAttrChBx.isSelected(), this.instanciateRuleChBx.isSelected(), this.groupsList, filename));
    }
}

