/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetEditLinkPortStartEnd;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetOKCancel;
import GWidget.GWidgetTextArea;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.jdom.Element;

public class GWindowLink
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private GWidgetTextArea descriptionTextArea;
    private GWidgetControledList menuItemNamesList;
    private GWidgetControledList variantesGraphiquesList;
    private JPanel secondPanel;
    private GWidgetEditLinkPortStartEnd portStart;
    private GWidgetEditLinkPortStartEnd portEnd;
    private GWidgetOKCancel okCancelWidget;
    private int position;
    private String nodeName;

    @Deprecated
    public GWindowLink(GObject p, GObjectInformation info) {
        super(p, info);
        this.initialization();
    }

    public GWindowLink(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.nodeName = info.getTypeConcerned();
        this.initialization();
    }

    private void initialization() {
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("General", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Ports", this.secondPanel);
        this.framePanel.add((Component)this.tabs, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Link : " + this.nodeName);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        this.initializeFirstPanelFields();
        this.initializeFirstPanelBorderedWidgets();
    }

    private void initializeFirstPanelFields() {
        Vector<String> labels = new Vector<String>();
        labels.add("Abbreviation :");
        labels.add("Presence Palette :");
        labels.add("Default Variant :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.EDITDEFAULTVAR);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        Vector<Object> values = new Vector<Object>();
        values.add("TRUE");
        values.add("FALSE");
        objectArgs.add(values);
        values = new Vector();
        values.add("Edit Default GV");
        values.add(false);
        objectArgs.add(values);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 2, widgetClasses, objectArgs);
        this.firstPanel.add((Component)this.generalCharacteristicsGridForm, "North");
    }

    private void initializeFirstPanelBorderedWidgets() {
        JPanel bufferPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.descriptionTextArea = new GWidgetTextArea(this, this.information, "Description");
        bufferPanel.add(this.descriptionTextArea);
        this.menuItemNamesList = new GWidgetControledList(this, this.information, "Menu Items", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.MENU, null);
        bufferPanel.add(this.menuItemNamesList);
        this.variantesGraphiquesList = new GWidgetControledList(this, this.information, "Graphic Variants", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.VARLINK, null);
        bufferPanel.add(this.variantesGraphiquesList);
        this.firstPanel.add((Component)bufferPanel, "Center");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        JPanel dummyPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.portStart = new GWidgetEditLinkPortStartEnd(this, this.information, "Edit Starting Port", true);
        dummyPanel.add((Component)this.portStart, "North");
        this.portEnd = new GWidgetEditLinkPortStartEnd(this, this.information, "Edit Ending Port", false);
        dummyPanel.add((Component)this.portEnd, "South");
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        dummyPanel.setBorder(BorderFactory.createTitledBorder(blackLine, "Ports", 1, 0, null));
        this.secondPanel.add((Component)dummyPanel, "North");
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.NODEMODIFICATION, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("TYPE"));
        Element name = new Element(this.information.getLanguage().getBDCTranslation("NOM"));
        name.setText(this.nodeName);
        GXMLElementFactory.saveElement(this.root, name);
        Vector<Element> generalCharacteristicsGridFormVector = new Vector<Element>(this.generalCharacteristicsGridForm.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(1));
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(0));
        GXMLElementFactory.saveElements(this.root, this.descriptionTextArea.saveXML());
        GXMLElementFactory.saveElements(this.root, this.menuItemNamesList.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(2));
        GXMLElementFactory.saveElements(this.root, this.variantesGraphiquesList.saveXML());
        Element element = new Element(this.information.getLanguage().getBDCTranslation("LIEN"));
        GXMLElementFactory.saveElements(element, this.variantesGraphiquesList.saveXML());
        GXMLElementFactory.saveElements(element, this.portStart.saveXML());
        GXMLElementFactory.saveElements(element, this.portEnd.saveXML());
        GXMLElementFactory.saveElement(this.root, element);
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        Vector<Element> fieldsLoad = new Vector<Element>();
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("ABREVIATION")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("PRESENCE_PALETTE")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE_DEFAUT")).get(0));
        this.generalCharacteristicsGridForm.loadXML(fieldsLoad, false);
        this.descriptionTextArea.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("DESCRIPTION")), false);
        Vector<Element> elem = new Vector<Element>();
        elem.add(e);
        this.menuItemNamesList.loadXML(GXMLElementFactory.refactorElements(elem, this.information.getLanguage().getBDCTranslation("FAMILLE_TYPE_PALETTE")), false);
        this.variantesGraphiquesList.loadXML(GXMLElementFactory.refactorElements(elem, this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE")), false);
        this.portStart.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("POINT_DEPART")), false);
        this.portEnd.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("POINT_ARRIVEE")), false);
    }
}

