/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import org.jdom.Element;

public class GWindowLinkPort
extends GWindow {
    private static final long serialVersionUID = 1L;
    private GWidgetOKCancel okCancelWidget;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JPanel comboPanel;
    private GWidgetGridForm comboGridForm;
    private GWidgetControledList interfacesLinkFilledByStartingNodeControledList;
    private GWidgetControledList interfacesLinkFilledByEndingNodeControledList;
    private GWidgetControledList interfacesEndingNodeFilledByLinkControledList;
    private GWidgetControledList interfacesEndingNodeFilledByStartingNodeControledList;
    private GWidgetControledList interfacesStartingNodeFilledByLinkControledList;
    private GWidgetControledList interfacesStartingNodeFilledByEndingNodeControledList;
    private int position;
    private boolean isStart;
    private int numberOfItems;
    private Vector<Object> interfaces = new Vector();
    private Vector<Vector<Object>> parameters = new Vector();
    private Vector<String> labels = new Vector();
    private Vector<WidgetClasses> widgetClasses = new Vector();

    @Deprecated
    public GWindowLinkPort(GObject p, GObjectInformation info) {
        super(p, info);
        this.position = -1;
        this.isStart = true;
        this.numberOfItems = 0;
        this.initialization();
    }

    public GWindowLinkPort(GObject p, GObjectInformation info, int pos, boolean isStart) {
        super(p, info);
        this.position = pos;
        this.isStart = isStart;
        this.numberOfItems = 0;
        this.initialization();
    }

    private void initialization() {
        this.initializeComboPanel();
        this.framePanel.add((Component)this.comboPanel, "North");
        this.initializeListPanel();
        this.framePanel.add((Component)this.cardPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        if (this.isStart) {
            this.setTitle("Start Port Window");
        } else {
            this.setTitle("End Port Window");
        }
        this.loadXml(null);
        this.setSize(700, 300);
    }

    public void initializeComboPanel() {
        this.comboPanel = new JPanel(new BorderLayout());
        this.labels.add("Name : ");
        this.labels.add("Class : ");
        this.labels.add("Interface : ");
        this.widgetClasses.add(WidgetClasses.TEXTFIELD);
        this.widgetClasses.add(WidgetClasses.COMBO);
        this.widgetClasses.add(WidgetClasses.COMBO);
        this.parameters.add(null);
        Vector<String> types = new Vector<String>();
        boolean figaro = false;
        for (String s : xmlLoader.findNodes()) {
            types.add(s);
            if (!s.equals("FIGARO")) continue;
            figaro = true;
        }
        if (!figaro) {
            types.add("FIGARO");
        }
        this.parameters.add(types);
        this.interfaces.add("Interfaces of the starting node filled by the link");
        this.interfaces.add("Interfaces of the link filled by the starting node");
        this.interfaces.add("Interfaces of the ending node filled by the link");
        this.interfaces.add("Interfaces of the link filled by the ending node");
        this.interfaces.add("Interfaces of the ending node filled by the starting node");
        this.interfaces.add("Interfaces of the starting node filled by the ending node");
        this.parameters.add(this.interfaces);
    }

    public void initializeListPanel() {
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        GObjectInformation listInformation = new GObjectInformation(this.information);
        listInformation.addStepToPath("interfaceList");
        this.interfacesLinkFilledByStartingNodeControledList = new GWidgetControledList(this, listInformation, "Interfaces of the link filled by the starting node", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, this.information.getTypeConcerned());
        this.interfacesLinkFilledByEndingNodeControledList = new GWidgetControledList(this, listInformation, "Interfaces of the link filled by the ending node", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, this.information.getTypeConcerned());
        this.interfacesEndingNodeFilledByLinkControledList = new GWidgetControledList(this, listInformation, "Interfaces of the ending node filled by the link", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, xmlLoader.findNodes().get(0));
        this.interfacesEndingNodeFilledByStartingNodeControledList = new GWidgetControledList(this, listInformation, "Interfaces of the ending node filled by the starting node", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, xmlLoader.findNodes().get(0));
        this.interfacesStartingNodeFilledByLinkControledList = new GWidgetControledList(this, listInformation, "Interfaces of the starting node filled by the link", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, xmlLoader.findNodes().get(0));
        this.interfacesStartingNodeFilledByEndingNodeControledList = new GWidgetControledList(this, listInformation, "Interfaces of the starting node filled by the ending node", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.INTERFACE, xmlLoader.findNodes().get(0));
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case NOTIFYCHANGE: {
                if (message.getArguments().get(0) == null || this.comboPanel == null) break;
                String selectedItem = (String)message.getArguments().get(0);
                String emiter = message.getSender().getLastPartOfThePath();
                if (emiter.equals("1")) {
                    System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                    message = new GMessage(this.information, Messages.SETWINDOWARGUMENTS, selectedItem);
                    if (this.interfacesEndingNodeFilledByLinkControledList != null) {
                        this.interfacesEndingNodeFilledByLinkControledList.translateMessage(message);
                    }
                    if (this.interfacesEndingNodeFilledByStartingNodeControledList != null) {
                        this.interfacesEndingNodeFilledByStartingNodeControledList.translateMessage(message);
                    }
                    if (this.interfacesStartingNodeFilledByLinkControledList != null) {
                        this.interfacesStartingNodeFilledByLinkControledList.translateMessage(message);
                    }
                    if (this.interfacesStartingNodeFilledByEndingNodeControledList != null) {
                        this.interfacesStartingNodeFilledByEndingNodeControledList.translateMessage(message);
                    }
                }
                if (emiter.equals("2")) {
                    System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                    if (this.cardLayout != null) {
                        this.cardLayout.show(this.cardPanel, selectedItem);
                    }
                }
                if (!emiter.equals("interfaceList")) break;
                if (selectedItem.equals("DEL")) {
                    --this.numberOfItems;
                }
                if (selectedItem.equals("ADD")) {
                    ++this.numberOfItems;
                }
                GMessage messageToBeSent = this.numberOfItems > 0 ? new GMessage(null, Messages.SETMODIFIABLE, false) : new GMessage(null, Messages.SETMODIFIABLE, true);
                if (this.comboGridForm == null) break;
                this.comboGridForm.translateMessage(new GMessage(null, Messages.SENDTOWIDGET, new Object[]{1, messageToBeSent}));
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowLinkPort : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("CONNEXION_ACCEPTEE"));
        GXMLElementFactory.saveElements(this.root, this.comboGridForm.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesStartingNodeFilledByLinkControledList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesLinkFilledByStartingNodeControledList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesEndingNodeFilledByLinkControledList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesLinkFilledByEndingNodeControledList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesEndingNodeFilledByStartingNodeControledList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.interfacesStartingNodeFilledByEndingNodeControledList.saveXML());
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        Vector<Element> fieldsLoad = new Vector<Element>();
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("TYPE_POINT_CONNEXION")).get(0));
        fieldsLoad.add(null);
        Vector<Element> bufferVect = new Vector<Element>();
        bufferVect.add(e);
        this.interfacesStartingNodeFilledByLinkControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_DEPART_LIEN")), true);
        System.err.println("NB ELEMENT 1 : " + this.interfacesStartingNodeFilledByLinkControledList.GetNumberOfElement());
        this.interfacesLinkFilledByStartingNodeControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_LIEN_DEPART")), true);
        System.err.println("NB ELEMENT 2 : " + this.interfacesLinkFilledByStartingNodeControledList.GetNumberOfElement());
        this.interfacesEndingNodeFilledByLinkControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_ARRIVEE_LIEN")), true);
        System.err.println("NB ELEMENT 3 : " + this.interfacesEndingNodeFilledByLinkControledList.GetNumberOfElement());
        this.interfacesLinkFilledByEndingNodeControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_LIEN_ARRIVEE")), true);
        System.err.println("NB ELEMENT 4 : " + this.interfacesLinkFilledByEndingNodeControledList.GetNumberOfElement());
        this.interfacesEndingNodeFilledByStartingNodeControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_ARRIVEE_DEPART")), true);
        System.err.println("NB ELEMENT 5 : " + this.interfacesEndingNodeFilledByStartingNodeControledList.GetNumberOfElement());
        this.interfacesStartingNodeFilledByEndingNodeControledList.loadXML(GXMLElementFactory.refactorElements(bufferVect, this.information.getLanguage().getBDCTranslation("REGLE_DEPART_ARRIVEE")), true);
        System.err.println("NB ELEMENT 6 : " + this.interfacesStartingNodeFilledByEndingNodeControledList.GetNumberOfElement());
        Vector<String> StrBuffer = new Vector<String>();
        Vector<GWidgetControledList> itemList = new Vector<GWidgetControledList>();
        itemList.add(this.interfacesStartingNodeFilledByLinkControledList);
        itemList.add(this.interfacesLinkFilledByStartingNodeControledList);
        itemList.add(this.interfacesEndingNodeFilledByLinkControledList);
        itemList.add(this.interfacesLinkFilledByEndingNodeControledList);
        itemList.add(this.interfacesEndingNodeFilledByStartingNodeControledList);
        itemList.add(this.interfacesStartingNodeFilledByEndingNodeControledList);
        int i = 0;
        while (i < 6) {
            StrBuffer.add(this.parameters.elementAt(2).elementAt(i).toString());
            if (((GWidgetControledList)itemList.get(i)).GetNumberOfElement() != 0) {
                StrBuffer.set(i, String.valueOf((String)StrBuffer.get(i)) + "*");
                this.parameters.elementAt(2).set(i, StrBuffer.get(i));
            }
            ++i;
        }
        this.comboGridForm = new GWidgetGridForm(this, this.information, this.labels, 2, 3, this.widgetClasses, this.parameters);
        this.comboGridForm.loadXML(fieldsLoad, false);
        this.comboPanel.add((Component)this.comboGridForm, "North");
        this.cardPanel.add((Component)this.interfacesStartingNodeFilledByLinkControledList, StrBuffer.get(0));
        this.cardPanel.add((Component)this.interfacesLinkFilledByStartingNodeControledList, StrBuffer.get(1));
        this.cardPanel.add((Component)this.interfacesEndingNodeFilledByLinkControledList, StrBuffer.get(2));
        this.cardPanel.add((Component)this.interfacesLinkFilledByEndingNodeControledList, StrBuffer.get(3));
        this.cardPanel.add((Component)this.interfacesEndingNodeFilledByStartingNodeControledList, StrBuffer.get(4));
        this.cardPanel.add((Component)this.interfacesStartingNodeFilledByEndingNodeControledList, StrBuffer.get(5));
    }
}

