/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetTextArea;
import GWindow.GWindow;
import GXMLLoader.GXMLLoader;
import GXSDOperations.GXSDOperations;
import global.ControlTypes;
import global.ListTypes;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GWindowMain
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JMenuBar menuBar;
    private JMenu menu;
    private JMenuItem saveItem;
    private JMenuItem exitItem;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private GWidgetTextArea descriptionTextArea;
    private GWidgetControledList visualizationNamesList;
    private static GWidgetControledList menuItemNamesList;
    private JPanel secondPanel;
    private GWidgetControledList typeList;
    private JPanel thirdPanel;
    private GWidgetControledList faultTreeGenerationModelsList;
    private GWidgetControledList simulationModelsList;
    private GWidgetControledList figaro0SinstanciationModelsList;
    private GWidgetControledList externalTreatmentsModelsList;
    private JPanel fourthPanel;
    private GWidgetControledList algoList;
    private VisualFigaro visualFigaro;

    @Deprecated
    public GWindowMain(GObject p, GObjectInformation info) {
        super(p, info);
        this.initialization();
    }

    public GWindowMain(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.initialization();
    }

    public GWindowMain(VisualFigaro vf, GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.visualFigaro = vf;
        GXSDOperations.setLanguage(info.getLanguage().getLanguage());
        this.initialization();
    }

    private void initialization() {
        Iterator<String> iter = figaroLoader.findSteps().iterator();
        while (iter.hasNext()) {
            System.out.println("L'etape est : " + iter.next());
        }
        this.initializeMenuBar();
        this.setJMenuBar(this.menuBar);
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("General", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Classes", this.secondPanel);
        this.initializeThirdPanel();
        this.tabs.add("Models", this.thirdPanel);
        this.initializeFourthPanel();
        this.framePanel.add((Component)this.tabs, "Center");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("BDC Editor");
        this.loadXml(xmlLoader.getRootElement());
    }

    private void initializeMenuBar() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Menu");
        this.saveItem = new JMenuItem("Save");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GWindowMain.this.saveXmlToFile();
            }
        });
        this.menu.add(this.saveItem);
        this.exitItem = new JMenuItem("Exit without saving");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowMain.this.dispose();
            }
        });
        this.menu.add(this.exitItem);
        this.menuBar.add(this.menu);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        this.initializeFirstPanelFields();
        this.initializeFirstPanelBorderedWidgets();
    }

    private void initializeFirstPanelFields() {
        Vector<String> labels = new Vector<String>();
        labels.add("Name :");
        labels.add("Author :");
        labels.add("Creation Date :");
        labels.add("Modification Date :");
        labels.add("Step RM :");
        labels.add("Step EI :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.FORMATTEDTEXTFIELD);
        widgetClasses.add(WidgetClasses.FORMATTEDTEXTFIELD);
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        Vector<String> values = new Vector<String>();
        values.add(this.information.getLanguage().getBDCTranslation("Etape par defaut"));
        values.addAll(figaroLoader.findSteps());
        objectArgs.add(values);
        objectArgs.add(values);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 3, widgetClasses, objectArgs);
        this.firstPanel.add((Component)this.generalCharacteristicsGridForm, "North");
    }

    private void initializeFirstPanelBorderedWidgets() {
        JPanel bufferPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.descriptionTextArea = new GWidgetTextArea(this, this.information, "Description");
        bufferPanel.add(this.descriptionTextArea);
        this.visualizationNamesList = new GWidgetControledList(this, this.information, "Visualizations", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDELUPDOWN, WindowClasses.NAMESIMPLE, null);
        bufferPanel.add(this.visualizationNamesList);
        menuItemNamesList = new GWidgetControledList(this, this.information, "Menu Items", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDELUPDOWN, WindowClasses.NAMESIMPLE, null);
        bufferPanel.add(menuItemNamesList);
        this.firstPanel.add((Component)bufferPanel, "Center");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        this.typeList = new GWidgetControledList(this, this.information, "Types", figaroLoader.findTypesName(), ListTypes.COMPLEXARRAY, NameRetrieverClasses.TYPENODELINKRETRIEVER, ControlTypes.NODELINKNEITHERUPDOWNEDIT, null, null);
        this.secondPanel.add((Component)this.typeList, "Center");
    }

    private void initializeThirdPanel() {
        this.thirdPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        this.faultTreeGenerationModelsList = new GWidgetControledList(this, this.information, "Fault Trees Generation Models", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.FAULTTREEGENERATIONMODEL, null);
        this.thirdPanel.add(this.faultTreeGenerationModelsList);
        this.simulationModelsList = new GWidgetControledList(this, this.information, "Simulation Models", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.SIMULATIONMODEL, null);
        this.thirdPanel.add(this.simulationModelsList);
        this.figaro0SinstanciationModelsList = new GWidgetControledList(this, this.information, "Figaro 0 Instanciation Models", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.FIGARO0INSTANCIATIONMODEL, null);
        this.thirdPanel.add(this.figaro0SinstanciationModelsList);
        this.externalTreatmentsModelsList = new GWidgetControledList(this, this.information, "External Treatments Models", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.EXTERNALTREATMENTMODEL, null);
        this.thirdPanel.add(this.externalTreatmentsModelsList);
    }

    private void initializeFourthPanel() {
        this.algoList = new GWidgetControledList(this, this.information, "Algorithms", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.ALGORETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.ALGO, null);
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("BDC"));
        this.root.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        String currentlanguage = new String(this.information.getLanguage().getLanguage().toString());
        String xsdfilename = new String("bdcfr.xsd");
        if (currentlanguage.equals("English")) {
            xsdfilename = "bdceng.xsd";
        }
        this.root.setAttribute("noNamespaceSchemaLocation", xsdfilename, Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Vector<Element> generalCharacteristicsGridFormVector = new Vector<Element>(this.generalCharacteristicsGridForm.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(0));
        GXMLElementFactory.saveElements(this.root, this.descriptionTextArea.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(1));
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(2));
        Date currentDate = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd");
        generalCharacteristicsGridFormVector.get(3).removeContent(0);
        generalCharacteristicsGridFormVector.get(3).addContent(simpleFormat.format(currentDate));
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(3));
        GXMLElementFactory.saveElements(this.root, this.faultTreeGenerationModelsList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.simulationModelsList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.figaro0SinstanciationModelsList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.externalTreatmentsModelsList.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(4));
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(5));
        GXMLElementFactory.saveElements(this.root, this.visualizationNamesList.saveXML());
        GXMLElementFactory.saveElements(this.root, menuItemNamesList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.typeList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.algoList.saveXML());
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        Vector<Element> fieldsLoad = new Vector<Element>();
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("AUTEUR")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("DATE_CREATION")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("DATE_MODIFICATION")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("ETAPE_RM")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("ETAPE_EI")).get(0));
        this.generalCharacteristicsGridForm.loadXML(fieldsLoad, false);
        this.descriptionTextArea.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("DESCRIPTION")), false);
        Vector<Element> listLoad = new Vector<Element>();
        listLoad.add(e);
        this.visualizationNamesList.loadXML(GXMLElementFactory.refactorElementsOnlyChildren(listLoad, this.information.getLanguage().getBDCTranslation("VISUALISATION")), false);
        menuItemNamesList.loadXML(GXMLElementFactory.refactorElementsOnlyChildren(listLoad, this.information.getLanguage().getBDCTranslation("FAMILLE_TYPE_PALETTE")), false);
        this.typeList.loadXML(GXMLElementFactory.refactorElements(listLoad, this.information.getLanguage().getBDCTranslation("TYPE")), false);
        this.faultTreeGenerationModelsList.loadXML(GXMLElementFactory.refactorElements(listLoad, this.information.getLanguage().getBDCTranslation("MODELE_GENERATION_ADD")), false);
        this.simulationModelsList.loadXML(GXMLElementFactory.refactorElements(listLoad, this.information.getLanguage().getBDCTranslation("MODELE_SIMULATION")), false);
        this.figaro0SinstanciationModelsList.loadXML(GXMLElementFactory.refactorElements(listLoad, this.information.getLanguage().getBDCTranslation("MODELE_INST_FIG0")), false);
        this.externalTreatmentsModelsList.loadXML(GXMLElementFactory.refactorElements(listLoad, this.information.getLanguage().getBDCTranslation("MODELE_TRAITEMENT_EXTERNE")), false);
        this.algoList.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("LISTE_ALGO")), true);
    }

    public static GWidgetControledList getItemList() {
        return menuItemNamesList;
    }

    public void loadXml(String fileName) {
        GXMLLoader xl = new GXMLLoader(this.information.getLanguage());
        this.root = xl.loadXmlFileJDOM(fileName).getRootElement();
    }

    public void saveXmlToFile() {
        this.fillDocument();
        String fileName = String.valueOf(this.visualFigaro.getCurrentSelectedTree().substring(0, this.visualFigaro.getCurrentSelectedTree().length() - 2 >= 0 ? this.visualFigaro.getCurrentSelectedTree().length() - 2 : 0)) + "bdc";
        try {
            FileOutputStream fichier = new FileOutputStream(fileName);
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            sortie.output(new Document(this.root), (OutputStream)fichier);
            fichier.close();
        }
        catch (IOException ioe) {
            System.out.println("VisualFigaro : GWindowMain : Cannot save xml to file : " + ioe);
        }
        this.visualFigaro.setIconsUpToDate();
        this.visualFigaro.repaintFigTree();
    }
}

