/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetOKCancel;
import GWidget.GWidgetTextArea;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdom.Element;

public class GWindowNode
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private GWidgetTextArea descriptionTextArea;
    private GWidgetControledList menuItemNamesList;
    private GWidgetControledList variantesGraphiquesList;
    private JPanel secondPanel;
    private GWidgetControledList portsList;
    private GWidgetOKCancel okCancelWidget;
    private int position;
    private String nodeName;

    @Deprecated
    public GWindowNode(GObject p, GObjectInformation info) {
        super(p, info);
        this.initialization();
    }

    public GWindowNode(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.nodeName = info.getTypeConcerned();
        this.initialization();
    }

    private void initialization() {
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("General", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Ports", this.secondPanel);
        this.framePanel.add((Component)this.tabs, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Node : " + this.nodeName);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        this.initializeFirstPanelFields();
        this.initializeFirstPanelBorderedWidgets();
    }

    private void initializeFirstPanelFields() {
        Vector<String> labels = new Vector<String>();
        labels.add("Abbreviation :");
        labels.add("Presence Palette :");
        labels.add("Default Variant :");
        labels.add("Graphic Instance :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.EDITDEFAULTVAR);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        Vector<Object> values = new Vector<Object>();
        values.add("TRUE");
        values.add("FALSE");
        objectArgs.add(values);
        values = new Vector();
        values.add("Edit Default GV");
        values.add(true);
        objectArgs.add(values);
        values = new Vector();
        values.add("TRUE");
        values.add("FALSE");
        objectArgs.add(values);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 2, widgetClasses, objectArgs);
        this.firstPanel.add((Component)this.generalCharacteristicsGridForm, "North");
    }

    private void initializeFirstPanelBorderedWidgets() {
        JPanel bufferPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.descriptionTextArea = new GWidgetTextArea(this, this.information, "Description");
        bufferPanel.add(this.descriptionTextArea);
        this.menuItemNamesList = new GWidgetControledList(this, this.information, "Menu Items", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.MENU, null);
        bufferPanel.add(this.menuItemNamesList);
        this.variantesGraphiquesList = new GWidgetControledList(this, this.information, "Graphic Variants", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.VARNODE, null);
        bufferPanel.add(this.variantesGraphiquesList);
        this.firstPanel.add((Component)bufferPanel, "Center");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        this.portsList = new GWidgetControledList(this, this.information, "Ports", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.PORTNODE, null);
        this.secondPanel.add((Component)this.portsList, "Center");
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.NODEMODIFICATION, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("TYPE"));
        Element name = new Element(this.information.getLanguage().getBDCTranslation("NOM"));
        name.setText(this.nodeName);
        GXMLElementFactory.saveElement(this.root, name);
        Vector<Element> generalCharacteristicsGridFormVector = new Vector<Element>(this.generalCharacteristicsGridForm.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(1));
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(0));
        GXMLElementFactory.saveElements(this.root, this.descriptionTextArea.saveXML());
        GXMLElementFactory.saveElements(this.root, this.menuItemNamesList.saveXML());
        GXMLElementFactory.saveElement(this.root, generalCharacteristicsGridFormVector.get(2));
        GXMLElementFactory.saveElements(this.root, this.variantesGraphiquesList.saveXML());
        Element element = new Element(this.information.getLanguage().getBDCTranslation("NOEUD"));
        GXMLElementFactory.saveElement(element, generalCharacteristicsGridFormVector.get(3));
        GXMLElementFactory.saveElements(element, this.variantesGraphiquesList.saveXML());
        GXMLElementFactory.saveElements(element, this.portsList.saveXML());
        GXMLElementFactory.saveElement(this.root, element);
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        Vector<Element> fieldsLoad = new Vector<Element>();
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("ABREVIATION")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("PRESENCE_PALETTE")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE_DEFAUT")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("INSTANCE_GRAPHIQUE")).get(0));
        this.generalCharacteristicsGridForm.loadXML(fieldsLoad, false);
        this.descriptionTextArea.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("DESCRIPTION")), false);
        Vector<Element> elem = new Vector<Element>();
        elem.add(e);
        this.menuItemNamesList.loadXML(GXMLElementFactory.refactorElements(elem, this.information.getLanguage().getBDCTranslation("FAMILLE_TYPE_PALETTE")), false);
        this.variantesGraphiquesList.loadXML(GXMLElementFactory.refactorElements(elem, this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE")), false);
        this.portsList.loadXML(GXMLElementFactory.refactorElements(elem, this.information.getLanguage().getBDCTranslation("POINT_CONNEXION")), false);
    }
}

