/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetManageIcon;
import GWidget.GWidgetOKCancel;
import GWidget.GWidgetTextField;
import GWindow.GWindow;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Element;

public class GWindowNodePort
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JMenuBar menuBar;
    private JMenu menu;
    private JRadioButtonMenuItem inheritanceItem;
    private JRadioButtonMenuItem definitionItem;
    private GWidgetOKCancel okCancelWidget;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JPanel inheritancePanel;
    private GWidgetGridForm inheritanceGridForm;
    private JPanel definitionPanel;
    private GWidgetTextField nameTextField;
    private GWidgetControledList connectionList;
    private GWidgetManageIcon manageIcon;
    private int position;

    @Deprecated
    public GWindowNodePort(GObject p, GObjectInformation info) {
        super(p, info);
        this.position = -1;
        this.initialization();
    }

    public GWindowNodePort(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.initialization();
    }

    private void initialization() {
        this.inheritancePanelInitialization();
        this.defineInitialization();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.inheritancePanel, "inherit");
        this.cardPanel.add((Component)this.definitionPanel, "defined");
        this.framePanel.add((Component)this.cardPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Port Window");
        this.menuBarInitialization();
    }

    private void menuBarInitialization() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Definition");
        this.menuBar.add(this.menu);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.inheritanceItem = new JRadioButtonMenuItem("Inherit From Parent");
        this.inheritanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowNodePort.this.cardLayout.show(GWindowNodePort.this.cardPanel, "inherit");
            }
        });
        buttonGroup.add(this.inheritanceItem);
        this.menu.add(this.inheritanceItem);
        this.definitionItem = new JRadioButtonMenuItem("User Defined");
        this.definitionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowNodePort.this.cardLayout.show(GWindowNodePort.this.cardPanel, "defined");
            }
        });
        buttonGroup.add(this.definitionItem);
        this.menu.add(this.definitionItem);
        this.setJMenuBar(this.menuBar);
        this.inheritanceItem.setSelected(true);
    }

    private void inheritancePanelInitialization() {
        this.inheritancePanel = new JPanel(new BorderLayout());
        Vector<String> types = new Vector<String>();
        for (String s : figaroLoader.findAncestors(this.information.getTypeConcerned())) {
            System.err.println("voici s " + s);
            types.add(s);
        }
        Vector<String> labels = new Vector<String>();
        labels.add("Inherit Port : ");
        labels.add("Inherit From Class : ");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> parameters = new Vector<Vector<Object>>();
        Vector<String> ports = new Vector<String>();
        if (types.size() > 0) {
            for (String s : xmlLoader.findPortsNames((String)types.get(0))) {
                ports.add(s);
            }
        }
        parameters.add(ports);
        parameters.add(types);
        this.inheritanceGridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, parameters);
        this.inheritancePanel.add((Component)this.inheritanceGridForm, "North");
    }

    private void defineInitialization() {
        this.definitionPanel = new JPanel(new BorderLayout());
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add((Component)new JLabel("Name : "), "West");
        this.nameTextField = new GWidgetTextField(this, this.information);
        textFieldPanel.add((Component)this.nameTextField, "Center");
        this.definitionPanel.add((Component)textFieldPanel, "North");
        this.connectionList = new GWidgetControledList(this, this.information, "Accepted Connections", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.NAMERETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.CONNECTION, null);
        this.definitionPanel.add((Component)this.connectionList, "Center");
        Image image = this.loadIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "test.ico");
        this.manageIcon = new GWidgetManageIcon(this, this.information, image);
        this.definitionPanel.add((Component)this.manageIcon, "South");
    }

    private Image loadIcon(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        ICOFile icon = null;
        try {
            icon = new ICOFile(file.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("VisualFigaro : GWindowDefaultVarNode : Error while reading the icon file : " + file + " ." + e);
        }
        BitmapDescriptor bmpdesc = icon.getDescriptor(0);
        Image image = bmpdesc.getImageRGB();
        return image;
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case ICONCHOOSED: {
                System.out.println("ICON CHOOSED");
                break;
            }
            case NOTIFYCHANGE: {
                if (message.getArguments().get(0) == null || this.inheritanceGridForm == null) break;
                String selectedItem = (String)message.getArguments().get(0);
                int emiter = -1;
                try {
                    emiter = Integer.parseInt(message.getSender().getLastPartOfThePath());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (emiter != 1) break;
                System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                Vector<Object> arguments = new Vector<Object>();
                arguments.add(0);
                GMessage dummyMessage = new GMessage(this.information, Messages.REPLACEDEFAULTVALUES);
                for (String portName : xmlLoader.findPortsNames(selectedItem)) {
                    dummyMessage.addArgument(portName);
                }
                arguments.add(dummyMessage);
                GMessage messageToEmit = new GMessage(this.information, Messages.SENDTOWIDGET, arguments);
                this.inheritanceGridForm.translateMessage(messageToEmit);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("POINT_CONNEXION"));
        if (this.inheritanceItem.isSelected()) {
            GXMLElementFactory.saveElements(this.root, this.inheritanceGridForm.saveXML());
        } else {
            GXMLElementFactory.saveElements(this.root, this.nameTextField.saveXML("NOM"));
            GXMLElementFactory.saveElements(this.root, this.manageIcon.saveXML());
            GXMLElementFactory.saveElements(this.root, this.connectionList.saveXML());
        }
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        if (e != null) {
            if (e.getChild(this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")) != null) {
                this.inheritanceItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "inherit");
            } else {
                this.definitionItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "defined");
            }
        }
        Vector<Element> elemVect = new Vector<Element>();
        elemVect.add(e);
        Vector<Element> inheritanceFields = new Vector<Element>();
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")).get(0));
        this.inheritanceGridForm.loadXML(inheritanceFields, false);
        this.nameTextField.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")), false);
        Vector<Element> elements = new Vector<Element>();
        elements.add(e);
        this.connectionList.loadXML(GXMLElementFactory.refactorElements(elements, this.information.getLanguage().getBDCTranslation("CONNEXION_ACCEPTEE")), false);
        this.manageIcon.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("POSITION")), false);
    }
}

