/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GKnowledgeBase.GKnowledgeBase;
import GMessage.GMessage;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Element;

public class GWindowOpenModel
extends GWindow {
    private static final long serialVersionUID = 1L;
    private VisualFigaro vfParent;
    private Vector<GKnowledgeBase> knowledgedBasesVector;
    private JPanel framePanel;
    private JPanel logoPanel;
    private JPanel fieldsPanel;
    private JComboBox knowledgeBaseComboBox;
    private JTextField nameTextField;
    private JButton openExplorerButton;
    private GWidgetOKCancel okCancelWidget;

    public GWindowOpenModel(VisualFigaro vf, Vector<GKnowledgeBase> knowledgedBases) {
        this.vfParent = vf;
        this.knowledgedBasesVector = knowledgedBases;
        this.framePanel = new JPanel(new BorderLayout());
        this.initializeLogoPart();
        this.framePanel.add((Component)this.logoPanel, "North");
        this.initializeFieldPart();
        this.framePanel.add((Component)this.fieldsPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.setSize(310, 225);
        this.setResizable(false);
        this.setTitle("Open a Model");
    }

    private void initializeLogoPart() {
        this.logoPanel = new JPanel(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "logoEDF.gif");
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(imageIcon);
        this.logoPanel.add((Component)iconLabel, "West");
        JLabel titleLabel = new JLabel("Model Opening Wizard  ");
        this.logoPanel.add((Component)titleLabel, "East");
    }

    private void initializeFieldPart() {
        this.fieldsPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new GridLayout());
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel("Knowledge Base : "));
        labelPanel.add(new JLabel("Name : "));
        northPanel.add(labelPanel);
        JPanel componentPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.knowledgeBaseComboBox = new JComboBox();
        try {
            for (GKnowledgeBase knowledgeBase : this.knowledgedBasesVector) {
                String kBName = knowledgeBase.getKnowledgeBaseName();
                int pos = kBName.lastIndexOf(92);
                kBName = kBName.substring(pos + 1);
                this.knowledgeBaseComboBox.addItem(kBName);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.vfParent, "An error occured !");
            return;
        }
        componentPanel.add(this.knowledgeBaseComboBox);
        this.nameTextField = new JTextField();
        componentPanel.add(this.nameTextField);
        northPanel.add(componentPanel);
        this.fieldsPanel.add((Component)northPanel, "North");
        JPanel explorePanel = new JPanel(new BorderLayout());
        this.openExplorerButton = new JButton("Explore");
        this.openExplorerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowOpenModel.this.showFileChooser();
            }
        });
        explorePanel.add((Component)this.openExplorerButton, "East");
        this.fieldsPanel.add((Component)explorePanel, "South");
    }

    private void showFileChooser() {
        JFileChooser fileChooser = new JFileChooser(this.vfParent.getPrevModelFile());
        class MyFilter
        extends FileFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String filename = file.getName();
                return filename.endsWith(".fi");
            }

            @Override
            public String getDescription() {
                return "*.fi";
            }
        }
        fileChooser.addChoosableFileFilter(new MyFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.showOpenDialog(this);
        File file = fileChooser.getSelectedFile();
        this.nameTextField.setText(file.toString());
        fileChooser.setVisible(false);
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                if (this.nameTextField.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Select a model file first");
                    return;
                }
                GKnowledgeBase kb = this.knowledgedBasesVector.get(this.knowledgeBaseComboBox.getSelectedIndex());
                File model = new File(this.nameTextField.getText());
                this.dispose();
                this.vfParent.openModel(model, kb);
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowOpenModel : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        return null;
    }

    @Override
    public void loadXml(Element e) {
    }
}

