/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetOKCancel;
import GWidget.GWidgetTextField;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import org.jdom.Element;

public class GWindowVarLink
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JMenuBar menuBar;
    private JMenu menu;
    private JRadioButtonMenuItem inheritanceItem;
    private JRadioButtonMenuItem definitionItem;
    private GWidgetOKCancel okCancelWidget;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JPanel inheritancePanel;
    private GWidgetGridForm inheritanceGridForm;
    private JPanel definitionPanel;
    private GWidgetTextField nameTextField;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetControledList visualisationList;
    private GWidgetTextField conditionTextField;
    private JPanel secondPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private int position;

    @Deprecated
    public GWindowVarLink(GObject p, GObjectInformation info) {
        super(p, info);
        this.position = -1;
        this.initialization();
    }

    public GWindowVarLink(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.initialization();
    }

    private void initialization() {
        this.inheritancePanelInitialization();
        this.defineInitialization();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.inheritancePanel, "inherit");
        this.cardPanel.add((Component)this.definitionPanel, "defined");
        this.framePanel.add((Component)this.cardPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Graphic Variant");
        this.setSize(550, 320);
        this.menuBarInitialization();
    }

    private void menuBarInitialization() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Definition");
        this.menuBar.add(this.menu);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.inheritanceItem = new JRadioButtonMenuItem("Inherit From Parent");
        this.inheritanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowVarLink.this.cardLayout.show(GWindowVarLink.this.cardPanel, "inherit");
            }
        });
        buttonGroup.add(this.inheritanceItem);
        this.menu.add(this.inheritanceItem);
        this.definitionItem = new JRadioButtonMenuItem("User Defined");
        this.definitionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowVarLink.this.cardLayout.show(GWindowVarLink.this.cardPanel, "defined");
            }
        });
        buttonGroup.add(this.definitionItem);
        this.menu.add(this.definitionItem);
        this.setJMenuBar(this.menuBar);
        this.inheritanceItem.setSelected(true);
    }

    private void inheritancePanelInitialization() {
        this.inheritancePanel = new JPanel(new BorderLayout());
        Vector<String> types = new Vector<String>();
        for (String s : figaroLoader.findAncestors(this.information.getTypeConcerned())) {
            System.err.println("voici s " + s);
            types.add(s);
        }
        Vector<String> labels = new Vector<String>();
        labels.add("Inherit Graphic Variant: ");
        labels.add("Inherit From Type : ");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> parameters = new Vector<Vector<Object>>();
        Vector<String> variantes = new Vector<String>();
        if (types.size() > 0) {
            for (String s : xmlLoader.findVariantesGraphiquesNames((String)types.get(0))) {
                variantes.add(s);
            }
        }
        parameters.add(variantes);
        parameters.add(types);
        this.inheritanceGridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, parameters);
        this.inheritancePanel.add((Component)this.inheritanceGridForm, "North");
    }

    private void defineInitialization() {
        this.definitionPanel = new JPanel(new BorderLayout());
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add((Component)new JLabel("Name : "), "West");
        this.nameTextField = new GWidgetTextField(this, this.information);
        textFieldPanel.add((Component)this.nameTextField, "Center");
        this.definitionPanel.add((Component)textFieldPanel, "North");
        this.tabsInitialization();
        this.definitionPanel.add((Component)this.tabs, "Center");
    }

    private void tabsInitialization() {
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("General", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Link", this.secondPanel);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        this.visualisationList = new GWidgetControledList(this, this.information, "Visualizations", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.VISUALIZATION, null);
        this.firstPanel.add((Component)this.visualisationList, "North");
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)new JLabel("Condition : "), "West");
        this.conditionTextField = new GWidgetTextField(this, this.information);
        textPanel.add((Component)this.conditionTextField, "Center");
        this.firstPanel.add((Component)textPanel, "South");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        Vector<String> labels = new Vector<String>();
        labels.add("Link Style :");
        labels.add("Thickness :");
        labels.add("Main Color :");
        labels.add("Arrow Style :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.COLORCHOOSER);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 2, widgetClasses, objectArgs);
        this.secondPanel.add((Component)this.generalCharacteristicsGridForm, "North");
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case ICONCHOOSED: {
                System.out.println("ICON CHOOSED");
                break;
            }
            case NOTIFYCHANGE: {
                System.out.println("Aarg first element : " + message.getArguments().get(0));
                if (message.getArguments().get(0) == null || this.inheritanceGridForm == null) break;
                String selectedItem = (String)message.getArguments().get(0);
                int emiter = -1;
                try {
                    emiter = Integer.parseInt(message.getSender().getLastPartOfThePath());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (emiter != 1) break;
                System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                Vector<Object> arguments = new Vector<Object>();
                arguments.add(0);
                GMessage dummyMessage = new GMessage(this.information, Messages.REPLACEDEFAULTVALUES);
                for (String varName : xmlLoader.findVariantesGraphiquesNames(selectedItem)) {
                    dummyMessage.addArgument(varName);
                }
                arguments.add(dummyMessage);
                GMessage messageToEmit = new GMessage(this.information, Messages.SENDTOWIDGET, arguments);
                this.inheritanceGridForm.translateMessage(messageToEmit);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE"));
        if (this.inheritanceItem.isSelected()) {
            GXMLElementFactory.saveElements(this.root, this.inheritanceGridForm.saveXML());
        } else {
            GXMLElementFactory.saveElements(this.root, this.nameTextField.saveXML());
            GXMLElementFactory.saveElements(this.root, this.visualisationList.saveXML());
            GXMLElementFactory.saveElements(this.root, this.conditionTextField.saveXML());
            Element element = new Element(this.information.getLanguage().getBDCTranslation("LIEN_VG"));
            GXMLElementFactory.saveElements(element, this.generalCharacteristicsGridForm.saveXML());
            GXMLElementFactory.saveElement(this.root, element);
        }
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        if (e != null) {
            if (e.getChild(this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")) != null) {
                this.inheritanceItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "inherit");
            } else {
                this.definitionItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "defined");
            }
        }
        Vector<Element> elemVect = new Vector<Element>();
        elemVect.add(e);
        Vector<Element> inheritanceFields = new Vector<Element>();
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")).get(0));
        this.inheritanceGridForm.loadXML(inheritanceFields, false);
        this.nameTextField.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")), false);
        this.visualisationList.loadXML(GXMLElementFactory.refactorElements(elemVect, this.information.getLanguage().getBDCTranslation("VISUALISATION")), false);
        this.conditionTextField.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("CONDITION")), false);
        Vector<Element> iconFields = new Vector<Element>();
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("STYLE_LIEN")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("EPAISSEUR_LIEN")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_PPLAN")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("STYLE_FLECHE")).get(0));
        this.generalCharacteristicsGridForm.loadXML(iconFields, false);
    }
}

