/*
 * Decompiled with CFR 0.152.
 */
package figaroInterface;

import GLanguage.GLanguage;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import figaroInterface.GCell;
import figaroInterface.GTree;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class FigaroTree
extends JPanel {
    private static final long serialVersionUID = 1L;
    int test = 0;
    private EmptyBorder eb;
    private BevelBorder bb;
    private JTree tree;
    private JScrollPane treeView;
    private JPopupMenu popup;
    static GTree gtree;
    static GExpListener expListener;
    static final int windowHeight = 150;
    static final int leftWidth = 100;
    static final int rightWidth = 150;
    static final int windowWidth = 250;
    int previousPosition = -1;
    static final String[] typeName;
    static final String[] figaroType;
    View view;
    VisualFigaro visualFigaro;

    static {
        typeName = new String[]{"none", "Element", "Attr", "Text", "CDATA", "EntityRef", "Entity", "ProcInstr", "Comment", "Document", "DocType", "DocFragment", "Notation"};
        figaroType = new String[0];
    }

    public FigaroTree(VisualFigaro ep) {
        this.visualFigaro = ep;
        this.view = ep.getView();
        jEdit.newFile((View)this.view);
        this.eb = new EmptyBorder(5, 5, 5, 5);
        this.bb = new BevelBorder(1);
        CompoundBorder cb = new CompoundBorder(this.eb, this.bb);
        this.setBorder(new CompoundBorder(cb, this.eb));
        gtree = new GTree();
        expListener = new GExpListener();
        this.tree = new JTree(new DomToTreeModelAdapter());
        this.tree.setCellRenderer(new KBTreeCellRenderer(this));
        this.tree.setRootVisible(false);
        this.tree.addTreeExpansionListener(expListener);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.popup = new JPopupMenu();
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    FigaroTree.this.popup.show((JComponent)me.getSource(), me.getX(), me.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    FigaroTree.this.popup.removeAll();
                    TreePath path = FigaroTree.this.tree.getPathForLocation(me.getX(), me.getY());
                    String treeTag = ((GCell)path.getLastPathComponent()).getValue(0).toString();
                    for (JMenu menu : FigaroTree.this.visualFigaro.getLanguage().getCompletionMenu(treeTag)) {
                        FigaroTree.this.popup.add(menu);
                    }
                    if (FigaroTree.this.popup.getComponentCount() > 0) {
                        FigaroTree.this.popup.show((JComponent)me.getSource(), me.getX(), me.getY());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mouseClicked(MouseEvent me) {
            }
        });
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setPreferredSize(new Dimension(100, 150));
        this.setLayout(new BorderLayout());
        this.add(this.treeView);
    }

    public void mouseClicked() {
        if (this.previousPosition != -1) {
            gtree.unsetFigaroCell(this.previousPosition);
            gtree.resetMarqueCell(this.previousPosition);
        }
        this.previousPosition = this.view.getEditPane().getTextArea().getCaretPosition();
        TreePath path = gtree.findPathToSelected(this.previousPosition);
        gtree.setFigaroCell(this.previousPosition);
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollRectToVisible(new Rectangle(this.treeView.getVisibleRect().x, this.tree.getRowForPath(path) * (this.tree.getBounds().height - this.tree.getVisibleRect().height) / this.tree.getRowCount(), this.tree.getVisibleRect().width, this.tree.getVisibleRect().height));
        this.treeView.repaint();
    }

    public void loadSpecificGTree(GTree t) {
        gtree = t == null ? new GTree() : t;
        this.tree.setModel(new DomToTreeModelAdapter());
        this.treeView.repaint();
    }

    public void newGTree() {
        gtree = new GTree();
    }

    public Vector<GCell> getTypes() {
        Vector<GCell> tamponVect = new Vector<GCell>();
        if (gtree == null) {
            return null;
        }
        if (gtree.getRoot() == null) {
            return null;
        }
        if (gtree.getRoot().getChildrenCount() <= 0) {
            return null;
        }
        int i = 0;
        while (i < gtree.getRoot().getChild(0).getChildrenCount()) {
            if (gtree.getRoot().getChild(0).getChild(i).getValue(0).toString().equals("CLASS")) {
                tamponVect.add(gtree.getRoot().getChild(0).getChild(i));
            }
            ++i;
        }
        return tamponVect;
    }

    public GTree getGTree() {
        return gtree;
    }

    public void loadTreeFromXML(String path, String fileText, GLanguage language) {
        gtree = new GTree();
        gtree.LoadXmlFile(path, language);
        gtree.numeroter();
        this.printFigaro(fileText);
        this.tree.setModel(new DomToTreeModelAdapter());
        this.treeView.repaint();
    }

    public void printFigaro(String fileText) {
        gtree.printFigaro(fileText);
    }

    @Override
    public VisualFigaro getParent() {
        return this.visualFigaro;
    }

    public class DomToTreeModelAdapter
    implements TreeModel {
        private Vector<TreeModelListener> listenerList = new Vector();

        @Override
        public Object getRoot() {
            return gtree.getRoot();
        }

        @Override
        public boolean isLeaf(Object aNode) {
            GCell node = (GCell)aNode;
            return node.getChildrenCount() <= 0;
        }

        @Override
        public int getChildCount(Object parent) {
            GCell node = (GCell)parent;
            return node.getChildrenCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            GCell node = (GCell)parent;
            return node.getChild(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            GCell node = (GCell)parent;
            return node.getChild((GCell)child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            if (listener != null && !this.listenerList.contains(listener)) {
                this.listenerList.addElement(listener);
            }
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            if (listener != null) {
                this.listenerList.removeElement(listener);
            }
        }

        public void fireTreeNodesChanged(TreeModelEvent e) {
            Enumeration<TreeModelListener> listeners = this.listenerList.elements();
            while (listeners.hasMoreElements()) {
                TreeModelListener listener = listeners.nextElement();
                listener.treeNodesChanged(e);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent e) {
            Enumeration<TreeModelListener> listeners = this.listenerList.elements();
            while (listeners.hasMoreElements()) {
                TreeModelListener listener = listeners.nextElement();
                listener.treeNodesInserted(e);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent e) {
            Enumeration<TreeModelListener> listeners = this.listenerList.elements();
            while (listeners.hasMoreElements()) {
                TreeModelListener listener = listeners.nextElement();
                listener.treeNodesRemoved(e);
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent e) {
            Enumeration<TreeModelListener> listeners = this.listenerList.elements();
            while (listeners.hasMoreElements()) {
                TreeModelListener listener = listeners.nextElement();
                listener.treeStructureChanged(e);
            }
        }

        public void fireEditingStopped(TreeModelEvent e) {
        }
    }

    public class GExpListener
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent ee) {
            ((GCell)ee.getPath().getLastPathComponent()).setExpanded();
            FigaroTree.this.view.getEditPane().focusOnTextArea();
            if (!FigaroTree.this.visualFigaro.getCurrentSelectedTree().equals(FigaroTree.this.view.getBuffer().getPath())) {
                return;
            }
            if (FigaroTree.this.view.getEditPane().getTextArea() == null || ((GCell)ee.getPath().getLastPathComponent()).getValue(0) != "BDC") {
                int pos = gtree.getCaretPosFromCell(((GCell)ee.getPath().getLastPathComponent()).getUID());
                if (pos >= 0 && FigaroTree.this.tree.isFocusOwner()) {
                    FigaroTree.this.view.getEditPane().getTextArea().setCaretPosition(pos + 5);
                }
                FigaroTree.this.view.getEditPane().focusOnTextArea();
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent ee) {
            ((GCell)ee.getPath().getLastPathComponent()).setCollapsed();
            if (FigaroTree.this.view.getEditPane().getTextArea() != null) {
                int pos = gtree.getCaretPosFromCell(((GCell)ee.getPath().getLastPathComponent()).getUID());
                if (pos >= 0) {
                    FigaroTree.this.view.getEditPane().getTextArea().setCaretPosition(pos + 5);
                }
                FigaroTree.this.view.getEditPane().focusOnTextArea();
            }
            if (FigaroTree.this.view.getEditPane().getTextArea() == null || ((GCell)ee.getPath().getLastPathComponent()).getValue(0) == "BDC") {
                // empty if block
            }
        }
    }

    public class KBTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        FigaroTree parent;

        public KBTreeCellRenderer(FigaroTree p) {
            this.parent = p;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (((GCell)obj).isEquivalentToSelectedFigaro() > 0) {
                this.setTextSelectionColor(Color.WHITE);
                this.setBackgroundSelectionColor(new Color(255 - ((GCell)obj).isEquivalentToSelectedFigaro() * 50, 255 - ((GCell)obj).isEquivalentToSelectedFigaro() * 50, 255));
                this.setTextNonSelectionColor(Color.WHITE);
                this.setBackgroundNonSelectionColor(new Color(255 - ((GCell)obj).isEquivalentToSelectedFigaro() * 50, 255 - ((GCell)obj).isEquivalentToSelectedFigaro() * 50, 255));
            } else if (((GCell)obj).getMarquage().y > 0) {
                Point p = ((GCell)obj).getMarquage();
                this.setTextSelectionColor(Color.WHITE);
                this.setBackgroundSelectionColor(new Color(255, 255 - (int)(((float)p.y + 1.0f) / ((float)p.x + 1.0f) * 200.0f), 255 - (int)(((float)p.y + 1.0f) / ((float)p.x + 1.0f) * 200.0f)));
                this.setTextNonSelectionColor(Color.WHITE);
                this.setBackgroundNonSelectionColor(new Color(255, 255 - (int)(((float)p.y + 1.0f) / ((float)p.x + 1.0f) * 200.0f), 255 - (int)(((float)p.y + 1.0f) / ((float)p.x + 1.0f) * 200.0f)));
            } else {
                this.setTextSelectionColor(Color.BLACK);
                this.setBackgroundSelectionColor(Color.WHITE);
                this.setTextNonSelectionColor(Color.BLACK);
                this.setBackgroundNonSelectionColor(Color.WHITE);
            }
            if (((GCell)obj).getVirtual()) {
                this.setTextSelectionColor(Color.GREEN);
                this.setTextNonSelectionColor(Color.GREEN);
            }
            super.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
            if (((GCell)obj).getValue(0) != null && ((String)((GCell)obj).getValue(0)).equals("CLASS") && ((GCell)obj).getChildrenCount() > 1) {
                File fichier;
                if (this.parent.getParent() == null) {
                    System.out.println("Le parent DomEcho est null");
                } else {
                    System.out.println("Le parent DomEcho n'est pas null");
                }
                System.out.println("VOOICI LE STRING : " + (String)((GCell)obj).getValue(0));
                if (this.parent.getParent().getIcon((String)((GCell)obj).getChild(0).getChild(0).getValue(1)) != null && (fichier = new File(this.parent.getParent().getIcon((String)((GCell)obj).getChild(0).getChild(0).getValue(1)))).exists()) {
                    ICOFile icone = null;
                    try {
                        icone = new ICOFile(fichier.getAbsolutePath());
                    }
                    catch (IOException e) {
                        System.err.println("Erreur lors de la lecture du fichier icone : " + fichier + " ." + e);
                    }
                    BitmapDescriptor bmpdesc = icone.getDescriptor(0);
                    Image image = bmpdesc.getImageRGB();
                    if (image == null) {
                        System.err.println("Visual Figaro : FigaroTree : Error during loading of icon file : " + fichier);
                    } else {
                        ImageIcon icon = new ImageIcon(image);
                        this.setIcon(icon);
                    }
                }
            }
            return this;
        }
    }
}

