/*
 * Decompiled with CFR 0.152.
 */
package figaroInterface;

import GLanguage.GLanguage;
import GXMLLoader.GXMLLoader;
import figaroInterface.GCell;
import figaroParser.FigaroParser;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;

public class GTree {
    private GCell root;
    private Document document;
    private ArrayList<GCell> allCells;
    private ArrayList<Integer> allCellsAssociations;
    private FigaroParser figParser;
    private GLanguage language;

    public GTree() {
        this.root = new GCell();
        this.allCells = new ArrayList();
        this.allCellsAssociations = new ArrayList();
        this.figParser = new FigaroParser();
        this.language = new GLanguage();
    }

    public GTree(GCell r, Document d, ArrayList<GCell> ac, ArrayList<Integer> aca) {
        this.root = r;
        this.document = d;
        this.allCells = ac;
        this.allCellsAssociations = aca;
        this.figParser = new FigaroParser();
        this.language = new GLanguage();
    }

    public Document getDocument() {
        return this.document;
    }

    public ArrayList<GCell> getAllCells() {
        return this.allCells;
    }

    public ArrayList<Integer> getAllCellsAssociations() {
        return this.allCellsAssociations;
    }

    public int getDepth() {
        return this.root.getDepth();
    }

    public void LoadXmlFile(String path, GLanguage language) {
        this.language = language;
        GXMLLoader xl = new GXMLLoader(null);
        this.document = xl.loadXmlFile(path);
        if (this.document == null) {
            System.err.println("Le document a mal ete charge");
            return;
        }
        this.root.LoadXmlSubPart(this.document);
        this.rearrangeTreeFigaro();
    }

    public String toString() {
        return this.root.print(0);
    }

    public String print() {
        return this.root.print(0);
    }

    public GCell getRoot() {
        return this.root;
    }

    public GLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(GLanguage language) {
        this.language = language;
    }

    public int getCaretPosFromCell(int uid) {
        int pos = -1;
        int i = 0;
        while (i < this.allCellsAssociations.size()) {
            if (this.allCellsAssociations.get(i) == uid) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public void rearrangeTreeFigaro() {
        int bdcPos = 0;
        bdcPos = 0;
        while (bdcPos < this.root.getChildrenCount()) {
            if (this.root.getChild(bdcPos).getValue(0).toString() == "BDC") break;
            ++bdcPos;
        }
        int figPos = 0;
        while (figPos < this.root.getChild(bdcPos).getChildrenCount()) {
            if (this.root.getChild(bdcPos).getChild(figPos).getChildrenCount() > 0 && this.root.getChild(bdcPos).getChild(figPos).getChild(0).getChildrenCount() > 0 && this.root.getChild(bdcPos).getChild(figPos).getChild(0).getChild(0).getValue(1).toString().equals("FIGARO")) {
                this.root.getChild(bdcPos).remChild(figPos);
            }
            ++figPos;
        }
        GCell etape = new GCell();
        etape.addValue("STEP_ORDER");
        etape.addValue(null);
        this.root.getChild(bdcPos).addChild(etape, 0);
        int stagePos = 0;
        while (stagePos < this.root.getChild(bdcPos).getChildrenCount()) {
            if ((this.root.getChild(bdcPos).getChild(stagePos).getValue(0) == null ? "" : this.root.getChild(bdcPos).getChild(stagePos).getValue(0)).toString() == "STAGE") {
                this.root.getChild(bdcPos).getChild(stagePos).setValue(0, "STEP");
                etape.addChild(this.root.getChild(bdcPos).getChild(stagePos));
                this.root.getChild(bdcPos).remChild(this.root.getChild(bdcPos).getChild(stagePos));
                --stagePos;
            }
            ++stagePos;
        }
        GCell group = new GCell();
        group.addValue("GROUP_NAMES");
        group.addValue(null);
        this.root.getChild(bdcPos).addChild(group, 0);
        int stagePos2 = 0;
        while (stagePos2 < this.root.getChild(bdcPos).getChildrenCount()) {
            if ((this.root.getChild(bdcPos).getChild(stagePos2).getValue(0) == null ? "" : this.root.getChild(bdcPos).getChild(stagePos2).getValue(0)).toString() == "GROUP") {
                group.addChild(this.root.getChild(bdcPos).getChild(stagePos2));
                this.root.getChild(bdcPos).remChild(this.root.getChild(bdcPos).getChild(stagePos2));
                --stagePos2;
            }
            ++stagePos2;
        }
        GCell systemEq = new GCell();
        systemEq.addValue("SYSTEM_NAMES");
        systemEq.addValue(null);
        this.root.getChild(bdcPos).addChild(systemEq, 0);
        int stagePos3 = 0;
        while (stagePos3 < this.root.getChild(bdcPos).getChildrenCount()) {
            if ((this.root.getChild(bdcPos).getChild(stagePos3).getValue(0) == null ? "" : this.root.getChild(bdcPos).getChild(stagePos3).getValue(0)).toString() == "SYSTEM") {
                systemEq.addChild(this.root.getChild(bdcPos).getChild(stagePos3));
                this.root.getChild(bdcPos).remChild(this.root.getChild(bdcPos).getChild(stagePos3));
                --stagePos3;
            }
            ++stagePos3;
        }
    }

    public String printFigaro(String s) {
        this.allCellsAssociations.clear();
        this.allCellsAssociations = this.figParser.parseCode(s, this, this.allCells, this.allCellsAssociations, this.language);
        return "";
    }

    public void resetAssociations() {
        this.allCellsAssociations.clear();
    }

    public ArrayList<GCell> numeroter() {
        this.allCells = new ArrayList();
        this.root.numeroter(0, this.allCells);
        return this.allCells;
    }

    public GCell setFigaroCell(int pos) {
        if (pos >= this.allCellsAssociations.size()) {
            return null;
        }
        System.err.println("Voila la cellule : " + this.allCellsAssociations.get(pos) + " qui est en fait " + this.allCells.get(this.allCellsAssociations.get(pos)).toString());
        this.allCells.get(this.allCellsAssociations.get(pos)).setFigaroSelection(true, false);
        return this.allCells.get(this.allCellsAssociations.get(pos));
    }

    public void unsetFigaroCell(int pos) {
        this.root.setFigaroSelection(false, true);
    }

    public TreePath findPathToSelected(int pos) {
        if (pos >= this.allCellsAssociations.size()) {
            return null;
        }
        return this.allCells.get(this.allCellsAssociations.get(pos)).findPathToSelected();
    }

    public void marquerCell(int pos) {
        if (pos < this.allCellsAssociations.size()) {
            this.allCells.get(this.allCellsAssociations.get(pos)).marqueParent(0);
        }
    }

    public void resetMarqueCell(int pos) {
        if (pos < this.allCellsAssociations.size()) {
            this.allCells.get(this.allCellsAssociations.get(pos)).resetMarque();
        }
    }

    public GTree clone() {
        return new GTree(this.root, this.document, this.allCells, this.allCellsAssociations);
    }

    public Vector<GCell> getFigaroAncestorsChain(GCell c) {
        Vector<Object> tamponVect = new Vector();
        Vector<GCell> parentsVect = new Vector<GCell>();
        System.out.println("On recherche des infos pour : " + c.toString());
        if (c != null) {
            int i = 0;
            while (i < c.getChildrenCount()) {
                GCell fP;
                if (c.getChild(i).getValue(0) != null && c.getChild(i).getValue(0).equals("FATHER") && (fP = this.findFigaroType(c.getChild(i).getChild(0).getValue(1).toString())) != null) {
                    parentsVect.add(fP);
                    tamponVect = this.getFigaroAncestorsChain(fP);
                    int j = 0;
                    while (j < tamponVect.size()) {
                        parentsVect.add((GCell)tamponVect.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return parentsVect;
    }

    public GCell findFigaroType(String name) {
        int i = 0;
        while (i < this.root.getChild(0).getChildrenCount()) {
            int j = 0;
            while (j < this.root.getChild(0).getChild(i).getChildrenCount()) {
                int k = 0;
                while (k < this.root.getChild(0).getChild(i).getChild(j).getChildrenCount()) {
                    if (this.root.getChild(0).getChild(i).getChild(j).getValue(0).toString().equals("NAME") && this.root.getChild(0).getChild(i).getChild(j).getChild(0).getValue(1).toString().equals(name)) {
                        return this.root.getChild(0).getChild(i);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Vector<GCell> findFigaroInterfaces(String typeName) {
        GCell fT = this.findFigaroType(typeName);
        Vector<GCell> interfacesVect = new Vector<GCell>();
        if (fT != null) {
            int i = 0;
            while (i < fT.getChildrenCount()) {
                System.out.println("DIXXXX : " + typeName);
                if (fT.getChild(i).getValue(0).toString().equals("INTERFACE")) {
                    interfacesVect.add(fT.getChild(i));
                }
                ++i;
            }
        }
        return interfacesVect;
    }

    public Vector<GCell> findFigaroSteps() {
        Vector<GCell> stepsVect = new Vector<GCell>();
        int i = 0;
        while (i < this.root.getChild(0).getChildrenCount()) {
            if (this.root.getChild(0).getChild(i).getValue(0).toString().equals("STEP_ORDER")) {
                int j = 0;
                while (j < this.root.getChild(0).getChild(i).getChildrenCount()) {
                    stepsVect.add(this.root.getChild(0).getChild(i).getChild(j));
                    ++j;
                }
            }
            ++i;
        }
        return stepsVect;
    }

    public Vector<GCell> findFigaroGroups() {
        Vector<GCell> groupVect = new Vector<GCell>();
        int i = 0;
        while (i < this.root.getChild(0).getChildrenCount()) {
            if (this.root.getChild(0).getChild(i).getValue(0).toString().equals("GROUP_NAMES")) {
                int j = 0;
                while (j < this.root.getChild(0).getChild(i).getChildrenCount()) {
                    groupVect.add(this.root.getChild(0).getChild(i).getChild(j));
                    ++j;
                }
            }
            ++i;
        }
        return groupVect;
    }

    public String findFigaroNameOfGCell(GCell c) {
        if (c != null) {
            int i = 0;
            while (i < c.getChildrenCount()) {
                if (c.getChild(i).getValue(0) != null && c.getChild(i).getValue(0).equals("NAME")) {
                    int j = 0;
                    while (j < c.getChild(i).getChildrenCount()) {
                        if (c.getChild(i).getChild(j).getValue(1) != null) {
                            return c.getChild(i).getChild(j).getValue(1).toString();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return "";
    }

    public String findFigaroNameOfGCellGroup(GCell c) {
        if (c != null) {
            int i = 0;
            while (i < c.getChildrenCount()) {
                if (c.getChild(i).getValue(0) != null) {
                    return c.getChild(i).getValue(1).toString();
                }
                ++i;
            }
        }
        return "";
    }
}

