/*
 * Decompiled with CFR 0.152.
 */
package figaroParser;

import GLanguage.GLanguage;
import GObjectInformation.GObjectInformation;
import figaroInterface.GCell;
import figaroInterface.GTree;
import java.util.ArrayList;

public class FigaroParser {
    protected GObjectInformation information;
    private ArrayList<Boolean> commentairePosition;
    private GTree gtree;
    private ArrayList<GCell> allCells;
    private ArrayList<Integer> allCellsAssociations;

    public FigaroParser(GTree gtree, ArrayList<GCell> allCells, ArrayList<Integer> allCellsAssociations) {
        this.gtree = gtree;
        this.allCells = allCells;
        this.allCellsAssociations = allCellsAssociations;
    }

    public FigaroParser() {
        this.commentairePosition = new ArrayList();
        this.gtree = null;
        this.allCells = new ArrayList();
        this.allCellsAssociations = new ArrayList();
    }

    public ArrayList<Integer> parseCode(String s, GTree gtree, ArrayList<GCell> allCells, ArrayList<Integer> allCellsAssociations, GLanguage language) {
        this.gtree = gtree;
        this.allCells = allCells;
        this.allCellsAssociations = allCellsAssociations;
        return this.parseCode(s, language);
    }

    private int tokuBetsuMin(int a, int b) {
        if (a < 0) {
            return b;
        }
        if (b < 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private ArrayList<Integer> parseCode(String s, GLanguage language) {
        int indexDepart = 0;
        int indexFin = 0;
        int typeNumero = 0;
        int charJump = "TYPE".length();
        String currentlanguage = new String(language.getLanguage().toString());
        if (currentlanguage.equals("English")) {
            charJump = "CLASS".length();
        }
        this.commentairePosition = new ArrayList(s.length());
        int i = 0;
        while (i < s.length()) {
            this.commentairePosition.add(false);
            ++i;
        }
        this.allCellsAssociations = new ArrayList(s.length());
        i = 0;
        while (i < s.length()) {
            this.allCellsAssociations.add(0);
            ++i;
        }
        this.trouverCommentaire(s);
        while ((indexDepart = this.tokuBetsuMin(this.tokuBetsuMin(s.indexOf("\n" + language.getFigaroTranslation("TYPE") + " ", indexDepart), s.indexOf(" " + language.getFigaroTranslation("TYPE") + " ", indexDepart)), s.indexOf("\t" + language.getFigaroTranslation("TYPE") + " ", indexDepart))) >= 0) {
            int i2;
            if (this.commentairePosition.get(indexDepart).booleanValue()) {
                indexDepart += charJump;
                continue;
            }
            indexFin = indexDepart + charJump;
            ++indexDepart;
            while ((indexFin = this.tokuBetsuMin(this.tokuBetsuMin(s.indexOf("\n" + language.getFigaroTranslation("TYPE") + " ", indexFin), s.indexOf(" " + language.getFigaroTranslation("TYPE") + " ", indexFin)), s.indexOf("\t" + language.getFigaroTranslation("TYPE") + " ", indexFin))) > 0) {
                if (!this.commentairePosition.get(indexFin).booleanValue()) break;
                indexFin += charJump;
            }
            ++indexFin;
            GCell cell = this.trouverIemeType(typeNumero);
            if (cell == null) {
                System.err.println("The cell is null");
                return null;
            }
            if (indexFin <= 0) {
                i2 = indexDepart;
                while (i2 < this.commentairePosition.size()) {
                    this.allCellsAssociations.set(i2, cell.getUID());
                    ++i2;
                }
                break;
            }
            if (indexFin > this.commentairePosition.size()) {
                indexFin = this.commentairePosition.size();
            }
            i2 = indexDepart;
            while (i2 < indexFin) {
                this.allCellsAssociations.set(i2, cell.getUID());
                ++i2;
            }
            indexDepart = indexFin - 1;
            ++typeNumero;
        }
        return this.allCellsAssociations;
    }

    private GCell trouverIemeType(int pos) {
        int searchPos = 0;
        int nbChild = this.gtree.getRoot().getChild(0).getChildrenCount();
        int i = 0;
        while (i < nbChild) {
            if (this.gtree.getRoot().getChild(0).getChild(i).getValue(0).toString().equals("CLASS")) {
                if (searchPos == pos) {
                    return this.gtree.getRoot().getChild(0).getChild(i);
                }
                ++searchPos;
            }
            ++i;
        }
        return null;
    }

    private boolean trouverCommentaire(String s) {
        int indexDepart = 0;
        int indexFin = 0;
        while ((indexDepart = s.indexOf("(*", indexDepart)) >= 0) {
            int i;
            indexFin = s.indexOf("*)", indexDepart + 2);
            if (indexFin < 0) {
                i = indexDepart;
                while (i < this.commentairePosition.size()) {
                    this.commentairePosition.set(i, true);
                    ++i;
                }
                return true;
            }
            if (indexFin > this.commentairePosition.size()) {
                indexFin = this.commentairePosition.size();
            }
            i = indexDepart;
            while (i < indexFin) {
                this.commentairePosition.set(i, true);
                ++i;
            }
            indexDepart = indexFin + 2;
        }
        return true;
    }

    public ArrayList<GCell> getAllCells() {
        return this.allCells;
    }

    public ArrayList<Integer> getAllCellsAssociations() {
        return this.allCellsAssociations;
    }

    public ArrayList<Boolean> getCommentairePosition() {
        return this.commentairePosition;
    }

    public GTree getGtree() {
        return this.gtree;
    }

    public void setAllCells(ArrayList<GCell> allCells) {
        this.allCells = allCells;
    }

    public void setAllCellsAssociations(ArrayList<Integer> allCellsAssociations) {
        this.allCellsAssociations = allCellsAssociations;
    }

    public void setCommentairePosition(ArrayList<Boolean> commentairePosition) {
        this.commentairePosition = commentairePosition;
    }

    public void setGtree(GTree gtree) {
        this.gtree = gtree;
    }
}

