/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image;

import com.ctreber.aclib.codec.AbstractDecoder;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamDecoder
extends AbstractDecoder {
    private final ImageInputStream _stream;

    public ImageInputStreamDecoder(ImageInputStream imageInputStream) {
        this._stream = imageInputStream;
    }

    public void seek(long l) throws IOException {
        this._stream.seek(l);
    }

    public byte[] readBytes(long l, byte[] byArray) throws IOException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[(int)l];
        } else if ((long)byArray2.length < l) {
            throw new IllegalArgumentException("Insufficient space in buffer");
        }
        int n = this._stream.read(byArray, 0, (int)l);
        if ((long)n != l) {
            throw new IOException("Tried to read " + l + " bytes, but obtained " + n);
        }
        this._pos += l;
        return byArray2;
    }

    public void close() throws IOException {
        this._stream.close();
    }
}

