/*
 * Decompiled with CFR 0.152.
 */
package Factories;

import GFilters.GFilterTagName;
import GXSDOperations.GXSDOperations;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GXMLElementFactory {
    public static Vector<Element> refactorElement(Element e, String xk) {
        Vector<Element> bufferVector = new Vector<Element>();
        if (e == null) {
            System.err.println("Dummy element for " + xk);
            Element element = new Element(xk);
            element.removeContent();
            bufferVector.add(element);
        } else if (e.getName().equals(xk)) {
            System.out.println("The element " + xk + "is at top level");
            bufferVector.add((Element)e.detach());
        } else {
            Iterator iter = e.getDescendants((Filter)new GFilterTagName(xk));
            if (iter.hasNext()) {
                System.out.println("We finally found an element for " + xk + " in descendants");
                bufferVector.add((Element)iter.next());
            } else {
                System.err.println("Dummy element for " + xk);
                Element element = new Element(xk);
                element.removeContent();
                bufferVector.add(element);
            }
        }
        return bufferVector;
    }

    public static Vector<Element> refactorElements(Vector<Element> e, String xk) {
        Vector<Element> bufferVector = new Vector<Element>();
        if (e == null) {
            Element element = new Element(xk);
            element.setAttribute("dummy", "");
            bufferVector.add(element);
        } else if (e.size() == 0) {
            Element element = new Element(xk);
            element.setAttribute("dummy", "");
            bufferVector.add(element);
        } else {
            boolean elementFound = false;
            for (Element element : e) {
                if (element == null) continue;
                if (element.getName().equals(xk)) {
                    bufferVector.add(element);
                    elementFound = true;
                    continue;
                }
                Iterator descendantIterator = element.getDescendants((Filter)new GFilterTagName(xk));
                if (!descendantIterator.hasNext()) continue;
                while (descendantIterator.hasNext()) {
                    bufferVector.add((Element)descendantIterator.next());
                }
                elementFound = true;
            }
            if (!elementFound) {
                Element element;
                element = new Element(xk);
                element.setAttribute("dummy", "");
                bufferVector.add(element);
            }
        }
        return bufferVector;
    }

    public static Vector<Element> refactorElementsOnlyChildren(Vector<Element> e, String xk) {
        Vector<Element> bufferVector = new Vector<Element>();
        if (e == null) {
            Element element = new Element(xk);
            element.setAttribute("dummy", "");
            bufferVector.add(element);
        } else if (e.size() == 0) {
            Element element = new Element(xk);
            element.setAttribute("dummy", "");
            bufferVector.add(element);
        } else {
            boolean elementFound = false;
            for (Element element : e) {
                if (element == null) continue;
                if (element.getName().equals(xk)) {
                    bufferVector.add(element);
                    elementFound = true;
                    continue;
                }
                Vector children = new Vector(element.getChildren(xk));
                if (children.size() > 0) {
                    elementFound = true;
                }
                Iterator childrenIter = children.iterator();
                while (childrenIter.hasNext()) {
                    bufferVector.add((Element)childrenIter.next());
                }
            }
            if (!elementFound) {
                Element element;
                element = new Element(xk);
                element.setAttribute("dummy", "");
                bufferVector.add(element);
            }
        }
        return bufferVector;
    }

    public static boolean saveElement(Element root, Element child) {
        Vector<Element> childVect = new Vector<Element>();
        childVect.add(child);
        return GXMLElementFactory.saveElements(root, childVect);
    }

    public static boolean saveElements(Element root, Vector<Element> children) {
        if (root == null) {
            return false;
        }
        if (children == null) {
            return false;
        }
        int minCardinality = 0;
        block4: for (Element child : children) {
            minCardinality = GXSDOperations.getMinimumCardinality(root.getName(), child.getName());
            switch (minCardinality) {
                case -1: {
                    break;
                }
                case 0: {
                    if (child.getChildren().size() <= 0 && child.getAttributes().size() <= 0 && child.getText().equals("")) continue block4;
                    root.addContent((Content)child);
                    break;
                }
                default: {
                    root.addContent((Content)child);
                }
            }
        }
        return true;
    }
}

