/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import Factories.GWindowFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import GWindow.GWindow;
import global.Messages;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import org.jdom.Element;

public class GWidgetColorChooser
extends GWidget {
    private static final long serialVersionUID = 1L;
    private JButton buttonfield;
    private JButton resetbutton;
    private String xmlKeyword;

    public GWidgetColorChooser() {
        this.initialization();
    }

    public GWidgetColorChooser(GObject p, GObjectInformation info) {
        super(p, info);
        this.initialization();
    }

    private void initialization() {
        this.xmlKeyword = null;
        this.setLayout(new BorderLayout());
        this.buttonfield = new JButton();
        this.add((Component)this.buttonfield, "Center");
        this.buttonfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWidgetColorChooser.this.translateMessage(new GMessage(GWidgetColorChooser.this.information, Messages.SELECTCOLOR));
            }
        });
        this.resetbutton = new JButton("X");
        this.add((Component)this.resetbutton, "East");
        this.resetbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWidgetColorChooser.this.translateMessage(new GMessage(GWidgetColorChooser.this.information, Messages.RESETCOLOR));
            }
        });
    }

    @Override
    public void translateMessage(GMessage message) {
        GWindow window = null;
        switch (message.getMessage()) {
            case SELECTCOLOR: {
                window = GWindowFactory.createWindow(WindowClasses.COLORCHOOSER, this, this.information, new Object[]{this.buttonfield.getText()});
                window.setVisible(true);
                window.setAlwaysOnTop(true);
                break;
            }
            case RESETCOLOR: {
                this.buttonfield.setText("Empty");
                this.buttonfield.setBackground(new Color(255, 255, 255));
                break;
            }
            case REPLACEDEFAULTVALUES: {
                System.out.println("REPLACEMENT REQUIERED");
                if (message.getArguments() == null) {
                    this.buttonfield.setText("Empty");
                    this.buttonfield.setBackground(new Color(255, 255, 255));
                    return;
                }
                this.loadColorFromString(message.getArguments().get(0).toString());
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWidgetColorChooser : Message not handled");
            }
        }
    }

    public void loadColorFromString(String colorString) {
        if (colorString.length() != 6) {
            this.buttonfield.setText("Empty");
            this.buttonfield.setBackground(new Color(255, 255, 255));
        } else {
            try {
                int r = Integer.parseInt(colorString.substring(0, 2), 16);
                int g = Integer.parseInt(colorString.substring(2, 4), 16);
                int b = Integer.parseInt(colorString.substring(4, 6), 16);
                this.buttonfield.setText(colorString);
                this.buttonfield.setBackground(new Color(r, g, b));
            }
            catch (Exception e) {
                this.buttonfield.setText("Empty");
                this.buttonfield.setBackground(new Color(255, 255, 255));
            }
        }
    }

    @Override
    public boolean loadXML(Vector<Element> e, boolean deeplyRooted) {
        if (e == null) {
            return false;
        }
        if (e.size() <= 0) {
            return false;
        }
        this.xmlKeyword = e.get(0).getName();
        this.loadColorFromString(e.get(0).getText());
        System.out.println("TEXTFIELD : " + this.xmlKeyword);
        return true;
    }

    @Override
    public Vector<Element> saveXML() {
        if (this.xmlKeyword == null || this.buttonfield.getText().equals("Empty")) {
            return null;
        }
        Vector<Element> resultVector = new Vector<Element>();
        Element result = new Element(this.xmlKeyword);
        result.setText(this.buttonfield.getText());
        resultVector.add(result);
        return resultVector;
    }

    public Vector<Element> saveXML(String nom) {
        this.xmlKeyword = this.information.getLanguage().getBDCTranslation("NOM");
        Vector<Element> resultVector = new Vector<Element>();
        Element result = new Element(this.xmlKeyword);
        result.setText(this.buttonfield.getText());
        resultVector.add(result);
        return resultVector;
    }
}

