/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import GXSDOperations.GXSDOperations;
import global.Messages;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import org.jdom.Element;

public class GWidgetComboBox
extends GWidget {
    private static final long serialVersionUID = 1L;
    JComboBox comboBox;
    String xmlKeyword;
    Vector<String> values;

    public GWidgetComboBox() {
        this.initialization();
    }

    public GWidgetComboBox(GObject p, GObjectInformation info, Vector<String> args) {
        super(p, info);
        this.initialization();
        if (args != null) {
            this.setAcceptedValues(args);
        }
    }

    private void initialization() {
        this.xmlKeyword = null;
        this.values = new Vector();
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GWidgetComboBox.this.comboBox.getSelectedIndex() >= 0) {
                    Vector<Object> args = new Vector<Object>();
                    args.add(GWidgetComboBox.this.comboBox.getSelectedItem().toString());
                    GMessage message = new GMessage(GWidgetComboBox.this.information, Messages.NOTIFYCHANGE, args);
                    GWidgetComboBox.this.parent.translateMessage(message);
                }
            }
        });
        this.add(this.comboBox);
    }

    public void setAcceptedValues(Vector<String> acceptedValues) {
        this.values.clear();
        this.values.addAll(acceptedValues);
        this.comboBox.removeAllItems();
        Iterator<String> iter = acceptedValues.iterator();
        while (iter.hasNext()) {
            this.comboBox.addItem(iter.next());
        }
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case ADDDEFAULTVALUES: {
                if (message.getArguments() == null) {
                    return;
                }
                if (message.getArguments().size() < 1) {
                    return;
                }
                for (Object obj : message.getArguments()) {
                    this.comboBox.addItem(obj.toString());
                }
                break;
            }
            case REPLACEDEFAULTVALUES: {
                System.out.println("REPLACEMENT REQUIERED");
                if (message.getArguments() == null) {
                    return;
                }
                this.comboBox.removeAllItems();
                for (Object obj : message.getArguments()) {
                    this.comboBox.addItem(obj.toString());
                }
                break;
            }
            case SETMODIFIABLE: {
                if (message.getArguments() == null) {
                    return;
                }
                if (message.getArguments().size() <= 0) {
                    return;
                }
                this.comboBox.setEnabled((Boolean)message.getArguments().get(0));
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWidgetComboBox : Message not handled");
            }
        }
    }

    @Override
    public boolean loadXML(Vector<Element> e, boolean deeplyRooted) {
        if (e == null) {
            return false;
        }
        if (e.size() <= 0) {
            return false;
        }
        if (e.get(0) == null) {
            return false;
        }
        this.xmlKeyword = e.get(0).getName();
        Vector<String> allowedValues = GXSDOperations.getAllowedValuesForNode(this.xmlKeyword);
        if (allowedValues != null && allowedValues.size() > 0) {
            this.comboBox.removeAllItems();
            Iterator<String> iter = allowedValues.iterator();
            while (iter.hasNext()) {
                this.comboBox.addItem(iter.next());
            }
        }
        this.comboBox.setSelectedItem(e.get(0).getText());
        return true;
    }

    @Override
    public Vector<Element> saveXML() {
        if (this.xmlKeyword == null || this.comboBox.getSelectedIndex() < 0) {
            return null;
        }
        Vector<Element> resultVector = new Vector<Element>();
        Element result = new Element(this.xmlKeyword);
        result.setText(this.comboBox.getSelectedItem().toString());
        resultVector.add(result);
        return resultVector;
    }
}

