/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import Factories.GNameRetrieverFactory;
import Factories.GWindowFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import GWidget.GWidgetAddDel;
import GWidget.GWidgetAddDelEdit;
import GWidget.GWidgetAddDelUpDown;
import GWidget.GWidgetControl;
import GWidget.GWidgetList;
import GWidget.GWidgetListComplexArray;
import GWidget.GWidgetListSimpleArray;
import GWidget.GWidgetNodeLinkNeitherUpDownEdit;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WindowClasses;
import global.WindowTypes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdom.Element;

public class GWidgetControledList
extends GWidget {
    private static final long serialVersionUID = 1L;
    private GWidgetList list;
    private GWidgetControl control;
    private WindowClasses interactionWindow;
    private Object windowArguments;
    private NameRetrieverClasses nameRetriever;
    private boolean deeplyRooted = false;
    private String rootName = "";
    private boolean isEditable;

    public GWidgetControledList() {
        this.windowArguments = null;
        this.isEditable = false;
    }

    public GWidgetControledList(GObject p, GObjectInformation info, String name, Vector<String> initializationList, ListTypes listType, NameRetrieverClasses nr, ControlTypes controlType, WindowClasses windowClass, Object windowArgument) {
        super(p, info);
        this.windowArguments = windowArgument;
        this.isEditable = false;
        this.interactionWindow = windowClass;
        this.nameRetriever = nr;
        this.setLayout(new BorderLayout());
        switch (listType) {
            case COMPLEXARRAY: {
                System.out.println("Name retriever : " + this.nameRetriever.toString());
                this.setList(new GWidgetListComplexArray(this, info, null, GNameRetrieverFactory.createNameRetriever(this.information.getLanguage(), this.nameRetriever)));
                System.out.println("Nombre d'element" + this.getList().listGetNumberOfElement());
                break;
            }
            case SIMPLEARRAY: {
                System.out.println("Name retriever : " + this.nameRetriever.toString());
                this.setList(new GWidgetListSimpleArray(this, info, null, GNameRetrieverFactory.createNameRetriever(this.information.getLanguage(), this.nameRetriever)));
                System.out.println("Nombre d'element" + this.getList().listGetNumberOfElement());
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWidgetControledList : The list parameter is false");
            }
        }
        switch (controlType) {
            case ADDDEL: {
                this.control = new GWidgetAddDel(this, this.information);
                break;
            }
            case ADDDELEDIT: {
                this.control = new GWidgetAddDelEdit(this, this.information);
                this.isEditable = true;
                break;
            }
            case ADDDELUPDOWN: {
                this.control = new GWidgetAddDelUpDown(this, this.information);
                break;
            }
            case NODELINKNEITHERUPDOWNEDIT: {
                this.isEditable = true;
                this.control = new GWidgetNodeLinkNeitherUpDownEdit(this, info);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWidgetControledList : The control parameter is wrong");
            }
        }
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.add((Component)this.control, "North");
        this.add((Component)this.getList(), "Center");
        this.add((Component)controlPanel, "East");
        if (name != null && name.length() > 0) {
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            this.setBorder(BorderFactory.createTitledBorder(blackLine, name, 1, 0, null));
        }
        if (initializationList != null && initializationList.size() > 0) {
            this.getList().initializeWithString(initializationList);
        }
    }

    @Override
    public void translateMessage(GMessage message) {
        GWindow window = null;
        block0 : switch (message.getMessage()) {
            case ADD: {
                System.err.println("ADD : windowARg : " + this.windowArguments);
                window = this.windowArguments == null ? GWindowFactory.createWindow(this.interactionWindow, this, this.information, new Object[]{-1}) : GWindowFactory.createWindow(this.interactionWindow, this, this.information, new Object[]{-1, this.windowArguments});
                window.setVisible(true);
                window.setAlwaysOnTop(true);
                System.out.println("ADD");
                break;
            }
            case DEL: {
                this.getList().listDeleteElement(this.getList().listGetSelectedIndex());
                System.out.println("DEL");
                this.parent.translateMessage(new GMessage(this.information, Messages.NOTIFYCHANGE, "DEL"));
                break;
            }
            case EDIT: {
                if (this.isEditable) {
                    if (this.interactionWindow != null) {
                        window = this.windowArguments == null ? GWindowFactory.createWindow(this.interactionWindow, this, this.information, new Object[]{this.getList().listGetSelectedIndex(), this.getList().listGetElement(this.getList().listGetSelectedIndex())}) : GWindowFactory.createWindow(this.interactionWindow, this, this.information, new Object[]{this.getList().listGetSelectedIndex(), this.getList().listGetElement(this.getList().listGetSelectedIndex()), this.windowArguments});
                    } else {
                        String listSelectedString = this.getList().listGetString(this.getList().listGetSelectedIndex());
                        int indexOfColon = listSelectedString.indexOf(" : ");
                        if (indexOfColon >= 0) {
                            if (listSelectedString.substring(0, indexOfColon).equals("NODE")) {
                                this.translateMessage(new GMessage(this.information, Messages.NODE));
                            } else if (listSelectedString.substring(0, indexOfColon).equals("LINK")) {
                                this.translateMessage(new GMessage(this.information, Messages.LINK));
                            } else {
                                window = null;
                            }
                        } else {
                            Object[] options = new Object[]{"Node", "Link", "Cancel"};
                            int result = JOptionPane.showOptionDialog(this, "The current classes is not categorized. Do you want to open the node or the link window?", "Type Choice", 1, 2, null, options, options[2]);
                            switch (result) {
                                case 0: {
                                    this.translateMessage(new GMessage(this.information, Messages.NODE));
                                    break;
                                }
                                case 1: {
                                    this.translateMessage(new GMessage(this.information, Messages.LINK));
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                default: {
                                    System.err.println("VisualFigaro : GWidgetControledList : Unexpected message.");
                                }
                            }
                        }
                    }
                    if (window != null) {
                        window.setVisible(true);
                        window.setAlwaysOnTop(true);
                    }
                }
                System.out.println("EDIT");
                break;
            }
            case UP: {
                this.getList().listMoveUp();
                System.out.println("UP");
                break;
            }
            case DOWN: {
                this.getList().listMoveDown();
                System.out.println("DOWN");
                break;
            }
            case ADDELEMENT: {
                if ((Integer)message.getArguments().get(0) == -1) {
                    this.getList().listAddElement((Element)message.getArguments().get(1));
                } else {
                    this.getList().listReplaceElement((Integer)message.getArguments().get(0), (Element)message.getArguments().get(1));
                }
                this.parent.translateMessage(new GMessage(this.information, Messages.NOTIFYCHANGE, "ADD"));
                break;
            }
            case ADDSIMPLEELEMENT: {
                if ((Integer)message.getArguments().get(0) == -1) {
                    this.getList().listAddElement((Element)message.getArguments().get(1));
                } else {
                    this.getList().listReplaceElement((Integer)message.getArguments().get(0), (Element)message.getArguments().get(1));
                }
                this.parent.translateMessage(new GMessage(this.information, Messages.NOTIFYCHANGE, "ADD"));
                break;
            }
            case NODE: {
                if (this.getList().listGetSelectedIndex() < 0) {
                    return;
                }
                String listSelectedString = this.getList().listGetString(this.getList().listGetSelectedIndex());
                int indexOfColon = listSelectedString.indexOf(" : ");
                if (indexOfColon >= 0 && listSelectedString.substring(0, indexOfColon).equals("LINK")) {
                    Object[] options = new Object[]{"Open as Node", "Open as Link", "Cancel"};
                    int result = JOptionPane.showOptionDialog(this, "The current type is Link but the action performed will open the Node perspective.\nIf you open the window as a Node you will loose all information associated with the Link.\nWhat do you want to do?", "Type Choice", 1, 2, null, options, options[2]);
                    switch (result) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.translateMessage(new GMessage(this.information, Messages.LINK));
                            return;
                        }
                        case 2: {
                            return;
                        }
                    }
                }
                this.getList().listGetElement(this.getList().listGetSelectedIndex());
                GObjectInformation windowNodeInformation = new GObjectInformation(this.information);
                if (this.getList().listGetString(this.getList().listGetSelectedIndex()).indexOf(" : ") >= 0) {
                    windowNodeInformation.setTypeConcerned(this.getList().listGetString(this.getList().listGetSelectedIndex()).substring(this.getList().listGetString(this.getList().listGetSelectedIndex()).indexOf(" : ") + 3, this.getList().listGetString(this.getList().listGetSelectedIndex()).length()));
                    windowNodeInformation.setType(WindowTypes.NODE);
                } else {
                    windowNodeInformation.setTypeConcerned(this.getList().listGetString(this.getList().listGetSelectedIndex()));
                }
                String typeName = listSelectedString.substring(indexOfColon + 3, listSelectedString.length());
                window = GWindowFactory.createWindow(WindowClasses.NODE, this, windowNodeInformation, new Object[]{this.getList().listGetSelectedIndex(), this.getList().listGetElement(this.getList().listGetElement(typeName))});
                window.setVisible(true);
                window.setAlwaysOnTop(true);
                System.out.println("NODE");
                break;
            }
            case NODEMODIFICATION: {
                this.getList().listReplaceElement((Integer)message.getArguments().get(0), (Element)message.getArguments().get(1));
                break;
            }
            case LINK: {
                if (this.getList().listGetSelectedIndex() < 0) {
                    return;
                }
                String listSelectedString = this.getList().listGetString(this.getList().listGetSelectedIndex());
                int indexOfColon = listSelectedString.indexOf(" : ");
                if (indexOfColon >= 0 && listSelectedString.substring(0, indexOfColon).equals("NODE")) {
                    Object[] options = new Object[]{"Open as Node", "Open as Link", "Cancel"};
                    int result = JOptionPane.showOptionDialog(this, "The current type is Node but the action performed will open the Link perspective.\nIf you open the window as a Link you will loose all information associated with the Node.\nWhat do you want to do?", "Type Choice", 1, 2, null, options, options[2]);
                    switch (result) {
                        case 0: {
                            this.translateMessage(new GMessage(this.information, Messages.NODE));
                            return;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                }
                this.getList().listGetElement(this.getList().listGetSelectedIndex());
                GObjectInformation windowLinkInformation = new GObjectInformation(this.information);
                if (this.getList().listGetString(this.getList().listGetSelectedIndex()).indexOf(" : ") >= 0) {
                    windowLinkInformation.setTypeConcerned(this.getList().listGetString(this.getList().listGetSelectedIndex()).substring(this.getList().listGetString(this.getList().listGetSelectedIndex()).indexOf(" : ") + 3, this.getList().listGetString(this.getList().listGetSelectedIndex()).length()));
                    windowLinkInformation.setType(WindowTypes.LINK);
                } else {
                    windowLinkInformation.setTypeConcerned(this.getList().listGetString(this.getList().listGetSelectedIndex()));
                }
                String typeName = listSelectedString.substring(indexOfColon + 3, listSelectedString.length());
                window = GWindowFactory.createWindow(WindowClasses.LINK, this, windowLinkInformation, new Object[]{this.getList().listGetSelectedIndex(), this.getList().listGetString(this.getList().listGetSelectedIndex()), this.getList().listGetElement(this.getList().listGetElement(typeName))});
                window.setVisible(true);
                window.setAlwaysOnTop(true);
                System.out.println("LINK");
                break;
            }
            case LINKMODIFICATION: {
                this.getList().listReplaceElement((Integer)message.getArguments().get(0), (Element)message.getArguments().get(1));
                break;
            }
            case NEITHER: {
                String listSelectedString = this.getList().listGetString(this.getList().listGetSelectedIndex());
                int indexOfColon = listSelectedString.indexOf(" : ");
                String typeName = listSelectedString.substring(indexOfColon + 3, listSelectedString.length());
                if (indexOfColon < 0) break;
                int position = 0;
                while (position < this.getList().listGetNumberOfElement() - 1) {
                    Element element = this.getList().listGetElement(position);
                    if (element != null && element.getChildText("NOM").equals(typeName)) {
                        element.setName(typeName);
                        this.getList().listReplaceElementBis(this.getList().listGetSelectedIndex(), element);
                        this.getList().DeleteXMLvalues(typeName);
                        break block0;
                    }
                    ++position;
                }
                break;
            }
            case SETWINDOWARGUMENTS: {
                this.windowArguments = message.getArguments().get(0);
                System.err.println("Argument : " + this.windowArguments);
                break;
            }
            case NOTIFYCHANGE: {
                this.parent.translateMessage(message);
            }
            default: {
                System.out.println("-1");
            }
        }
    }

    @Override
    public boolean loadXML(Vector<Element> elements, boolean d) {
        this.deeplyRooted = d;
        if (this.deeplyRooted) {
            this.rootName = elements.get(0).getName();
            return this.getList().loadXML(new Vector<Element>(elements.get(0).getChildren()), false);
        }
        return this.getList().loadXML(elements, false);
    }

    @Override
    public Vector<Element> saveXML() {
        try {
            if (this.deeplyRooted) {
                Vector<Element> bufferVector = new Vector<Element>();
                bufferVector.add(new Element(this.rootName).addContent(this.getList().saveXML()));
                return bufferVector;
            }
            return this.getList().saveXML();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception : " + e);
            return null;
        }
    }

    public int GetNumberOfElement() {
        return this.getList().listGetNumberOfElement();
    }

    public void setList(GWidgetList list) {
        this.list = list;
    }

    public GWidgetList getList() {
        return this.list;
    }
}

