/*
 * Decompiled with CFR 0.152.
 */
package GWidget;

import GIcon.GIcon;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidget;
import GWindow.GWindowShowIcon;
import global.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.jdom.Element;

public class GWidgetLoadIcon
extends GWidget {
    private static final long serialVersionUID = 1L;
    private Image image;
    private JButton chooseButton;
    private JButton editButton;

    public GWidgetLoadIcon() {
        this.image = null;
        this.initialization();
    }

    public GWidgetLoadIcon(GObject p, GObjectInformation info, Image img) {
        super(p, info);
        if (img != null) {
            this.image = img;
        }
        this.initialization();
    }

    private void initialization() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel gridPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.chooseButton = new JButton("Choose New Icon");
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWidgetLoadIcon.this.showFileChooser();
            }
        });
        gridPanel.add(this.chooseButton);
        this.editButton = new JButton("Choose Existing Icon");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWidgetLoadIcon.this.showIconChooser();
            }
        });
        gridPanel.add(this.editButton);
        rightPanel.add((Component)gridPanel, "East");
        constraints.gridx = 1;
        this.add((Component)rightPanel, constraints);
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        this.setBorder(BorderFactory.createTitledBorder(blackLine, "Icon", 1, 0, null));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        Dimension imageDimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        Point origin = new Point(this.getWidth() / 4 - imageDimension.width / 2, (this.getHeight() - imageDimension.height) / 2 + imageDimension.height);
        if (g != null) {
            g.setColor(Color.BLACK);
            g.drawImage(this.image, origin.x, origin.y - imageDimension.height, imageDimension.width, imageDimension.height, this);
            g.drawRect(origin.x, origin.y - imageDimension.height, imageDimension.width, imageDimension.height);
        } else {
            System.err.println("VisualFigaro : GWidgetLoadIcon : Graphics Error");
        }
    }

    public void showFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        int returnValue = fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            this.parent.translateMessage(new GMessage(this.information, Messages.ICONCHOOSED, new GIcon(fileChooser.getSelectedFile().getAbsolutePath(), true)));
        }
    }

    public void showFileChooser(String path) {
        JFileChooser fileChooser = new JFileChooser(path);
        class MyFilter
        extends FileFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(".sym");
            }

            @Override
            public String getDescription() {
                return "*.sym";
            }
        }
        fileChooser.addChoosableFileFilter(new MyFilter());
        int returnValue = fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            this.parent.translateMessage(new GMessage(this.information, Messages.ICONCHOOSED, new GIcon(fileChooser.getSelectedFile().getAbsolutePath(), false)));
        }
    }

    public void showIconChooser() {
        String parentname = this.parent.getClass().toString();
        if ((parentname = parentname.substring(parentname.indexOf(".") + 1, parentname.length())).equals("GWindowVarNode")) {
            this.showFileChooser(String.valueOf(this.information.getKnowledgeBasePath()) + "\\icons\\");
        } else {
            GWindowShowIcon showIconWindow = new GWindowShowIcon(this, this.information);
            showIconWindow.setModal(true);
            showIconWindow.setAlwaysOnTop(true);
            showIconWindow.setVisible(true);
            if (!showIconWindow.getSelectedIcon().equals("")) {
                this.parent.translateMessage(new GMessage(this.information, Messages.ICONCHOOSED, new GIcon(showIconWindow.getSelectedIcon(), false)));
            }
        }
    }

    @Override
    public void translateMessage(GMessage message) {
    }

    @Override
    public boolean loadXML(Vector<Element> e, boolean deeplyRooted) {
        if (e == null) {
            return false;
        }
        return e.size() > 0;
    }

    @Override
    public Vector<Element> saveXML() {
        return null;
    }
}

