/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import global.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.jdom.Element;

public class GWindowColorChooser
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JPanel framePanel;
    private JPanel logoPanel;
    private JColorChooser jcc;
    private GWidgetOKCancel okCancelWidget;

    public GWindowColorChooser(GObject p, GObjectInformation info, String strColor) {
        super(p, info);
        Color defColor = this.createColorFromString(strColor);
        this.framePanel = new JPanel(new BorderLayout());
        this.jcc = defColor != null ? new JColorChooser(defColor) : new JColorChooser();
        this.jcc.setPreviewPanel(new JPanel());
        AbstractColorChooserPanel[] oldPanels = this.jcc.getChooserPanels();
        this.jcc.removeChooserPanel(oldPanels[4]);
        this.jcc.removeChooserPanel(oldPanels[2]);
        this.jcc.removeChooserPanel(oldPanels[1]);
        Component[] list = oldPanels[3].getComponents();
        JPanel pane = (JPanel)list[0];
        pane.remove(14);
        pane.remove(13);
        pane.remove(9);
        pane.remove(8);
        pane.remove(3);
        Component[] cmp = oldPanels[0].getComponents();
        JPanel panel = (JPanel)cmp[0];
        panel.remove(2);
        panel.remove(1);
        this.framePanel.add((Component)this.jcc, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.setSize(600, 400);
        this.setResizable(false);
        this.setTitle("Choose a color");
    }

    private Color createColorFromString(String strColor) {
        Color col = null;
        if (!strColor.equals("Empty") && strColor.length() == 6) {
            try {
                int r = Integer.parseInt(strColor.substring(0, 2), 16);
                int g = Integer.parseInt(strColor.substring(2, 4), 16);
                int b = Integer.parseInt(strColor.substring(4, 6), 16);
                col = new Color(r, g, b);
            }
            catch (Exception e) {
                System.out.println("Erreur : " + e);
            }
        }
        return col;
    }

    private String createStringFromColor() {
        String res = "Empty";
        try {
            String interm3;
            String interm2;
            Color newColor = this.jcc.getColor();
            String interm1 = Integer.toHexString(newColor.getRed());
            if (interm1.length() < 2) {
                interm1 = "0" + interm1;
            }
            if ((interm2 = Integer.toHexString(newColor.getGreen())).length() < 2) {
                interm2 = "0" + interm2;
            }
            if ((interm3 = Integer.toHexString(newColor.getBlue())).length() < 2) {
                interm3 = "0" + interm3;
            }
            res = String.valueOf(interm1) + interm2 + interm3;
            res = res.toUpperCase();
        }
        catch (Exception e) {
            System.out.println("Erreur : " + e);
        }
        return res;
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                String strColor = this.createStringFromColor();
                this.parent.translateMessage(new GMessage(this.information, Messages.REPLACEDEFAULTVALUES, new Object[]{strColor}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowColorChooser : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        return null;
    }

    @Override
    public void loadXml(Element e) {
    }
}

