/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import org.jdom.Element;

public class GWindowConnection
extends GWindow {
    private static final long serialVersionUID = 1L;
    private GWidgetGridForm gridForm;
    private JPanel listsPanel;
    GWidgetControledList nodeInterfacesFilledByLinkList;
    GWidgetControledList linkInterfacesFilledByNodeList;
    private GWidgetOKCancel okCancelWidget;
    private int position;

    @Deprecated
    public GWindowConnection(GObject p, GObjectInformation info) {
        super(p, info);
    }

    public GWindowConnection(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.initialization();
    }

    private void initialization() {
        this.initializeFieldsPanel();
        this.framePanel.add((Component)this.gridForm, "North");
        this.initializeListPanel();
        this.framePanel.add((Component)this.listsPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Connection");
        this.loadXml(null);
    }

    public void initializeFieldsPanel() {
        Vector<String> labels = new Vector<String>();
        labels.add("Name :");
        labels.add("Link :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        Vector<String> name = new Vector<String>();
        name.add("DEPART");
        name.add("ARRIVEE");
        objectArgs.add(name);
        Vector<String> values = new Vector<String>();
        values.addAll(xmlLoader.findLinks());
        boolean figaro = false;
        int i = 0;
        while (i < values.size()) {
            if (values.get(i).equals("FIGARO")) {
                figaro = true;
            }
            ++i;
        }
        if (!figaro) {
            values.add("FIGARO");
        }
        objectArgs.add(values);
        this.gridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, objectArgs);
    }

    public void initializeListPanel() {
        this.listsPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        this.nodeInterfacesFilledByLinkList = new GWidgetControledList(this, this.information, "Interface of the node filled by the link", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.INTERFACE, this.information.getTypeConcerned());
        this.listsPanel.add(this.nodeInterfacesFilledByLinkList);
        this.linkInterfacesFilledByNodeList = new GWidgetControledList(this, this.information, "Interface of the link filled by the node", null, ListTypes.COMPLEXARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDELEDIT, WindowClasses.INTERFACE, null);
        this.listsPanel.add(this.linkInterfacesFilledByNodeList);
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case NOTIFYCHANGE: {
                if (message.getArguments().get(0) == null || this.linkInterfacesFilledByNodeList == null && this.nodeInterfacesFilledByLinkList == null) break;
                String selectedItem = (String)message.getArguments().get(0);
                int emiter = -1;
                try {
                    emiter = Integer.parseInt(message.getSender().getLastPartOfThePath());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (emiter != 1) break;
                System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                message = new GMessage(this.information, Messages.SETWINDOWARGUMENTS, selectedItem);
                this.linkInterfacesFilledByNodeList.translateMessage(message);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("CONNEXION_ACCEPTEE"));
        GXMLElementFactory.saveElements(this.root, this.gridForm.saveXML());
        GXMLElementFactory.saveElements(this.root, this.nodeInterfacesFilledByLinkList.saveXML());
        GXMLElementFactory.saveElements(this.root, this.linkInterfacesFilledByNodeList.saveXML());
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        Vector<Element> fieldsLoad = new Vector<Element>();
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        fieldsLoad.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("TYPE_POINT_CONNEXION")).get(0));
        this.gridForm.loadXML(fieldsLoad, false);
        this.nodeInterfacesFilledByLinkList.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("REGLE_NOEUD_LIEN")), true);
        this.linkInterfacesFilledByNodeList.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("REGLE_LIEN_NOEUD")), true);
    }
}

