/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GKnowledgeBase.GKnowledgeBase;
import GMessage.GMessage;
import GModel.GModel;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetOKCancel;
import GWindow.GWindow;
import jEditInterface.VisualFigaro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Element;

public class GWindowNewObject
extends GWindow {
    private static final long serialVersionUID = 1L;
    private VisualFigaro vfParent;
    private GModel currentModel;
    private GKnowledgeBase knowledgeBase;
    private JPanel framePanel;
    private JPanel logoPanel;
    private JPanel fieldsPanel;
    private GWidgetOKCancel okCancelWidget;
    private JPanel centerPanel;
    private JTextField objectName;
    private JComboBox classBx;
    private JPanel constantPanel;
    private JPanel attributPanel;
    private JPanel interfacePanel;
    private Vector<JTextField> constantLabel;
    private Vector<JTextField> constantText;
    private Vector<JTextField> attributLabel;
    private Vector<JTextField> attributText;
    private Vector<JTextField> interfaceLabel;
    private Vector<JTextField> interfaceText;

    public GWindowNewObject(VisualFigaro vf, GObject p, GObjectInformation info, GModel model) {
        super(p, info);
        this.vfParent = vf;
        this.currentModel = model;
        this.knowledgeBase = model.getKnowledgeBase();
        this.framePanel = new JPanel(new BorderLayout());
        this.initializeLogoPart();
        this.framePanel.add((Component)this.logoPanel, "North");
        this.initializeFieldPart();
        this.framePanel.add((Component)this.fieldsPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.setSize(700, 600);
        this.setResizable(false);
        this.setTitle("New Object");
    }

    private void initializeLogoPart() {
        this.logoPanel = new JPanel(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "logoEDF.gif");
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(imageIcon);
        this.logoPanel.add((Component)iconLabel, "West");
        JLabel titleLabel = new JLabel("Create New Object  ");
        this.logoPanel.add((Component)titleLabel, "East");
    }

    private void initializeFieldPart() {
        this.fieldsPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new GridLayout(0, 2));
        northPanel.setPreferredSize(new Dimension(500, 40));
        JPanel infoPanel = new JPanel(new GridLayout(0, 2));
        String kBName = this.knowledgeBase.getKnowledgeBaseName();
        int pos = kBName.lastIndexOf(92);
        kBName = kBName.substring(pos + 1);
        String modelName = this.currentModel.getModelName();
        pos = modelName.lastIndexOf(92);
        modelName = modelName.substring(pos + 1);
        infoPanel.add(new JLabel("Knowledge Base : "));
        infoPanel.add(new JLabel(kBName));
        infoPanel.add(new JLabel("Model : "));
        infoPanel.add(new JLabel(modelName));
        northPanel.add(infoPanel);
        JPanel classPanel = new JPanel(new GridLayout(0, 2));
        classPanel.add(new JLabel("Object Name : "));
        this.objectName = new JTextField();
        classPanel.add(this.objectName);
        classPanel.add(new JLabel("Object Class : "));
        this.classBx = this.selectKBClass();
        this.classBx.setSelectedIndex(-1);
        classPanel.add(this.classBx);
        northPanel.add(classPanel);
        this.fieldsPanel.add((Component)northPanel, "North");
    }

    private JComboBox selectKBClass() {
        JComboBox<String> clbx = new JComboBox<String>();
        Vector<String> cllist = figaroLoader.findTypesName();
        for (String cl : cllist) {
            clbx.addItem(cl);
        }
        clbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GWindowNewObject.this.fieldsPanel.remove(GWindowNewObject.this.centerPanel);
                }
                catch (Exception except) {
                    System.out.println("Initialization (centerPanel not added)");
                }
                GWindowNewObject.this.centerPanel = new JPanel(new GridLayout(1, 3));
                GWindowNewObject.this.centerPanel.setPreferredSize(new Dimension(500, 420));
                GWindowNewObject.this.constantPanel = GWindowNewObject.this.buildConstantPanel();
                GWindowNewObject.this.attributPanel = GWindowNewObject.this.buildAttributPanel();
                GWindowNewObject.this.interfacePanel = GWindowNewObject.this.buildInterfacePanel();
                GWindowNewObject.this.centerPanel.add(GWindowNewObject.this.constantPanel);
                GWindowNewObject.this.centerPanel.add(GWindowNewObject.this.attributPanel);
                GWindowNewObject.this.centerPanel.add(GWindowNewObject.this.interfacePanel);
                GWindowNewObject.this.fieldsPanel.add((Component)GWindowNewObject.this.centerPanel, "Center");
                GWindowNewObject.this.fieldsPanel.revalidate();
                GWindowNewObject.this.fieldsPanel.repaint();
                GWindowNewObject.this.framePanel.repaint();
            }
        });
        return clbx;
    }

    private JPanel buildConstantPanel() {
        JPanel constPanel = new JPanel(new GridLayout(0, 2));
        TitledBorder border = BorderFactory.createTitledBorder("Constants");
        this.constantLabel = new Vector();
        this.constantText = new Vector();
        constPanel.setBorder(border);
        if (this.classBx.getSelectedIndex() > -1) {
            String selectedClass = this.classBx.getItemAt(this.classBx.getSelectedIndex()).toString();
            while (!selectedClass.equals("FIGARO")) {
                List<Element> constants = this.getClassElements(selectedClass, "CONSTANT");
                if (constants != null && !constants.isEmpty()) {
                    for (Element e : constants) {
                        Boolean overloaded = false;
                        String constname = e.getChild("NAME").getValue();
                        if (!this.constantLabel.isEmpty()) {
                            for (JTextField c : this.constantLabel) {
                                if (!c.getText().equals(constname)) continue;
                                overloaded = true;
                            }
                        }
                        if (overloaded.booleanValue()) continue;
                        this.constantLabel.add(new JTextField(constname));
                        this.constantText.add(new JTextField());
                    }
                }
                selectedClass = this.getClassFather(selectedClass);
            }
            int sizey = 15;
            if (this.constantLabel.size() > sizey) {
                sizey = this.constantLabel.size();
            }
            JPanel leftPanel = new JPanel(new GridLayout(sizey, 0));
            JPanel rightPanel = new JPanel(new GridLayout(sizey, 0));
            int i = 0;
            while (i < this.constantLabel.size()) {
                this.constantLabel.get(i).setEditable(false);
                leftPanel.add(this.constantLabel.get(i));
                rightPanel.add(this.constantText.get(i));
                ++i;
            }
            constPanel.add(leftPanel);
            constPanel.add(rightPanel);
        }
        return constPanel;
    }

    private JPanel buildAttributPanel() {
        JPanel attrPanel = new JPanel(new GridLayout(0, 2));
        TitledBorder border = BorderFactory.createTitledBorder("Attributes");
        this.attributLabel = new Vector();
        this.attributText = new Vector();
        attrPanel.setBorder(border);
        if (this.classBx.getSelectedIndex() > -1) {
            String selectedClass = this.classBx.getItemAt(this.classBx.getSelectedIndex()).toString();
            while (!selectedClass.equals("FIGARO")) {
                List<Element> attributs = this.getClassElements(selectedClass, "ATTRIBUT");
                if (attributs != null && !attributs.isEmpty()) {
                    for (Element e : attributs) {
                        Boolean overloaded = false;
                        String attrname = e.getChild("NAME").getValue();
                        if (!this.attributLabel.isEmpty()) {
                            for (JTextField c : this.attributLabel) {
                                if (!c.getText().equals(attrname)) continue;
                                overloaded = true;
                            }
                        }
                        if (overloaded.booleanValue()) continue;
                        this.attributLabel.add(new JTextField(attrname));
                        this.attributText.add(new JTextField());
                    }
                }
                selectedClass = this.getClassFather(selectedClass);
            }
            int sizey = 15;
            if (this.attributLabel.size() > sizey) {
                sizey = this.attributLabel.size();
            }
            JPanel leftPanel = new JPanel(new GridLayout(sizey, 0));
            JPanel rightPanel = new JPanel(new GridLayout(sizey, 0));
            int i = 0;
            while (i < this.attributLabel.size()) {
                this.attributLabel.get(i).setEditable(false);
                leftPanel.add(this.attributLabel.get(i));
                rightPanel.add(this.attributText.get(i));
                ++i;
            }
            attrPanel.add(leftPanel);
            attrPanel.add(rightPanel);
        }
        return attrPanel;
    }

    private JPanel buildInterfacePanel() {
        JPanel interPanel = new JPanel(new GridLayout(0, 2));
        TitledBorder border = BorderFactory.createTitledBorder("Interfaces");
        this.interfaceLabel = new Vector();
        this.interfaceText = new Vector();
        interPanel.setBorder(border);
        if (this.classBx.getSelectedIndex() > -1) {
            String selectedClass = this.classBx.getItemAt(this.classBx.getSelectedIndex()).toString();
            while (!selectedClass.equals("FIGARO")) {
                List<Element> interfaces = this.getClassElements(selectedClass, "INTERFACE");
                if (interfaces != null && !interfaces.isEmpty()) {
                    for (Element e : interfaces) {
                        Boolean overloaded = false;
                        String intername = e.getChild("NAME").getValue();
                        if (!this.interfaceLabel.isEmpty()) {
                            for (JTextField c : this.interfaceLabel) {
                                if (!c.getText().equals(intername)) continue;
                                overloaded = true;
                            }
                        }
                        if (overloaded.booleanValue()) continue;
                        this.interfaceLabel.add(new JTextField(intername));
                        this.interfaceText.add(new JTextField());
                    }
                }
                selectedClass = this.getClassFather(selectedClass);
            }
            int sizey = 15;
            if (this.interfaceLabel.size() > sizey) {
                sizey = this.interfaceLabel.size();
            }
            JPanel leftPanel = new JPanel(new GridLayout(sizey, 0));
            JPanel rightPanel = new JPanel(new GridLayout(sizey, 0));
            int i = 0;
            while (i < this.interfaceLabel.size()) {
                this.interfaceLabel.get(i).setEditable(false);
                leftPanel.add(this.interfaceLabel.get(i));
                rightPanel.add(this.interfaceText.get(i));
                ++i;
            }
            interPanel.add(leftPanel);
            interPanel.add(rightPanel);
        }
        return interPanel;
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                if (!this.objectName.getText().isEmpty()) {
                    this.saveObject();
                    this.dispose();
                    break;
                }
                JOptionPane.showMessageDialog(this, "Give a name to the object first !");
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowNewObject : Unknown message received");
            }
        }
    }

    private String getClassFather(String clname) {
        String father = "";
        Element elclass = figaroLoader.findType(clname);
        father = elclass.getChild("FATHER").getValue();
        return father;
    }

    private List<Element> getClassElements(String clname, String key) {
        Element elclass = figaroLoader.findType(clname);
        List results = elclass.getChildren(key);
        return results;
    }

    public void saveObject() {
        String interfac;
        String attribut;
        String constant;
        String isa;
        String object;
        String Line = "";
        if (this.currentModel.getModelLanguage().getLanguage().equals("English")) {
            object = "OBJECT";
            isa = "IS_A";
            constant = "CONSTANT";
            attribut = "ATTRIBUTE";
            interfac = "INTERFACE";
        } else {
            object = "OBJET";
            isa = "EST_UN";
            constant = "CONSTANTE";
            attribut = "ATTRIBUT";
            interfac = "INTERFACE";
        }
        this.vfParent.getView().getTextArea().goToBufferEnd(false);
        this.addLine("\n", true);
        Line = String.valueOf(object) + " " + this.objectName.getText() + " " + isa + " " + this.classBx.getItemAt(this.classBx.getSelectedIndex()) + " ;";
        this.addLine(Line, true);
        Line = "\t" + constant;
        boolean firstLine = true;
        int i = 0;
        while (i < this.constantLabel.size()) {
            if (!this.constantText.get(i).getText().isEmpty()) {
                if (firstLine) {
                    firstLine = false;
                    this.addLine(Line, true);
                }
                Line = "\t\t" + this.constantLabel.get(i).getText() + " = " + this.constantText.get(i).getText() + " ;";
                this.addLine(Line, true);
            }
            ++i;
        }
        Line = "\t" + attribut;
        firstLine = true;
        i = 0;
        while (i < this.attributLabel.size()) {
            if (!this.attributText.get(i).getText().isEmpty()) {
                if (firstLine) {
                    firstLine = false;
                    this.addLine(Line, true);
                }
                Line = "\t\t" + this.attributLabel.get(i).getText() + " = " + this.attributText.get(i).getText() + " ;";
                this.addLine(Line, true);
            }
            ++i;
        }
        Line = "\t" + interfac;
        firstLine = true;
        i = 0;
        while (i < this.interfaceLabel.size()) {
            if (!this.interfaceText.get(i).getText().isEmpty()) {
                if (firstLine) {
                    firstLine = false;
                    this.addLine(Line, true);
                }
                Line = "\t\t" + this.interfaceLabel.get(i).getText() + " = " + this.interfaceText.get(i).getText() + " ;";
                this.addLine(Line, true);
            }
            ++i;
        }
    }

    public void addLine(String txt, boolean brk) {
        this.vfParent.getView().getTextArea().setSelectedText(txt);
        if (brk) {
            this.vfParent.getView().getTextArea().setSelectedText("\n");
        }
    }

    @Override
    public Element fillDocument() {
        return null;
    }

    @Override
    public void loadXml(Element e) {
    }
}

