/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import GCellRenderer.GLabelListCellRenderer;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GWindowShowIcon
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JList iconList;
    private DefaultListModel iconListModel;
    private String selectedIcon;

    public GWindowShowIcon(GObject p, GObjectInformation info) {
        File[] icons;
        this.getContentPane().setLayout(new BorderLayout());
        this.iconListModel = new DefaultListModel();
        this.iconList = new JList(this.iconListModel);
        this.iconList.setCellRenderer(new GLabelListCellRenderer());
        this.selectedIcon = "";
        File iconFolderFile = new File(String.valueOf(info.getKnowledgeBasePath()) + "\\icons");
        File[] fileArray = icons = iconFolderFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".ico");
            }
        });
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            File iconFile = fileArray[n2];
            Image iconImage = this.loadIcon(iconFile);
            JLabel iconLabel = new JLabel(iconFile.getName().substring(0, iconFile.getName().indexOf(".")));
            iconLabel.setIcon(new ImageIcon(iconImage));
            this.iconListModel.addElement(iconLabel);
            ++n2;
        }
        JScrollPane scrollPane = new JScrollPane(this.iconList);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel okCancelPanel = new JPanel(new BorderLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowShowIcon.this.setSelectedIcon();
                GWindowShowIcon.this.dispose();
            }
        });
        okCancelPanel.add((Component)okButton, "West");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowShowIcon.this.discardSelectedIcon();
                GWindowShowIcon.this.dispose();
            }
        });
        okCancelPanel.add((Component)cancelButton, "East");
        this.getContentPane().add((Component)okCancelPanel, "South");
        this.setTitle("Icon Browser");
        this.pack();
    }

    private Image loadIcon(File iconFile) {
        if (!iconFile.exists()) {
            return null;
        }
        ICOFile icon = null;
        try {
            icon = new ICOFile(iconFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("VisualFigaro : GWindowDefaultVarNode : Error while reading the icon file : " + iconFile + " ." + e);
        }
        BitmapDescriptor bmpdesc = icon.getDescriptor(0);
        Image image = bmpdesc.getImageRGB();
        return image;
    }

    public void setSelectedIcon() {
        this.selectedIcon = this.iconList.getSelectedIndex() >= 0 ? ((JLabel)this.iconListModel.getElementAt(this.iconList.getSelectedIndex())).getText() : "";
    }

    public void discardSelectedIcon() {
        this.selectedIcon = "";
    }

    public String getSelectedIcon() {
        return this.selectedIcon;
    }
}

