/*
 * Decompiled with CFR 0.152.
 */
package GWindow;

import Factories.GXMLElementFactory;
import GIcon.GIcon;
import GMessage.GMessage;
import GObject.GObject;
import GObjectInformation.GObjectInformation;
import GWidget.GWidgetControledList;
import GWidget.GWidgetExpression;
import GWidget.GWidgetGridForm;
import GWidget.GWidgetLoadIcon;
import GWidget.GWidgetOKCancel;
import GWidget.GWidgetTextField;
import GWindow.GWindow;
import GWindow.GWindowNameAsker;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import global.ControlTypes;
import global.ListTypes;
import global.Messages;
import global.NameRetrieverClasses;
import global.WidgetClasses;
import global.WindowClasses;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import org.gjt.sp.jedit.jEdit;
import org.jdom.Element;

public class GWindowVarNode
extends GWindow {
    private static final long serialVersionUID = 1L;
    private JMenuBar menuBar;
    private JMenu menu;
    private JRadioButtonMenuItem inheritanceItem;
    private JRadioButtonMenuItem definitionItem;
    private GWidgetOKCancel okCancelWidget;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JPanel inheritancePanel;
    private GWidgetGridForm inheritanceGridForm;
    private JPanel definitionPanel;
    private GWidgetTextField nameTextField;
    private JTabbedPane tabs;
    private JPanel firstPanel;
    private GWidgetControledList visualisationList;
    private GWidgetTextField conditionTextField;
    private JPanel secondPanel;
    private GWidgetGridForm generalCharacteristicsGridForm;
    private GWidgetLoadIcon loadIcon;
    private JPanel thirdPanel;
    private GWidgetExpression expressionWidget;
    private GWidgetGridForm colorPositionGridForm;
    private int position;

    @Deprecated
    public GWindowVarNode(GObject p, GObjectInformation info) {
        super(p, info);
        this.position = -1;
        this.initialization();
    }

    public GWindowVarNode(GObject p, GObjectInformation info, int pos) {
        super(p, info);
        this.position = pos;
        this.initialization();
    }

    private void initialization() {
        this.inheritancePanelInitialization();
        this.defineInitialization();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)this.inheritancePanel, "inherit");
        this.cardPanel.add((Component)this.definitionPanel, "defined");
        this.framePanel.add((Component)this.cardPanel, "Center");
        this.okCancelWidget = new GWidgetOKCancel(this, this.information);
        this.framePanel.add((Component)this.okCancelWidget, "South");
        this.add(this.framePanel);
        this.pack();
        this.setTitle("Graphic Variant");
        this.setSize(550, 320);
        this.menuBarInitialization();
    }

    private void menuBarInitialization() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Definition");
        this.menuBar.add(this.menu);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.inheritanceItem = new JRadioButtonMenuItem("Inherit From Parent");
        this.inheritanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowVarNode.this.cardLayout.show(GWindowVarNode.this.cardPanel, "inherit");
            }
        });
        buttonGroup.add(this.inheritanceItem);
        this.menu.add(this.inheritanceItem);
        this.definitionItem = new JRadioButtonMenuItem("User Defined");
        this.definitionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWindowVarNode.this.cardLayout.show(GWindowVarNode.this.cardPanel, "defined");
            }
        });
        buttonGroup.add(this.definitionItem);
        this.menu.add(this.definitionItem);
        this.setJMenuBar(this.menuBar);
        this.inheritanceItem.setSelected(true);
    }

    private void inheritancePanelInitialization() {
        this.inheritancePanel = new JPanel(new BorderLayout());
        Vector<String> types = new Vector<String>();
        for (String s : figaroLoader.findAncestors(this.information.getTypeConcerned())) {
            System.err.println("voici s " + s);
            types.add(s);
        }
        Vector<String> labels = new Vector<String>();
        labels.add("Inherit Graphic Variant : ");
        labels.add("Inherit From Type : ");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COMBO);
        widgetClasses.add(WidgetClasses.COMBO);
        Vector<Vector<Object>> parameters = new Vector<Vector<Object>>();
        Vector<String> variantes = new Vector<String>();
        if (types.size() > 0) {
            for (String s : xmlLoader.findVariantesGraphiquesNames((String)types.get(0))) {
                variantes.add(s);
            }
        }
        parameters.add(variantes);
        parameters.add(types);
        this.inheritanceGridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, parameters);
        this.inheritancePanel.add((Component)this.inheritanceGridForm, "North");
    }

    private void defineInitialization() {
        this.definitionPanel = new JPanel(new BorderLayout());
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add((Component)new JLabel("Name : "), "West");
        this.nameTextField = new GWidgetTextField(this, this.information);
        textFieldPanel.add((Component)this.nameTextField, "Center");
        this.definitionPanel.add((Component)textFieldPanel, "North");
        this.tabsInitialization();
        this.definitionPanel.add((Component)this.tabs, "Center");
    }

    private void tabsInitialization() {
        this.tabs = new JTabbedPane();
        this.initializeFirstPanel();
        this.tabs.add("General", this.firstPanel);
        this.initializeSecondPanel();
        this.tabs.add("Icon", this.secondPanel);
        this.initializeThirdPanel();
        this.tabs.add("Text", this.thirdPanel);
    }

    private void initializeFirstPanel() {
        this.firstPanel = new JPanel(new BorderLayout());
        this.visualisationList = new GWidgetControledList(this, this.information, "Visualizations", null, ListTypes.SIMPLEARRAY, NameRetrieverClasses.TEXTRETRIEVER, ControlTypes.ADDDEL, WindowClasses.VISUALIZATION, null);
        this.firstPanel.add((Component)this.visualisationList, "North");
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)new JLabel("Condition : "), "West");
        this.conditionTextField = new GWidgetTextField(this, this.information);
        textPanel.add((Component)this.conditionTextField, "Center");
        this.firstPanel.add((Component)textPanel, "South");
    }

    private void initializeSecondPanel() {
        this.secondPanel = new JPanel(new BorderLayout());
        Vector<String> labels = new Vector<String>();
        labels.add("Main Color :");
        labels.add("Thickness :");
        labels.add("Background :");
        labels.add("File :");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.COLORCHOOSER);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.COLORCHOOSER);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        Vector<Vector<Object>> objectArgs = new Vector<Vector<Object>>();
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        objectArgs.add(null);
        this.generalCharacteristicsGridForm = new GWidgetGridForm(this, this.information, labels, 4, 2, widgetClasses, objectArgs);
        this.secondPanel.add((Component)this.generalCharacteristicsGridForm, "North");
        Image image = this.loadIcon(String.valueOf(jEdit.getJEditHome()) + "/VisualFigaro/" + "test.ico");
        this.loadIcon = new GWidgetLoadIcon(this, this.information, image);
        this.secondPanel.add((Component)this.loadIcon, "South");
    }

    private void initializeThirdPanel() {
        this.thirdPanel = new JPanel(new BorderLayout());
        Vector<String> labels = new Vector<String>();
        labels.add("FORMAT");
        labels.add("");
        Vector<WidgetClasses> widgetClasses = new Vector<WidgetClasses>();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.CONTROLEDLISTADDDEL);
        this.expressionWidget = new GWidgetExpression(this, this.information);
        this.thirdPanel.add((Component)this.expressionWidget, "Center");
        labels = new Vector();
        labels.add("Text Color : ");
        labels.add("Text Position : ");
        widgetClasses = new Vector();
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        widgetClasses.add(WidgetClasses.TEXTFIELD);
        this.colorPositionGridForm = new GWidgetGridForm(this, this.information, labels, 2, 2, widgetClasses, null);
        this.thirdPanel.add((Component)this.colorPositionGridForm, "South");
    }

    private Image loadIcon(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        ICOFile icon = null;
        try {
            icon = new ICOFile(file.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("VisualFigaro : GWindowDefaultVarNode : Error while reading the icon file : " + file + " ." + e);
        }
        BitmapDescriptor bmpdesc = icon.getDescriptor(0);
        Image image = bmpdesc.getImageRGB();
        return image;
    }

    private boolean copyFile(File origin, File destination) {
        try {
            int readCharacter;
            FileReader reader = new FileReader(origin);
            FileWriter writer = new FileWriter(destination);
            do {
                if ((readCharacter = reader.read()) == -1) continue;
                writer.write(readCharacter);
            } while (readCharacter != -1);
            reader.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be copied : " + e);
        }
        catch (IOException e) {
            System.err.println("Visual Figaro : VisualFigaro : The file cannot be copied : " + e);
        }
        return true;
    }

    @Override
    public void translateMessage(GMessage message) {
        switch (message.getMessage()) {
            case OK: {
                this.fillDocument();
                this.parent.translateMessage(new GMessage(this.information, Messages.ADDELEMENT, new Object[]{this.position, this.root}));
                this.dispose();
                break;
            }
            case CANCEL: {
                this.dispose();
                break;
            }
            case ICONCHOOSED: {
                GIcon messageIcons = null;
                try {
                    messageIcons = (GIcon)message.getArguments().get(0);
                }
                catch (Exception ex) {
                    System.err.println("Visual Figaro : GWindowDefaultVarNode : An exception occured during the processing of message : " + message + " : " + ex);
                    return;
                }
                if (messageIcons.isCompletePath()) {
                    GWindowNameAsker nameAskerWindow = new GWindowNameAsker(this, this.information, messageIcons.getPath());
                    nameAskerWindow.setModal(true);
                    nameAskerWindow.setAlwaysOnTop(true);
                    nameAskerWindow.setVisible(true);
                    File originIco = new File(messageIcons.getPath());
                    File originSym = new File(String.valueOf(messageIcons.getPath().substring(0, messageIcons.getPath().lastIndexOf("."))) + ".sym");
                    File destinationIco = new File(String.valueOf(this.information.getKnowledgeBasePath()) + "\\icons\\" + nameAskerWindow.getIconName() + ".ico");
                    File destinationSym = new File(String.valueOf(this.information.getKnowledgeBasePath()) + "\\icons\\" + nameAskerWindow.getIconName() + ".sym");
                    this.copyFile(originIco, destinationIco);
                    this.copyFile(originSym, destinationSym);
                    this.generalCharacteristicsGridForm.translateMessage(new GMessage(this.information, Messages.SENDTOWIDGET, new Object[]{3, new GMessage(this.information, Messages.REPLACEDEFAULTVALUES, new Object[]{nameAskerWindow.getIconName()})}));
                } else {
                    String symFileName = messageIcons.getPath().substring(messageIcons.getPath().lastIndexOf("\\") + 1, messageIcons.getPath().lastIndexOf("."));
                    this.generalCharacteristicsGridForm.translateMessage(new GMessage(this.information, Messages.SENDTOWIDGET, new Object[]{3, new GMessage(this.information, Messages.REPLACEDEFAULTVALUES, new Object[]{symFileName})}));
                }
                System.out.println("ICON CHOOSED");
                break;
            }
            case NOTIFYCHANGE: {
                System.out.println("Aarg first element : " + message.getArguments().get(0));
                if (message.getArguments().get(0) == null || this.inheritanceGridForm == null) break;
                String selectedItem = (String)message.getArguments().get(0);
                int emiter = -1;
                try {
                    emiter = Integer.parseInt(message.getSender().getLastPartOfThePath());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (emiter != 1) break;
                System.out.println("NOTIFYCHANGE : " + emiter + " : " + selectedItem);
                Vector<Object> arguments = new Vector<Object>();
                arguments.add(0);
                GMessage dummyMessage = new GMessage(this.information, Messages.REPLACEDEFAULTVALUES);
                for (String varName : xmlLoader.findVariantesGraphiquesNames(selectedItem)) {
                    dummyMessage.addArgument(varName);
                }
                arguments.add(dummyMessage);
                GMessage messageToEmit = new GMessage(this.information, Messages.SENDTOWIDGET, arguments);
                this.inheritanceGridForm.translateMessage(messageToEmit);
                break;
            }
            default: {
                System.out.println("VisualFigaro : GWindowDepart : Unknown message received");
            }
        }
    }

    @Override
    public Element fillDocument() {
        this.root = new Element(this.information.getLanguage().getBDCTranslation("VARIANTE_GRAPHIQUE"));
        if (this.inheritanceItem.isSelected()) {
            GXMLElementFactory.saveElements(this.root, this.inheritanceGridForm.saveXML());
        } else {
            GXMLElementFactory.saveElements(this.root, this.nameTextField.saveXML());
            GXMLElementFactory.saveElements(this.root, this.visualisationList.saveXML());
            GXMLElementFactory.saveElements(this.root, this.conditionTextField.saveXML());
            Element element = new Element(this.information.getLanguage().getBDCTranslation("ICONE"));
            GXMLElementFactory.saveElements(element, this.generalCharacteristicsGridForm.saveXML());
            GXMLElementFactory.saveElement(this.root, element);
            element = new Element(this.information.getLanguage().getBDCTranslation("TEXTE"));
            Element bufferElement = new Element("EXPRESSION");
            GXMLElementFactory.saveElements(bufferElement, this.expressionWidget.saveXML());
            GXMLElementFactory.saveElement(element, bufferElement);
            GXMLElementFactory.saveElements(element, this.colorPositionGridForm.saveXML());
            GXMLElementFactory.saveElement(this.root, element);
        }
        return this.root;
    }

    @Override
    public void loadXml(Element e) {
        if (e != null) {
            if (e.getChild(this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")) != null) {
                this.inheritanceItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "inherit");
            } else {
                this.definitionItem.setSelected(true);
                this.cardLayout.show(this.cardPanel, "defined");
            }
        }
        Vector<Element> elemVect = new Vector<Element>();
        elemVect.add(e);
        Vector<Element> inheritanceFields = new Vector<Element>();
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")).get(0));
        inheritanceFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("HERITE_DU_TYPE")).get(0));
        this.inheritanceGridForm.loadXML(inheritanceFields, false);
        this.nameTextField.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("NOM")), false);
        this.visualisationList.loadXML(GXMLElementFactory.refactorElements(elemVect, this.information.getLanguage().getBDCTranslation("VISUALISATION")), false);
        System.err.println("Test : " + GXMLElementFactory.refactorElements(elemVect, this.information.getLanguage().getBDCTranslation("VISUALISATION")).get(0) + " - " + GXMLElementFactory.refactorElements(elemVect, this.information.getLanguage().getBDCTranslation("VISUALISATION")).get(0).getText());
        this.conditionTextField.loadXML(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("CONDITION")), false);
        Vector<Element> iconFields = new Vector<Element>();
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_PPLAN")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("EPAISSEUR_TRAIT")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_FOND")).get(0));
        iconFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("FICHIER")).get(0));
        this.generalCharacteristicsGridForm.loadXML(iconFields, false);
        Vector<Element> expressionFields = new Vector<Element>();
        expressionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("FORMAT")).get(0));
        expressionFields.addAll(GXMLElementFactory.refactorElements(elemVect, this.information.getLanguage().getBDCTranslation("PARAMETRES")));
        this.expressionWidget.loadXML(expressionFields, false);
        Vector<Element> colorPositionFields = new Vector<Element>();
        colorPositionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("COULEUR_TEXTE")).get(0));
        colorPositionFields.add(GXMLElementFactory.refactorElement(e, this.information.getLanguage().getBDCTranslation("POSITION_TEXTE")).get(0));
        this.colorPositionGridForm.loadXML(colorPositionFields, false);
    }
}

