/*
 * Decompiled with CFR 0.152.
 */
package GXMLLoader;

import GFilters.GFilterElementWithSubElementWithValue;
import GFilters.GFilterTagName;
import GFilters.GFilterXMLTypes;
import GLanguage.GLanguage;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;

public class GXMLLoader {
    private Document document;
    private GLanguage language;

    public GXMLLoader(GLanguage language) {
        this.language = language;
    }

    public Document loadXmlFileJDOM(String path) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            this.document = sxb.build(new File(path));
        }
        catch (Exception e) {
            System.out.println("Erreur lors du chargement du fichier suivant : " + path);
            return null;
        }
        return this.document;
    }

    public org.w3c.dom.Document loadXmlFile(String path) {
        this.loadXmlFileJDOM(path);
        org.w3c.dom.Document documentDOM = null;
        DOMOutputter domOutputter = new DOMOutputter();
        try {
            documentDOM = domOutputter.output(this.document);
        }
        catch (Exception e) {
            return null;
        }
        return documentDOM;
    }

    public Vector<Element> getElementsAtDepth(int depth, Element e) {
        Vector<Element> result = new Vector<Element>();
        Vector<Object> tamponVect = new Vector();
        if (depth == 0) {
            result.add(e);
        } else {
            if (e == null) {
                return new Vector<Element>();
            }
            int i = 0;
            while (i < e.getContentSize()) {
                if (e.getContent(i) instanceof Element) {
                    tamponVect = this.getElementsAtDepth(depth - 1, (Element)e.getContent(i));
                    int j = 0;
                    while (j < tamponVect.size()) {
                        result.add((Element)tamponVect.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public Element findElementWithValue(Element e, int depth, String balise, String value) {
        Vector<Object> tamponVect = new Vector();
        tamponVect = this.getElementsAtDepth(depth, e);
        int i = 0;
        while (i < tamponVect.size()) {
            if (((Element)tamponVect.get(i)).getName().equals(balise) && ((Element)tamponVect.get(i)).getText().equals(value)) {
                return (Element)tamponVect.get(i);
            }
            ++i;
        }
        return null;
    }

    public Element findElementWithSubElementWithValue(Element e, int depth, String balise, String subBalise, String value) {
        Vector<Object> tamponVect = new Vector();
        tamponVect = this.getElementsAtDepth(depth, e);
        int i = 0;
        while (i < tamponVect.size()) {
            if (((Element)tamponVect.get(i)).getName().equals(balise) && this.findElementWithValue((Element)tamponVect.get(i), 1, subBalise, value) != null) {
                return (Element)tamponVect.get(i);
            }
            ++i;
        }
        return null;
    }

    public Vector<Element> findElementWithSubBalise(Element e, int depth, String balise, String subBalise) {
        Vector<Object> tamponVect = new Vector();
        Vector<Element> result = new Vector<Element>();
        tamponVect = this.getElementsAtDepth(depth, e);
        int i = 0;
        while (i < tamponVect.size()) {
            if (((Element)tamponVect.get(i)).getName().equals(balise) && ((Element)tamponVect.get(i)).getChild(subBalise) != null) {
                result.add((Element)tamponVect.get(i));
            }
            ++i;
        }
        return result;
    }

    public Element getRootElement() {
        if (this.document == null) {
            return null;
        }
        return this.document.getRootElement();
    }

    public Element findType(String name) {
        Vector possibleTypes = new Vector(this.document.getRootElement().getContent((Filter)new GFilterElementWithSubElementWithValue(this.language.getBDCTranslation("TYPE"), this.language.getBDCTranslation("NOM"), name)));
        if (possibleTypes.size() > 0) {
            return (Element)possibleTypes.get(0);
        }
        return null;
    }

    public Vector<Element> findTypes() {
        GFilterXMLTypes filterTypes = new GFilterXMLTypes(this.language);
        return new Vector<Element>(this.document.getRootElement().getContent((Filter)filterTypes));
    }

    public Vector<String> findVisualizations() {
        Vector<String> result = new Vector<String>();
        Vector elements = new Vector();
        elements.addAll(this.document.getRootElement().getContent((Filter)new GFilterTagName(this.language.getBDCTranslation("VISUALISATION"))));
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            result.add(((Element)iter.next()).getText());
        }
        return result;
    }

    public Vector<String> findMenus() {
        Vector<String> result = new Vector<String>();
        Vector elements = new Vector();
        elements.addAll(this.document.getRootElement().getContent((Filter)new GFilterTagName(this.language.getBDCTranslation("FAMILLE_TYPE_PALETTE"))));
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            result.add(((Element)iter.next()).getText());
        }
        return result;
    }

    public Vector<String> findNodes() {
        Vector<String> result = new Vector<String>();
        Vector<Element> types = this.findTypes();
        for (Element element : types) {
            if (element == null || element.getChild(this.language.getBDCTranslation("NOEUD")) == null) continue;
            result.add(element.getChildText(this.language.getBDCTranslation("NOM")));
        }
        return result;
    }

    public Vector<String> findLinks() {
        Vector<String> result = new Vector<String>();
        Vector<Element> types = this.findTypes();
        System.err.println("Recherche de liens");
        for (Element element : types) {
            if (element == null || element.getChild(this.language.getBDCTranslation("LIEN")) == null) continue;
            result.add(element.getChildText(this.language.getBDCTranslation("NOM")));
        }
        System.err.println("Liens trouves : " + result.size());
        return result;
    }

    public Vector<String> findVariantesGraphiquesNames(String typeName) {
        Vector<String> result = new Vector<String>();
        Element type = this.findType(typeName);
        if (type == null) {
            return result;
        }
        Iterator variantesGraphiquesIterator = type.getDescendants((Filter)new GFilterTagName(this.language.getBDCTranslation("VARIANTE_GRAPHIQUE")));
        while (variantesGraphiquesIterator.hasNext()) {
            result.add(((Element)variantesGraphiquesIterator.next()).getChildText(this.language.getBDCTranslation("NOM")));
        }
        return result;
    }

    public Vector<String> findPortsNames(String typeName) {
        Vector<String> result = new Vector<String>();
        Element type = this.findType(typeName);
        if (type == null) {
            return result;
        }
        if (type.getChild(this.language.getBDCTranslation("NOEUD")) == null) {
            return result;
        }
        Iterator pointConnexionIterator = type.getDescendants((Filter)new GFilterTagName(this.language.getBDCTranslation("POINT_CONNEXION")));
        while (pointConnexionIterator.hasNext()) {
            result.add(((Element)pointConnexionIterator.next()).getChildText(this.language.getBDCTranslation("NOM")));
        }
        return result;
    }
}

