/*
 * Decompiled with CFR 0.152.
 */
package GXMLLoader;

import GFilters.GFilterElementWithSubElementWithValue;
import GFilters.GFilterTagName;
import global.FilterTypes;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

public class GXMLLoaderFigaro {
    private Document document;
    private Element root;

    public Document loadXmlFileJDOM(String path) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            this.document = sxb.build(new File(path));
        }
        catch (Exception e) {
            System.out.println("Erreur lors du chargement du fichier suivant : " + path);
            return null;
        }
        return this.document;
    }

    public boolean setXmlFile(Document doc) {
        this.document = doc;
        this.root = doc.getRootElement();
        return true;
    }

    public Vector<String> findSteps() {
        Vector<String> result = new Vector<String>();
        Vector elements = new Vector();
        elements.addAll(this.root.getContent(this.createFilter(FilterTypes.STEP)));
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            result.add(((Element)iter.next()).getChildText("NAME"));
        }
        return result;
    }

    public Vector<String> findGroups() {
        Vector<String> result = new Vector<String>();
        Vector elements = new Vector();
        elements.addAll(this.root.getContent(this.createFilter(FilterTypes.GROUP)));
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            result.add(((Element)iter.next()).getChildText("NAME"));
        }
        return result;
    }

    public Vector<Element> findTypes() {
        return new Vector<Element>(this.root.getContent(this.createFilter(FilterTypes.TYPE)));
    }

    public Element findType(String name) {
        Vector possibleTypes = new Vector(this.root.getContent((Filter)new GFilterElementWithSubElementWithValue("CLASS", "NAME", name)));
        if (possibleTypes.size() > 0) {
            return (Element)possibleTypes.get(0);
        }
        return null;
    }

    public Vector<String> findTypesName() {
        Vector<String> result = new Vector<String>();
        Vector<Element> types = this.findTypes();
        Iterator<Element> iter = types.iterator();
        while (iter.hasNext()) {
            result.add(iter.next().getChildText("NAME"));
        }
        return result;
    }

    public Vector<String> findFathers(String name) {
        Vector<String> result = new Vector<String>();
        Element typeElement = this.findType(name);
        if (typeElement != null) {
            Vector fathers = new Vector(typeElement.getChildren("FATHER"));
            for (Element father : fathers) {
                result.addAll(this.findFathers(father.getChildText("NAME")));
            }
        }
        return result;
    }

    public Vector<String> findAncestors(String name) {
        System.err.println("We are looking for ancestors of type : " + name);
        Vector<String> result = new Vector<String>();
        Element typeElement = this.findType(name);
        if (typeElement == null) {
            return result;
        }
        Vector fathers = new Vector(typeElement.getChildren("FATHER"));
        for (Element father : fathers) {
            result.add(father.getText());
            result.addAll(this.findAncestors(father.getText()));
        }
        System.err.println("We have found " + result.size() + "ancestors");
        return result;
    }

    public Vector<String> findInterfaces(String name) {
        Vector<String> result = new Vector<String>();
        Element typeElement = this.findType(name);
        if (typeElement != null) {
            Vector<String> ancestors = this.findAncestors(name);
            ancestors.add(name);
            for (String ancestor : ancestors) {
                Vector interfaces;
                typeElement = this.findType(ancestor);
                if (typeElement == null || (interfaces = new Vector(typeElement.getChildren("INTERFACE"))) == null) continue;
                for (Element interf : interfaces) {
                    if (interf.getChildText("NAME") == null) continue;
                    result.add(interf.getChildText("NAME"));
                }
            }
        }
        return result;
    }

    private Filter createFilter(FilterTypes ft) {
        switch (ft) {
            case STEP: {
                return new GFilterTagName("STAGE");
            }
            case TYPE: {
                return new GFilterTagName("CLASS");
            }
            case GROUP: {
                return new GFilterTagName("GROUP");
            }
        }
        return null;
    }
}

